/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.node;

import io.polaris.core.jdbc.sql.BoundSql;
import io.polaris.core.jdbc.sql.PreparedSql;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.VarNameGenerator;
import io.polaris.core.jdbc.sql.node.VarNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class DynamicNode
extends VarNode
implements Cloneable {
    public DynamicNode(String varName) {
        super(varName);
    }

    @Override
    public PreparedSql asPreparedSql() {
        StringBuilder text = new StringBuilder();
        ArrayList<Object> list = new ArrayList<Object>();
        List<Object> parameters = this.getVarValues();
        if (parameters == null || parameters.isEmpty()) {
            text.append("?");
            list.add(null);
        } else {
            for (Object parameter : parameters) {
                if (text.length() > 0) {
                    text.append(",");
                }
                text.append("?");
                list.add(parameter);
            }
        }
        return new PreparedSql(text.toString(), list);
    }

    @Override
    public BoundSql asBoundSql(VarNameGenerator generator, String openVarToken, String closeVarToken) {
        List<Object> parameters = this.getVarValues();
        if (parameters == null || parameters.isEmpty()) {
            return new BoundSql(SqlNodes.NULL.getText(), Collections.emptyMap());
        }
        StringBuilder text = new StringBuilder();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Object parameter : parameters) {
            if (text.length() > 0) {
                text.append(",");
            }
            if (parameter == null) {
                text.append(SqlNodes.NULL.getText());
                continue;
            }
            String key = generator.generate();
            text.append(openVarToken).append(key).append(closeVarToken);
            map.put(key, parameter);
        }
        return new BoundSql(text.toString(), map);
    }

    @Override
    public boolean isDynamicNode() {
        return true;
    }

    @Override
    public DynamicNode copy() {
        return this.copy(true);
    }

    @Override
    public DynamicNode copy(boolean withVarValue) {
        DynamicNode clone = new DynamicNode(this.varName);
        if (withVarValue && this.varValues != null) {
            clone.varValue = this.varValue;
            clone.varValues = new ArrayList(this.varValues);
        }
        return clone;
    }

    public DynamicNode clone() {
        return this.copy(true);
    }
}

