/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.node;

import io.polaris.core.env.GlobalStdEnv;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.DynamicNode;
import io.polaris.core.jdbc.sql.node.MixedNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.node.VarNode;

public interface SqlNodes {
    public static final ContainerNode EMPTY = ContainerNode.EMPTY;
    public static final TextNode NULL = new TextNode("NULL");
    public static final TextNode BLANK = new TextNode(" ");
    public static final TextNode LF = new TextNode(GlobalStdEnv.get("jdbc.sql.line.separator", " "));
    public static final TextNode SELECT = new TextNode("SELECT ");
    public static final TextNode DELETE = new TextNode("DELETE ");
    public static final TextNode UPDATE = new TextNode("UPDATE ");
    public static final TextNode INSERT = new TextNode("INSERT ");
    public static final TextNode DISTINCT = new TextNode("DISTINCT ");
    public static final TextNode FROM = new TextNode("FROM ");
    public static final TextNode JOIN = new TextNode("JOIN ");
    public static final TextNode INNER_JOIN = new TextNode("INNER JOIN ");
    public static final TextNode LEFT_JOIN = new TextNode("LEFT OUTER JOIN ");
    public static final TextNode RIGHT_JOIN = new TextNode("RIGHT OUTER JOIN ");
    public static final TextNode OUTER_JOIN = new TextNode("OUTER JOIN ");
    public static final TextNode COMMA = new TextNode(", ");
    public static final TextNode EQUALS = new TextNode(" = ");
    public static final TextNode ON = new TextNode(" ON ");
    public static final TextNode WHERE = new TextNode("WHERE ");
    public static final TextNode AND = new TextNode(" AND ");
    public static final TextNode OR = new TextNode(" OR ");
    public static final TextNode NOT = new TextNode(" NOT ");
    public static final TextNode EXISTS = new TextNode(" EXISTS ");
    public static final TextNode NOT_EXISTS = new TextNode(" NOT EXISTS ");
    public static final TextNode LIKE = new TextNode(" LIKE ");
    public static final TextNode IN = new TextNode(" IN ");
    public static final TextNode NOT_IN = new TextNode(" NOT IN ");
    public static final TextNode GROUP_BY = new TextNode("GROUP BY ");
    public static final TextNode HAVING = new TextNode("HAVING ");
    public static final TextNode ORDER_BY = new TextNode("ORDER BY ");
    public static final TextNode ASC = new TextNode(" ASC");
    public static final TextNode DESC = new TextNode(" DESC");
    public static final TextNode SET = new TextNode("SET ");
    public static final TextNode INTO = new TextNode("INTO ");
    public static final TextNode VALUES = new TextNode("VALUES ");
    public static final TextNode LEFT_PARENTHESIS = new TextNode("( ");
    public static final TextNode RIGHT_PARENTHESIS = new TextNode(" )");
    public static final TextNode REPLACE = new TextNode("REPLACE ");
    public static final TextNode MERGE = new TextNode("MERGE ");
    public static final TextNode USING = new TextNode("USING ");
    public static final TextNode WHEN_MATCHED_THEN = new TextNode("WHEN MATCHED THEN ");
    public static final TextNode WHEN_NOT_MATCHED_THEN = new TextNode("WHEN NOT MATCHED THEN ");
    public static final TextNode ON_DUPLICATE_KEY_UPDATE = new TextNode("ON DUPLICATE KEY UPDATE ");
    public static final TextNode UNION = new TextNode("UNION");
    public static final TextNode UNION_ALL = new TextNode("UNION ALL");
    public static final TextNode INTERSECT = new TextNode("INTERSECT");
    public static final TextNode INTERSECT_ALL = new TextNode("INTERSECT ALL");
    public static final TextNode MINUS = new TextNode("MINUS");
    public static final TextNode MINUS_ALL = new TextNode("MINUS ALL");
    public static final TextNode EXCEPT = new TextNode("EXCEPT");
    public static final TextNode EXCEPT_ALL = new TextNode("EXCEPT ALL");

    public static ContainerNode group(SqlNode ... sqlNodes) {
        ContainerNode container = new ContainerNode();
        container.addNodes(sqlNodes);
        return container;
    }

    public static TextNode text(String text) {
        return new TextNode(text);
    }

    public static VarNode dynamic(String varName, Object varValue) {
        DynamicNode varNode = new DynamicNode(varName);
        varNode.bindVarValue(varValue);
        return varNode;
    }

    public static VarNode mixed(String varName, Object varValue) {
        MixedNode varNode = new MixedNode(varName);
        varNode.bindVarValue(varValue);
        return varNode;
    }
}

