/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang;

import io.polaris.core.assertion.Assertions;
import io.polaris.core.lang.Numbers;
import io.polaris.core.lang.Objs;
import io.polaris.core.string.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class BigDecimals {
    public static BigDecimal round(BigDecimal number, int scale, RoundingMode roundingMode) {
        if (null == number) {
            number = BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = 0;
        }
        if (null == roundingMode) {
            roundingMode = RoundingMode.HALF_UP;
        }
        return number.setScale(scale, roundingMode);
    }

    public static BigDecimal round(BigDecimal number, int scale) {
        return BigDecimals.round(number, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(String numberStr, int scale, RoundingMode roundingMode) {
        Assertions.assertTrue(Strings.isNotBlank(numberStr), "\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a\u767d");
        if (scale < 0) {
            scale = 0;
        }
        return BigDecimals.round(BigDecimals.toBigDecimal(numberStr), scale, roundingMode);
    }

    public static BigDecimal round(String numberStr, int scale) {
        return BigDecimals.round(numberStr, scale, RoundingMode.HALF_UP);
    }

    public static String roundAsString(String numberStr, int scale, RoundingMode roundingMode) {
        return BigDecimals.round(numberStr, scale, roundingMode).toPlainString();
    }

    public static String roundAsString(String numberStr, int scale) {
        return BigDecimals.round(numberStr, scale).toPlainString();
    }

    public static BigDecimal roundDown(BigDecimal value, int scale) {
        return BigDecimals.round(value, scale, RoundingMode.DOWN);
    }

    public static BigDecimal roundDown(Number number, int scale) {
        return BigDecimals.roundDown(BigDecimals.toBigDecimal(number), scale);
    }

    public static BigDecimal roundHalfEven(BigDecimal value, int scale) {
        return BigDecimals.round(value, scale, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal roundHalfEven(Number number, int scale) {
        return BigDecimals.roundHalfEven(BigDecimals.toBigDecimal(number), scale);
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return BigDecimals.toBigDecimal(number.toString());
    }

    public static BigDecimal toBigDecimal(String numberStr) {
        if (Strings.isBlank(numberStr)) {
            return BigDecimal.ZERO;
        }
        try {
            Number number = Numbers.parseNumber(numberStr);
            if (number instanceof BigDecimal) {
                return (BigDecimal)number;
            }
            return new BigDecimal(number.toString());
        }
        catch (Exception exception) {
            return new BigDecimal(numberStr);
        }
    }

    public static String toString(BigDecimal bigDecimal) {
        return BigDecimals.toString(bigDecimal, true);
    }

    public static String toString(BigDecimal bigDecimal, boolean isStripTrailingZeros) {
        Assertions.assertNotNull(bigDecimal, "BigDecimal is null !");
        if (isStripTrailingZeros) {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        return bigDecimal.toPlainString();
    }

    public static BigDecimal defaultIfNull(BigDecimal number, BigDecimal defaultValue) {
        return Objs.defaultIfNull(number, defaultValue);
    }

    public static BigDecimal defaultIfNull(BigDecimal number) {
        return Objs.defaultIfNull(number, BigDecimal.ZERO);
    }
}

