/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang;

import io.polaris.core.annotation.Experimental;
import io.polaris.core.lang.Numbers;
import io.polaris.core.string.Strings;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Stack;

@Experimental
class Calculator {
    private final Stack<String> postfixStack = new Stack();
    private final int[] operatPriority = new int[]{0, 3, 2, 1, -1, 1, 0, 2};

    Calculator() {
    }

    public static double conversion(String expression) {
        return new Calculator().calculate(expression);
    }

    public double calculate(String expression) {
        this.prepare(Calculator.transform(expression));
        Stack<String> resultStack = new Stack<String>();
        Collections.reverse(this.postfixStack);
        while (!this.postfixStack.isEmpty()) {
            String currentOp = this.postfixStack.pop();
            if (!this.isOperator(currentOp.charAt(0))) {
                currentOp = currentOp.replace("~", "-");
                resultStack.push(currentOp);
                continue;
            }
            String secondValue = (String)resultStack.pop();
            String firstValue = (String)resultStack.pop();
            firstValue = firstValue.replace("~", "-");
            secondValue = secondValue.replace("~", "-");
            BigDecimal tempResult = this.calculate(firstValue, secondValue, currentOp.charAt(0));
            resultStack.push(tempResult.toString());
        }
        return Numbers.mul(resultStack.toArray(new String[0])).doubleValue();
    }

    private void prepare(String expression) {
        Stack<Character> opStack = new Stack<Character>();
        opStack.push(Character.valueOf(','));
        char[] arr = expression.toCharArray();
        int currentIndex = 0;
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            char currentOp = arr[i];
            if (this.isOperator(currentOp)) {
                if (count > 0) {
                    this.postfixStack.push(new String(arr, currentIndex, count));
                }
                char peekOp = ((Character)opStack.peek()).charValue();
                if (currentOp == ')') {
                    while (((Character)opStack.peek()).charValue() != '(') {
                        this.postfixStack.push(String.valueOf(opStack.pop()));
                    }
                    opStack.pop();
                } else {
                    while (currentOp != '(' && peekOp != ',' && this.compare(currentOp, peekOp)) {
                        this.postfixStack.push(String.valueOf(opStack.pop()));
                        peekOp = ((Character)opStack.peek()).charValue();
                    }
                    opStack.push(Character.valueOf(currentOp));
                }
                count = 0;
                currentIndex = i + 1;
                continue;
            }
            ++count;
        }
        if (count > 1 || count == 1 && !this.isOperator(arr[currentIndex])) {
            this.postfixStack.push(new String(arr, currentIndex, count));
        }
        while (((Character)opStack.peek()).charValue() != ',') {
            this.postfixStack.push(String.valueOf(opStack.pop()));
        }
    }

    private boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '(' || c == ')' || c == '%';
    }

    private boolean compare(char cur, char peek) {
        int offset = 40;
        if (cur == '%') {
            cur = (char)47;
        }
        if (peek == '%') {
            peek = (char)47;
        }
        return this.operatPriority[peek - 40] >= this.operatPriority[cur - 40];
    }

    private BigDecimal calculate(String firstValue, String secondValue, char currentOp) {
        BigDecimal result;
        switch (currentOp) {
            case '+': {
                result = Numbers.add(firstValue, secondValue);
                break;
            }
            case '-': {
                result = Numbers.sub(firstValue, secondValue);
                break;
            }
            case '*': {
                result = Numbers.mul(firstValue, secondValue);
                break;
            }
            case '/': {
                result = Numbers.div(firstValue, secondValue);
                break;
            }
            case '%': {
                result = Numbers.toBigDecimal(firstValue).remainder(Numbers.toBigDecimal(secondValue));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + currentOp);
            }
        }
        return result;
    }

    private static String transform(String expression) {
        expression = (expression = Strings.cleanBlank(expression)).endsWith("=") ? expression.substring(0, expression.length() - 1) : expression;
        char[] arr = expression.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != '-') continue;
            if (i == 0) {
                arr[i] = 126;
                continue;
            }
            char c = arr[i - 1];
            if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(' && c != 'E' && c != 'e') continue;
            arr[i] = 126;
        }
        if (arr[0] == '~' && arr.length > 1 && arr[1] == '(') {
            arr[0] = 45;
            return "0" + new String(arr);
        }
        return new String(arr);
    }
}

