/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang;

import io.polaris.core.lang.TypeRef;
import io.polaris.core.lang.TypeRefs;
import io.polaris.core.lang.Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;

public class JavaType<T>
implements Type {
    private final Class<T> clazz;
    private final Type type;
    private Map<TypeVariable<?>, Type> typeVariableMap;

    protected JavaType(Type type) {
        this.type = type;
        this.clazz = Types.getClass(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static <T> JavaType<T> of(@Nonnull Type type) {
        if (type instanceof JavaType) {
            return JavaType.of(((JavaType)type).getRawType());
        }
        Map cache = CacheHolder.cache;
        JavaType<T> javaType = (JavaType<T>)cache.get(type);
        if (javaType != null) {
            return javaType;
        }
        Map map = cache;
        synchronized (map) {
            javaType = (JavaType)cache.get(type);
            if (javaType == null) {
                javaType = new JavaType<T>(type);
                cache.put(type, javaType);
            }
        }
        return javaType;
    }

    @Nonnull
    public static <T> JavaType<T> of(@Nonnull Class<T> clazz) {
        return JavaType.of(clazz);
    }

    @Nonnull
    public static <T> JavaType<T> of(@Nonnull TypeRef<T> type) {
        return JavaType.of(type.getType());
    }

    @Nonnull
    public static <T> JavaType<T> of(@Nonnull String typeName) throws ClassNotFoundException {
        return JavaType.of(TypeRefs.getType(typeName));
    }

    public Class<T> getRawClass() {
        return this.clazz;
    }

    public Type getRawType() {
        return this.type;
    }

    @Nonnull
    public Type[] getTypeArguments() {
        return Types.getTypeArguments(this.type);
    }

    public boolean isInstance(Object obj) {
        return this.clazz.isInstance(obj);
    }

    public boolean isEnum() {
        return this.clazz.isEnum();
    }

    public boolean isArray() {
        return this.clazz.isArray();
    }

    public T cast(Object obj) {
        return this.clazz.cast(obj);
    }

    @Nonnull
    public Map<TypeVariable<?>, Type> getTypeVariableMap() {
        if (this.typeVariableMap == null) {
            this.typeVariableMap = Types.getTypeVariableMap(this.type);
        }
        return this.typeVariableMap;
    }

    @Nonnull
    public Type getActualType(TypeVariable<?> typeVariable) {
        return (Type)((Object)this.getTypeVariableMap().getOrDefault(typeVariable, (Type)((Object)Object.class)));
    }

    @Nonnull
    public Type getActualType(Class<?> genericClass, int typeParameterIndex) {
        TypeVariable<Class<?>>[] typeParameters = genericClass.getTypeParameters();
        if (typeParameters.length <= typeParameterIndex) {
            throw new IndexOutOfBoundsException();
        }
        TypeVariable<Class<?>> variable = typeParameters[typeParameterIndex];
        return this.getActualType(variable);
    }

    public Type getArrayComponentType() {
        if (this.type instanceof GenericArrayType) {
            return ((GenericArrayType)this.type).getGenericComponentType();
        }
        return this.getRawClass().getComponentType();
    }

    @Override
    public String getTypeName() {
        return this.type instanceof Class ? ((Class)this.type).getCanonicalName() : this.type.getTypeName();
    }

    public String toString() {
        return "JavaType:" + this.getTypeName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaType javaType = (JavaType)o;
        return Objects.equals(this.type, javaType.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    private static class CacheHolder {
        private static final Map<Type, JavaType> cache = Collections.synchronizedMap(new WeakHashMap());

        private CacheHolder() {
        }
    }
}

