/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang;

import io.polaris.core.annotation.Experimental;
import io.polaris.core.assertion.Assertions;
import io.polaris.core.collection.Iterables;
import io.polaris.core.collection.ObjectArrays;
import io.polaris.core.collection.PrimitiveArrays;
import io.polaris.core.lang.BigDecimals;
import io.polaris.core.lang.BigIntegers;
import io.polaris.core.lang.Calculator;
import io.polaris.core.lang.Objs;
import io.polaris.core.lang.primitive.Chars;
import io.polaris.core.lang.primitive.Doubles;
import io.polaris.core.lang.primitive.Ints;
import io.polaris.core.random.Randoms;
import io.polaris.core.string.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

public class Numbers {
    private static final int DEFAULT_DIV_SCALE = 10;
    private static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

    @Experimental
    public static double calculate(String expression) {
        return Calculator.conversion(expression);
    }

    public static long floorDiv(long x, long y) {
        return Math.floorDiv(x, y);
    }

    public static int floorDiv(int x, int y) {
        return Math.floorDiv(x, y);
    }

    public static long ceilDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) > 0L && r * y != x) {
            ++r;
        }
        return r;
    }

    public static int ceilDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) > 0 && r * y != x) {
            ++r;
        }
        return r;
    }

    public static BigDecimal pow(Number number, int n) {
        return Numbers.pow(Numbers.toBigDecimal(number), n);
    }

    public static BigDecimal pow(BigDecimal number, int n) {
        return number.pow(n);
    }

    public static double add(float v1, float v2) {
        return Numbers.add(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double add(float v1, double v2) {
        return Numbers.add(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double add(double v1, float v2) {
        return Numbers.add(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double add(double v1, double v2) {
        return Numbers.add(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double add(Double v1, Double v2) {
        return Numbers.add((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal add(Number v1, Number v2) {
        return Numbers.add(new Number[]{v1, v2});
    }

    public static BigDecimal add(Number ... values) {
        if (values.length == 0) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = Numbers.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(Numbers.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal add(String ... values) {
        if (values.length == 0) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = Numbers.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (!Strings.isNotBlank(value)) continue;
            result = result.add(Numbers.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal add(BigDecimal ... values) {
        if (values.length == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = values[0];
        BigDecimal result = Numbers.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(value);
        }
        return result;
    }

    public static double sub(float v1, float v2) {
        return Numbers.sub(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double sub(float v1, double v2) {
        return Numbers.sub(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double sub(double v1, float v2) {
        return Numbers.sub(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double sub(double v1, double v2) {
        return Numbers.sub(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double sub(Double v1, Double v2) {
        return Numbers.sub((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal sub(Number v1, Number v2) {
        return Numbers.sub(new Number[]{v1, v2});
    }

    public static BigDecimal sub(Number ... values) {
        if (values.length == 0) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = Numbers.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(Numbers.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal sub(String ... values) {
        if (values.length == 0) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = Numbers.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (!Strings.isNotBlank(value)) continue;
            result = result.subtract(Numbers.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal sub(BigDecimal ... values) {
        if (values.length == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = values[0];
        BigDecimal result = Numbers.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(value);
        }
        return result;
    }

    public static double mul(float v1, float v2) {
        return Numbers.mul(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(float v1, double v2) {
        return Numbers.mul(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double mul(double v1, float v2) {
        return Numbers.mul(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(double v1, double v2) {
        return Numbers.mul(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double mul(Double v1, Double v2) {
        return Numbers.mul((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal mul(Number v1, Number v2) {
        return Numbers.mul(new Number[]{v1, v2});
    }

    public static BigDecimal mul(Number ... values) {
        if (values.length == 0 || Iterables.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = Numbers.toBigDecimal(value.toString());
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            result = result.multiply(Numbers.toBigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal mul(String v1, String v2) {
        return Numbers.mul((Number)Numbers.toBigDecimal(v1), (Number)Numbers.toBigDecimal(v2));
    }

    public static BigDecimal mul(String ... values) {
        if (values.length == 0 || Iterables.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = Numbers.toBigDecimal(values[0]);
        for (int i = 1; i < values.length; ++i) {
            result = result.multiply(Numbers.toBigDecimal(values[i]));
        }
        return result;
    }

    public static BigDecimal mul(BigDecimal ... values) {
        if (values.length == 0 || Iterables.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result = result.multiply(values[i]);
        }
        return result;
    }

    public static double div(float v1, float v2) {
        return Numbers.div(v1, v2, 10);
    }

    public static double div(float v1, double v2) {
        return Numbers.div(v1, v2, 10);
    }

    public static double div(double v1, float v2) {
        return Numbers.div(v1, v2, 10);
    }

    public static double div(double v1, double v2) {
        return Numbers.div(v1, v2, 10);
    }

    public static double div(Double v1, Double v2) {
        return Numbers.div(v1, v2, 10);
    }

    public static BigDecimal div(Number v1, Number v2) {
        return Numbers.div(v1, v2, 10);
    }

    public static BigDecimal div(String v1, String v2) {
        return Numbers.div(v1, v2, 10);
    }

    public static double div(float v1, float v2, int scale) {
        return Numbers.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(float v1, double v2, int scale) {
        return Numbers.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(double v1, float v2, int scale) {
        return Numbers.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(double v1, double v2, int scale) {
        return Numbers.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(Double v1, Double v2, int scale) {
        return Numbers.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(Number v1, Number v2, int scale) {
        return Numbers.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String v1, String v2, int scale) {
        return Numbers.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(float v1, float v2, int scale, RoundingMode roundingMode) {
        return Numbers.div(Float.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(float v1, double v2, int scale, RoundingMode roundingMode) {
        return Numbers.div(Float.toString(v1), Double.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(double v1, float v2, int scale, RoundingMode roundingMode) {
        return Numbers.div(Double.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(double v1, double v2, int scale, RoundingMode roundingMode) {
        return Numbers.div(Double.toString(v1), Double.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(Double v1, Double v2, int scale, RoundingMode roundingMode) {
        return Numbers.div((Number)v1, (Number)v2, scale, roundingMode).doubleValue();
    }

    public static BigDecimal div(Number v1, Number v2, int scale, RoundingMode roundingMode) {
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return Numbers.div((BigDecimal)v1, (BigDecimal)v2, scale, roundingMode);
        }
        return Numbers.div(Objs.toString(v1, null), Objs.toString(v2, null), scale, roundingMode);
    }

    public static BigDecimal div(String v1, String v2, int scale, RoundingMode roundingMode) {
        return Numbers.div(Numbers.toBigDecimal(v1), Numbers.toBigDecimal(v2), scale, roundingMode);
    }

    public static BigDecimal div(BigDecimal v1, BigDecimal v2, int scale, RoundingMode roundingMode) {
        Assertions.assertNotNull(v2, "Divisor must be not null !");
        if (null == v1) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = -scale;
        }
        return v1.divide(v2, scale, roundingMode);
    }

    public static BigDecimal round(double v, int scale) {
        return Numbers.round(v, scale, RoundingMode.HALF_UP);
    }

    public static String roundStr(double v, int scale) {
        return Numbers.round(v, scale).toPlainString();
    }

    public static BigDecimal round(String numberStr, int scale) {
        return BigDecimals.round(numberStr, scale);
    }

    public static BigDecimal round(BigDecimal number, int scale) {
        return BigDecimals.round(number, scale);
    }

    public static BigDecimal round(double v, int scale, RoundingMode roundingMode) {
        return Numbers.round(Double.toString(v), scale, roundingMode);
    }

    public static String roundStr(double v, int scale, RoundingMode roundingMode) {
        return Numbers.round(v, scale, roundingMode).toPlainString();
    }

    public static BigDecimal round(String numberStr, int scale, RoundingMode roundingMode) {
        return BigDecimals.round(numberStr, scale, roundingMode);
    }

    public static BigDecimal round(BigDecimal number, int scale, RoundingMode roundingMode) {
        return BigDecimals.round(number, scale, roundingMode);
    }

    public static BigDecimal roundHalfEven(Number number, int scale) {
        return BigDecimals.roundHalfEven(number, scale);
    }

    public static BigDecimal roundHalfEven(BigDecimal value, int scale) {
        return BigDecimals.roundHalfEven(value, scale);
    }

    public static BigDecimal roundDown(Number number, int scale) {
        return BigDecimals.roundDown(number, scale);
    }

    public static BigDecimal roundDown(BigDecimal value, int scale) {
        return BigDecimals.roundDown(value, scale);
    }

    public static String decimalFormat(String pattern, double value) {
        Assertions.assertTrue(Numbers.isValid(value), "value is NaN or Infinite!");
        return new DecimalFormat(pattern).format(value);
    }

    public static String decimalFormat(String pattern, long value) {
        return new DecimalFormat(pattern).format(value);
    }

    public static String decimalFormat(String pattern, Object value) {
        return Numbers.decimalFormat(pattern, value, null);
    }

    public static String decimalFormat(String pattern, Object value, RoundingMode roundingMode) {
        if (value instanceof Number) {
            Assertions.assertTrue(Numbers.isValidNumber((Number)value), "value is NaN or Infinite!");
        }
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        if (null != roundingMode) {
            decimalFormat.setRoundingMode(roundingMode);
        }
        return decimalFormat.format(value);
    }

    public static String decimalFormatMoney(double value) {
        return Numbers.decimalFormat(",##0.00", value);
    }

    public static String formatPercent(double number, int scale) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(scale);
        return format.format(number);
    }

    public static boolean isNumber(CharSequence str) {
        int i;
        int start;
        if (Strings.isBlank(str)) {
            return false;
        }
        char[] chars = str.toString().toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' || chars[0] == '+' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && (chars[start + 1] == 'x' || chars[start + 1] == 'X')) {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return false == allowSigns && foundDigit;
    }

    public static boolean isInteger(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isLong(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException ignore) {
            return false;
        }
        return s.contains(".");
    }

    public static boolean isPrime(int n) {
        Assertions.assertTrue(n > 1, "The number must be > 1");
        int i = 2;
        while ((double)i <= Math.sqrt(n)) {
            if (n % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int[] generateRandomNumber(int begin, int end, int size) {
        int[] seed = ObjectArrays.range(begin, end);
        return Numbers.generateRandomNumber(begin, end, size, seed);
    }

    public static int[] generateRandomNumber(int begin, int end, int size, int[] seed) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        Assertions.assertTrue(end - begin >= size, "Size is larger than range between begin and end!");
        Assertions.assertTrue(seed.length >= size, "Size is larger than seed size!");
        int[] ranArr = new int[size];
        for (int i = 0; i < size; ++i) {
            int j = Randoms.randomInt(seed.length - i);
            ranArr[i] = seed[j];
            seed[j] = seed[seed.length - 1 - i];
        }
        return ranArr;
    }

    public static Integer[] generateBySet(int begin, int end, int size) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        if (end - begin < size) {
            throw new IllegalArgumentException("Size is larger than range between begin and end!");
        }
        HashSet<Integer> set = new HashSet<Integer>(size, 1.0f);
        while (set.size() < size) {
            set.add(begin + Randoms.randomInt(end - begin));
        }
        return set.toArray(new Integer[0]);
    }

    public static int[] range(int stop) {
        return Numbers.range(0, stop);
    }

    public static int[] range(int start, int stop) {
        return Numbers.range(start, stop, 1);
    }

    public static int[] range(int start, int stop, int step) {
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            return new int[]{start};
        }
        int size = Math.abs((stop - start) / step) + 1;
        int[] values = new int[size];
        int index = 0;
        int i = start;
        while (step > 0 ? i <= stop : i >= stop) {
            values[index] = i;
            ++index;
            i += step;
        }
        return values;
    }

    public static Collection<Integer> appendRange(int start, int stop, Collection<Integer> values) {
        return Numbers.appendRange(start, stop, 1, values);
    }

    public static Collection<Integer> appendRange(int start, int stop, int step, Collection<Integer> values) {
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            values.add(start);
            return values;
        }
        int i = start;
        while (step > 0 ? i <= stop : i >= stop) {
            values.add(i);
            i += step;
        }
        return values;
    }

    public static BigInteger factorial(BigInteger n) {
        if (n.equals(BigInteger.ZERO)) {
            return BigInteger.ONE;
        }
        return Numbers.factorial(n, BigInteger.ZERO);
    }

    public static BigInteger factorial(BigInteger start, BigInteger end) {
        Assertions.assertNotNull(start, "Factorial start must be not null!");
        Assertions.assertNotNull(end, "Factorial end must be not null!");
        if (start.compareTo(BigInteger.ZERO) < 0 || end.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException(Strings.format("Factorial start and end both must be > 0, but got start={}, end={}", start, end));
        }
        if (start.equals(BigInteger.ZERO)) {
            start = BigInteger.ONE;
        }
        if (end.compareTo(BigInteger.ONE) < 0) {
            end = BigInteger.ONE;
        }
        BigInteger result = start;
        end = end.add(BigInteger.ONE);
        while (start.compareTo(end) > 0) {
            start = start.subtract(BigInteger.ONE);
            result = result.multiply(start);
        }
        return result;
    }

    public static long factorial(long start, long end) {
        if (start < 0L || end < 0L) {
            throw new IllegalArgumentException(Strings.format("Factorial start and end both must be >= 0, but got start={}, end={}", start, end));
        }
        if (0L == start || start == end) {
            return 1L;
        }
        if (start < end) {
            return 0L;
        }
        return Numbers.factorialMultiplyAndCheck(start, Numbers.factorial(start - 1L, end));
    }

    private static long factorialMultiplyAndCheck(long a, long b) {
        if (a <= Long.MAX_VALUE / b) {
            return a * b;
        }
        throw new IllegalArgumentException(Strings.format("Overflow in multiplication: {} * {}", a, b));
    }

    public static long factorial(long n) {
        if (n < 0L || n > 20L) {
            throw new IllegalArgumentException(Strings.format("Factorial must have n >= 0 and n <= 20 for n!, but got n = {}", n));
        }
        return FACTORIALS[(int)n];
    }

    public static long sqrt(long x) {
        long y = 0L;
        for (long b = 0x4000000000000000L; b > 0L; b >>= 2) {
            if (x >= y + b) {
                x -= y + b;
                y >>= 1;
                y += b;
                continue;
            }
            y >>= 1;
        }
        return y;
    }

    public static int processMultiple(int selectNum, int minNum) {
        int result = Numbers.mathSubNode(selectNum, minNum) / Numbers.mathNode(selectNum - minNum);
        return result;
    }

    private static int mathSubNode(int selectNum, int minNum) {
        if (selectNum == minNum) {
            return 1;
        }
        return selectNum * Numbers.mathSubNode(selectNum - 1, minNum);
    }

    private static int mathNode(int selectNum) {
        if (selectNum == 0) {
            return 1;
        }
        return selectNum * Numbers.mathNode(selectNum - 1);
    }

    public static int divisor(int m, int n) {
        while (m % n != 0) {
            int temp = m % n;
            m = n;
            n = temp;
        }
        return n;
    }

    public static int multiple(int m, int n) {
        return m * n / Numbers.divisor(m, n);
    }

    public static int compare(char x, char y) {
        return Character.compare(x, y);
    }

    public static int compare(double x, double y) {
        return Double.compare(x, y);
    }

    public static int compare(int x, int y) {
        return Integer.compare(x, y);
    }

    public static int compare(long x, long y) {
        return Long.compare(x, y);
    }

    public static int compare(short x, short y) {
        return Short.compare(x, y);
    }

    public static int compare(byte x, byte y) {
        return Byte.compare(x, y);
    }

    public static boolean isGreater(BigDecimal bigNum1, BigDecimal bigNum2) {
        Objects.requireNonNull(bigNum1);
        Objects.requireNonNull(bigNum2);
        return bigNum1.compareTo(bigNum2) > 0;
    }

    public static boolean isGreaterOrEqual(BigDecimal bigNum1, BigDecimal bigNum2) {
        Objects.requireNonNull(bigNum1);
        Objects.requireNonNull(bigNum2);
        return bigNum1.compareTo(bigNum2) >= 0;
    }

    public static boolean isLess(BigDecimal bigNum1, BigDecimal bigNum2) {
        Objects.requireNonNull(bigNum1);
        Objects.requireNonNull(bigNum2);
        return bigNum1.compareTo(bigNum2) < 0;
    }

    public static boolean isLessOrEqual(BigDecimal bigNum1, BigDecimal bigNum2) {
        Objects.requireNonNull(bigNum1);
        Objects.requireNonNull(bigNum2);
        return bigNum1.compareTo(bigNum2) <= 0;
    }

    public static boolean isIn(BigDecimal value, BigDecimal minInclude, BigDecimal maxInclude) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(minInclude);
        Objects.requireNonNull(maxInclude);
        return Numbers.isGreaterOrEqual(value, minInclude) && Numbers.isLessOrEqual(value, maxInclude);
    }

    public static boolean equals(double num1, double num2) {
        return Double.doubleToLongBits(num1) == Double.doubleToLongBits(num2);
    }

    public static boolean equals(float num1, float num2) {
        return Float.floatToIntBits(num1) == Float.floatToIntBits(num2);
    }

    public static boolean equals(long num1, long num2) {
        return num1 == num2;
    }

    public static boolean equals(Number number1, Number number2) {
        if (number1 instanceof BigDecimal && number2 instanceof BigDecimal) {
            return Numbers.equals((BigDecimal)number1, (BigDecimal)number2);
        }
        return Objects.equals(number1, number2);
    }

    public static boolean equals(BigDecimal bigNum1, BigDecimal bigNum2) {
        if (bigNum1 == bigNum2) {
            return true;
        }
        if (bigNum1 == null || bigNum2 == null) {
            return false;
        }
        return 0 == bigNum1.compareTo(bigNum2);
    }

    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        return Chars.equals(c1, c2, ignoreCase);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)ObjectArrays.min(numberArray);
    }

    public static long min(long ... numberArray) {
        return ObjectArrays.min(numberArray);
    }

    public static int min(int ... numberArray) {
        return ObjectArrays.min(numberArray);
    }

    public static short min(short ... numberArray) {
        return ObjectArrays.min(numberArray);
    }

    public static double min(double ... numberArray) {
        return ObjectArrays.min(numberArray);
    }

    public static float min(float ... numberArray) {
        return ObjectArrays.min(numberArray);
    }

    public static BigDecimal min(BigDecimal ... numberArray) {
        return (BigDecimal)ObjectArrays.min((Comparable[])numberArray);
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        return (T)ObjectArrays.max(numberArray);
    }

    public static long max(long ... numberArray) {
        return PrimitiveArrays.max(numberArray);
    }

    public static int max(int ... numberArray) {
        return PrimitiveArrays.max(numberArray);
    }

    public static short max(short ... numberArray) {
        return PrimitiveArrays.max(numberArray);
    }

    public static double max(double ... numberArray) {
        return PrimitiveArrays.max(numberArray);
    }

    public static float max(float ... numberArray) {
        return PrimitiveArrays.max(numberArray);
    }

    public static BigDecimal max(BigDecimal ... numberArray) {
        return (BigDecimal)ObjectArrays.max((Comparable[])numberArray);
    }

    public static String toBinaryString(Number number) {
        if (number instanceof Long) {
            return Long.toBinaryString((Long)number);
        }
        if (number instanceof Integer) {
            return Integer.toBinaryString((Integer)number);
        }
        return Long.toBinaryString(number.longValue());
    }

    public static String toString(Number number, String defaultValue) {
        return null == number ? defaultValue : Numbers.toString(number);
    }

    public static String toString(Number number) {
        return Numbers.toString(number, true);
    }

    public static String toString(Number number, boolean isStripTrailingZeros) {
        Assertions.assertNotNull(number, "Number is null !");
        if (number instanceof BigDecimal) {
            return Numbers.toString((BigDecimal)number, isStripTrailingZeros);
        }
        Assertions.assertTrue(Numbers.isValidNumber(number), "Number is non-finite!");
        String string = number.toString();
        if (isStripTrailingZeros && string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static String toString(BigDecimal bigDecimal) {
        return BigDecimals.toString(bigDecimal);
    }

    public static String toString(BigDecimal bigDecimal, boolean isStripTrailingZeros) {
        return BigDecimals.toString(bigDecimal, isStripTrailingZeros);
    }

    public static BigDecimal toBigDecimal(Number number) {
        return BigDecimals.toBigDecimal(number);
    }

    public static BigDecimal toBigDecimal(String numberStr) {
        return BigDecimals.toBigDecimal(numberStr);
    }

    public static BigInteger toBigInteger(Number number) {
        return BigIntegers.toBigInteger(number);
    }

    public static BigInteger toBigInteger(String number) {
        return BigIntegers.toBigInteger(number);
    }

    public static BigInteger newBigInteger(String str) {
        return BigIntegers.newBigInteger(str);
    }

    public static int parseInt(String number) throws NumberFormatException {
        if (Strings.isBlank(number)) {
            return 0;
        }
        if (Strings.indexOfIgnoreCase(number, "E") >= 0) {
            throw new NumberFormatException(Strings.format("Unsupported int format: [{}]", number));
        }
        if (Strings.startsWithIgnoreCase(number, "0x")) {
            return Integer.parseInt(number.substring(2), 16);
        }
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return Numbers.parseNumber(number).intValue();
        }
    }

    public static long parseLong(String number) {
        if (Strings.isBlank(number)) {
            return 0L;
        }
        if (number.startsWith("0x")) {
            return Long.parseLong(number.substring(2), 16);
        }
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return Numbers.parseNumber(number).longValue();
        }
    }

    public static float parseFloat(String number) {
        if (Strings.isBlank(number)) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(number);
        }
        catch (NumberFormatException e) {
            return Numbers.parseNumber(number).floatValue();
        }
    }

    public static double parseDouble(String number) {
        if (Strings.isBlank(number)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(number);
        }
        catch (NumberFormatException e) {
            return Numbers.parseNumber(number).doubleValue();
        }
    }

    public static Number parseNumber(String numberStr) throws NumberFormatException {
        if (Strings.startsWithIgnoreCase(numberStr, "0x")) {
            return Long.parseLong(numberStr.substring(2), 16);
        }
        if (numberStr.startsWith("+")) {
            numberStr = numberStr.substring(1);
        }
        try {
            NumberFormat format = NumberFormat.getInstance();
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setParseBigDecimal(true);
            }
            return format.parse(numberStr);
        }
        catch (ParseException e) {
            NumberFormatException nfe = new NumberFormatException(e.getMessage());
            nfe.initCause(e);
            throw nfe;
        }
    }

    public static Integer parseInt(String numberStr, Integer defaultValue) {
        if (Strings.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            return Numbers.parseInt(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Long parseLong(String numberStr, Long defaultValue) {
        if (Strings.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            return Numbers.parseLong(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Float parseFloat(String numberStr, Float defaultValue) {
        if (Strings.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Numbers.parseFloat(numberStr));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Double parseDouble(String numberStr, Double defaultValue) {
        if (Strings.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            return Numbers.parseDouble(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Number parseNumber(String numberStr, Number defaultValue) {
        if (Strings.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            return Numbers.parseNumber(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static byte[] toBytes(int value) {
        return Ints.toBytes(value);
    }

    public static int toInt(byte[] bytes) {
        return Ints.toInt(bytes);
    }

    public static byte[] toUnsignedByteArray(BigInteger value) {
        return BigIntegers.toUnsignedByteArray(value);
    }

    public static byte[] toUnsignedByteArray(int length, BigInteger value) {
        return BigIntegers.toUnsignedByteArray(length, value);
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf) {
        return BigIntegers.fromUnsignedByteArray(buf);
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf, int off, int length) {
        return BigIntegers.fromUnsignedByteArray(buf, off, length);
    }

    public static double toDouble(Number value) {
        return Doubles.toDouble(value);
    }

    public static boolean isBeside(long number1, long number2) {
        return Math.abs(number1 - number2) == 1L;
    }

    public static boolean isBeside(int number1, int number2) {
        return Math.abs(number1 - number2) == 1;
    }

    public static int partValue(int total, int partCount) {
        return Numbers.partValue(total, partCount, true);
    }

    public static int partValue(int total, int partCount, boolean isPlusOneWhenHasRem) {
        int partValue = total / partCount;
        if (isPlusOneWhenHasRem && total % partCount > 0) {
            ++partValue;
        }
        return partValue;
    }

    public static boolean isPowerOfTwo(long n) {
        return n > 0L && (n & n - 1L) == 0L;
    }

    public static boolean isValidNumber(Number number) {
        if (null == number) {
            return false;
        }
        if (number instanceof Double) {
            return !((Double)number).isInfinite() && !((Double)number).isNaN();
        }
        if (number instanceof Float) {
            return !((Float)number).isInfinite() && !((Float)number).isNaN();
        }
        return true;
    }

    public static boolean isValid(double number) {
        return !Double.isNaN(number) && !Double.isInfinite(number);
    }

    public static boolean isValid(float number) {
        return !Float.isNaN(number) && !Float.isInfinite(number);
    }

    public static boolean isOdd(int num) {
        return (num & 1) == 1;
    }

    public static boolean isEven(int num) {
        return !Numbers.isOdd(num);
    }
}

