/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang;

import io.polaris.core.collection.Iterables;
import io.polaris.core.collection.ObjectArrays;
import io.polaris.core.collection.comparator.Comparators;
import io.polaris.core.io.Serializations;
import io.polaris.core.lang.Numbers;
import io.polaris.core.lang.Types;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class Objs {
    public static boolean notEqual(Object obj1, Object obj2) {
        return !Objs.equals(obj1, obj2);
    }

    public static boolean equalsAny(Object obj, Object ... args) {
        for (Object arg : args) {
            if (!Objs.equals(obj, arg)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> T getIfEquals(T obj, T ... args) {
        int i = 0;
        while (i + 1 < args.length) {
            if (Objs.equals(args[i], obj)) {
                return args[i + 1];
            }
            i += 2;
        }
        if ((args.length & 1) == 0) {
            return null;
        }
        return args[args.length - 1];
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 instanceof Number && obj2 instanceof Number) {
            return Numbers.equals((Number)obj1, (Number)obj2);
        }
        return Objects.equals(obj1, obj2);
    }

    public static boolean deepEquals(Object a, Object b) {
        return Objects.deepEquals(a, b);
    }

    public static int hashCode(Object o) {
        return Objects.hashCode(o);
    }

    public static int hashCode(Object ... values) {
        return Arrays.hashCode(values);
    }

    @Nullable
    public static String toString(Object o) {
        return Objs.toString(o, null);
    }

    public static String toString(Object o, String nullDefault) {
        return o != null ? Iterables.toArrayString(o) : nullDefault;
    }

    @SafeVarargs
    public static <T> T coalesce(T ... args) {
        return Objs.coalesceNull(args);
    }

    @SafeVarargs
    public static <T> T coalesceNull(T ... args) {
        T arg;
        T v = null;
        T[] TArray = args;
        int n = TArray.length;
        for (int i = 0; i < n && (v = (T)(arg = TArray[i])) == null; ++i) {
        }
        return v;
    }

    @SafeVarargs
    public static <T> T coalesceEmpty(T ... args) {
        T arg;
        T v = null;
        T[] TArray = args;
        int n = TArray.length;
        for (int i = 0; i < n && Objs.isEmpty(v = (T)(arg = TArray[i])); ++i) {
        }
        return v;
    }

    @SafeVarargs
    public static <T> T coalesceBlank(T ... args) {
        T arg;
        T v = null;
        T[] TArray = args;
        int n = TArray.length;
        for (int i = 0; i < n && Objs.isBlank(v = (T)(arg = TArray[i])); ++i) {
        }
        return v;
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return Objs.isNull(object) ? defaultValue : object;
    }

    public static <T> T defaultIfNull(T source, Supplier<? extends T> defaultValueSupplier) {
        if (Objs.isNull(source)) {
            return defaultValueSupplier.get();
        }
        return source;
    }

    public static <T> T defaultIfNull(T source, Function<T, ? extends T> defaultValueSupplier) {
        if (Objs.isNull(source)) {
            return defaultValueSupplier.apply(null);
        }
        return source;
    }

    public static <T, R> T defaultIfNull(R source, Function<R, ? extends T> handle, T defaultValue) {
        if (Objs.isNotNull(source)) {
            return handle.apply(source);
        }
        return defaultValue;
    }

    public static <T> T defaultIfEmpty(String str, Function<CharSequence, ? extends T> handle, T defaultValue) {
        if (Strings.isNotEmpty(str)) {
            return handle.apply(str);
        }
        return defaultValue;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, T defaultValue) {
        return Strings.isEmpty(str) ? defaultValue : str;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, Supplier<? extends T> defaultValueSupplier) {
        if (Strings.isEmpty(str)) {
            return (T)((CharSequence)defaultValueSupplier.get());
        }
        return str;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, Function<T, ? extends T> defaultValueSupplier) {
        if (Strings.isEmpty(str)) {
            return (T)((CharSequence)defaultValueSupplier.apply(null));
        }
        return str;
    }

    public static <T extends CharSequence> T defaultIfBlank(T str, T defaultValue) {
        return Strings.isBlank(str) ? defaultValue : str;
    }

    public static <T extends CharSequence> T defaultIfBlank(T str, Supplier<? extends T> defaultValueSupplier) {
        if (Strings.isBlank(str)) {
            return (T)((CharSequence)defaultValueSupplier.get());
        }
        return str;
    }

    public static <T extends CharSequence> T defaultIfBlank(T str, Function<T, ? extends T> defaultValueSupplier) {
        if (Strings.isBlank(str)) {
            return (T)((CharSequence)defaultValueSupplier.apply(null));
        }
        return str;
    }

    public static <T> byte[] serialize(T obj) {
        return Serializations.serialize(obj);
    }

    public static <T> T deserialize(byte[] bytes, Class<?> ... acceptClasses) {
        return (T)Serializations.deserialize(bytes, acceptClasses);
    }

    public static <T> T clone(T obj) {
        T result = ObjectArrays.clone(obj);
        if (null == result) {
            result = obj instanceof Cloneable ? Reflects.invokeQuietly(obj, Reflects.getMethodByName(obj.getClass(), "clone"), new Object[0]) : Objs.cloneByStream(obj);
        }
        return result;
    }

    public static <T> T cloneIfPossible(T obj) {
        Object clone = null;
        try {
            clone = Objs.clone(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)(clone == null ? obj : clone);
    }

    public static <T> T cloneByStream(T obj) {
        return Serializations.clone(obj);
    }

    public static <T> int compare(T a, T b, Comparator<? super T> c) {
        return a == b ? 0 : c.compare(a, b);
    }

    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            return count;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        return -1;
    }

    public static boolean contains(Object obj, Object element) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            if (element == null) {
                return false;
            }
            return ((String)obj).contains(element.toString());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(element);
        }
        if (obj instanceof Map) {
            return ((Map)obj).containsValue(element);
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!Objs.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!Objs.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(obj, i);
                if (!Objs.equals(o, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static boolean isNotNull(Object obj) {
        return obj != null;
    }

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return Strings.isEmpty((CharSequence)obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Iterable) {
            return !((Iterable)obj).iterator().hasNext();
        }
        if (obj instanceof Iterator) {
            return !((Iterator)obj).hasNext();
        }
        if (ObjectArrays.isArray(obj)) {
            return ObjectArrays.isEmpty(obj);
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        return !Objs.isEmpty(obj);
    }

    public static boolean isBlank(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return Strings.isBlank((CharSequence)obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Iterable) {
            return !((Iterable)obj).iterator().hasNext();
        }
        if (obj instanceof Iterator) {
            return !((Iterator)obj).hasNext();
        }
        if (ObjectArrays.isArray(obj)) {
            return ObjectArrays.isEmpty(obj);
        }
        return false;
    }

    public static boolean isNotBlank(Object obj) {
        return !Objs.isBlank(obj);
    }

    public static boolean isPrimitiveOrWrapper(Object object) {
        if (null == object) {
            return false;
        }
        Class<?> c = object.getClass();
        return Types.isPrimitive(c) || Types.isPrimitiveWrapper(c);
    }

    public static boolean isValidIfNumber(Object obj) {
        if (obj instanceof Number) {
            return Numbers.isValidNumber((Number)obj);
        }
        return true;
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2) {
        return Comparators.compare(c1, c2);
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2, boolean nullGreater) {
        return Comparators.compare(c1, c2, nullGreater);
    }

    public static Class<?> getTypeArgument(Object obj) {
        return Objs.getTypeArgument(obj, 0);
    }

    public static Class<?> getTypeArgument(Object obj, int index) {
        Type type = Types.getTypeArgument(obj.getClass(), index);
        return type == null ? null : Types.getClass(type);
    }

    public static int emptyCount(Object ... objs) {
        return ObjectArrays.emptyCount(objs);
    }

    public static boolean hasNull(Object ... objs) {
        return ObjectArrays.hasNull(objs);
    }

    public static boolean hasEmpty(Object ... objs) {
        return ObjectArrays.hasEmpty(objs);
    }

    public static boolean isAllEmpty(Object ... objs) {
        return ObjectArrays.isAllEmpty(objs);
    }

    public static boolean isAllNotEmpty(Object ... objs) {
        return ObjectArrays.isAllNotEmpty(objs);
    }
}

