/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang;

import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import java.util.concurrent.Callable;

public class Retry {
    private static final ILogger log = ILoggers.of(Retry.class);

    public static <T> T doRetry(Callable<T> callable, int retryTimes, long sleepTimeInMilliSecond, Class<? extends Throwable> ... retryExceptionClasses) throws Exception {
        return Retry.doRetry(callable, retryTimes, sleepTimeInMilliSecond, false, retryExceptionClasses);
    }

    public static <T> T doRetry(Callable<T> callable, int retryTimes, long sleepTimeInMilliSecond, boolean exponential, Class<? extends Throwable> ... retryExceptionClasses) throws Exception {
        if (null == callable) {
            throw new IllegalArgumentException("\u5165\u53c2callable\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (retryTimes < 1) {
            throw new IllegalArgumentException("\u5165\u53c2retryTimes\u4e0d\u80fd\u5c0f\u4e8e1!");
        }
        Throwable saveException = null;
        for (int i = 0; i <= retryTimes; ++i) {
            try {
                return callable.call();
            }
            catch (Throwable e) {
                saveException = e;
                if (Retry.waitForRetry(i, retryTimes, sleepTimeInMilliSecond, exponential, saveException, retryExceptionClasses)) continue;
                throw saveException instanceof Exception ? (Exception)saveException : new RuntimeException(saveException);
            }
        }
        throw saveException instanceof Exception ? (Exception)saveException : new RuntimeException(saveException);
    }

    public static void doRetry(Runnable runnable, int retryTimes, long sleepTimeInMilliSecond, Class<? extends Throwable> ... retryExceptionClasses) {
        Retry.doRetry(runnable, retryTimes, sleepTimeInMilliSecond, false, retryExceptionClasses);
    }

    public static void doRetry(Runnable runnable, int retryTimes, long sleepTimeInMilliSecond, boolean exponential, Class<? extends Throwable> ... retryExceptionClasses) {
        if (null == runnable) {
            throw new IllegalArgumentException("\u5165\u53c2runnable\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (retryTimes < 1) {
            throw new IllegalArgumentException("\u5165\u53c2retryTimes\u4e0d\u80fd\u5c0f\u4e8e1!");
        }
        Throwable saveException = null;
        for (int i = 0; i <= retryTimes; ++i) {
            try {
                runnable.run();
                return;
            }
            catch (Throwable e) {
                saveException = e;
                if (Retry.waitForRetry(i, retryTimes, sleepTimeInMilliSecond, exponential, saveException, retryExceptionClasses)) continue;
                throw saveException instanceof RuntimeException ? (RuntimeException)saveException : new RuntimeException(saveException);
            }
        }
        throw saveException instanceof RuntimeException ? (RuntimeException)saveException : new RuntimeException(saveException);
    }

    private static boolean waitForRetry(int retryTime, int retryTimes, long sleepTimeInMilliSecond, boolean exponential, Throwable exception, Class<? extends Throwable>[] retryExceptionClasses) {
        boolean retryable = true;
        if (retryExceptionClasses != null && retryExceptionClasses.length > 0) {
            retryable = false;
            for (Class<? extends Throwable> retryExceptionClass : retryExceptionClasses) {
                if (!retryExceptionClass.isInstance(exception)) continue;
                retryable = true;
                break;
            }
        }
        if (!retryable) {
            return false;
        }
        if (retryTime < retryTimes) {
            if (sleepTimeInMilliSecond > 0L) {
                long sleepMills = sleepTimeInMilliSecond;
                if (exponential) {
                    sleepMills = sleepTimeInMilliSecond * (long)Math.pow(2.0, retryTime);
                }
                log.info("\u7a0b\u5e8f\u6267\u884c\u8fc7\u7a0b\u5931\u8d25! \u9884\u8ba1\u5728{}ms\u540e\u7b2c{}\u6b21\u91cd\u8bd5", sleepMills, retryTime + 1);
                try {
                    Thread.sleep(sleepMills);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                log.info("\u7a0b\u5e8f\u6267\u884c\u8fc7\u7a0b\u5931\u8d25! \u7b2c{}\u6b21\u91cd\u8bd5", retryTime + 1);
            }
        }
        return true;
    }
}

