/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class AnnotationInvocationHandler
implements InvocationHandler {
    private final Class<? extends Annotation> annotationType;
    private final Map<String, Object> memberValues;
    private volatile transient Method[] memberMethods = null;

    AnnotationInvocationHandler(Class<? extends Annotation> annotationType, Map<String, Object> values) {
        Class<?>[] interfaces = annotationType.getInterfaces();
        if (!annotationType.isAnnotation() || interfaces.length != 1 || interfaces[0] != Annotation.class) {
            throw new AnnotationFormatError("Attempt to create proxy for a non-annotation type.");
        }
        this.annotationType = annotationType;
        this.memberValues = values;
    }

    static <A extends Annotation> A createProxy(Class<A> annotationType, Map<String, Object> values) {
        ClassLoader classLoader = annotationType.getClassLoader();
        AnnotationInvocationHandler handler = new AnnotationInvocationHandler(annotationType, values);
        return (A)((Annotation)Proxy.newProxyInstance(classLoader, new Class[]{annotationType}, (InvocationHandler)handler));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String methodName = method.getName();
        if (method.getDeclaringClass() != this.annotationType) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (methodName.equals("equals") && parameterTypes.length == 1 && parameterTypes[0] == Object.class) {
                return this.equalsImpl(args[0]);
            }
            if (methodName.equals("hashCode") && parameterTypes.length == 0) {
                return this.hashCodeImpl();
            }
            if (methodName.equals("toString") && parameterTypes.length == 0) {
                return this.toStringImpl();
            }
            if (methodName.equals("annotationType") && parameterTypes.length == 0) {
                return this.annotationType;
            }
            throw new IllegalStateException("Unexpected method: " + method);
        }
        Object value = this.memberValues.get(methodName);
        if (value == null) {
            throw new IncompleteAnnotationException(this.annotationType, methodName);
        }
        if (value.getClass().isArray() && Array.getLength(value) != 0) {
            value = this.cloneArray(value);
        }
        return value;
    }

    private Object cloneArray(Object arr) {
        Class<?> arrType = arr.getClass();
        if (arrType == boolean[].class) {
            return ((boolean[])arr).clone();
        }
        if (arrType == byte[].class) {
            return ((byte[])arr).clone();
        }
        if (arrType == char[].class) {
            return ((char[])arr).clone();
        }
        if (arrType == double[].class) {
            return ((double[])arr).clone();
        }
        if (arrType == float[].class) {
            return ((float[])arr).clone();
        }
        if (arrType == int[].class) {
            return ((int[])arr).clone();
        }
        if (arrType == long[].class) {
            return ((long[])arr).clone();
        }
        if (arrType == short[].class) {
            return ((short[])arr).clone();
        }
        return ((Object[])arr).clone();
    }

    private String toStringImpl() {
        StringBuilder sb = new StringBuilder(128);
        sb.append('@');
        sb.append(this.annotationType.getName());
        sb.append('(');
        boolean first = true;
        for (Map.Entry<String, Object> next : this.memberValues.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(next.getKey());
            sb.append('=');
            sb.append(AnnotationInvocationHandler.memberValueToString(next.getValue()));
        }
        sb.append(')');
        return sb.toString();
    }

    private static String memberValueToString(Object val) {
        Class<?> valType = val.getClass();
        if (!valType.isArray()) {
            return val.toString();
        }
        if (valType == boolean[].class) {
            return Arrays.toString((boolean[])val);
        }
        if (valType == byte[].class) {
            return Arrays.toString((byte[])val);
        }
        if (valType == char[].class) {
            return Arrays.toString((char[])val);
        }
        if (valType == double[].class) {
            return Arrays.toString((double[])val);
        }
        if (valType == float[].class) {
            return Arrays.toString((float[])val);
        }
        if (valType == int[].class) {
            return Arrays.toString((int[])val);
        }
        if (valType == long[].class) {
            return Arrays.toString((long[])val);
        }
        if (valType == short[].class) {
            return Arrays.toString((short[])val);
        }
        return Arrays.toString((Object[])val);
    }

    private Boolean equalsImpl(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.annotationType.isInstance(obj)) {
            return false;
        }
        Method[] methods = this.getMemberMethods();
        AnnotationInvocationHandler targetHandler = this.asOneOfUs(obj);
        for (Method method : methods) {
            String name = method.getName();
            Object value = this.memberValues.get(name);
            Object targetValue = null;
            if (targetHandler != null) {
                targetValue = targetHandler.memberValues.get(name);
            } else {
                try {
                    targetValue = method.invoke(obj, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    return false;
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (AnnotationInvocationHandler.memberValueEquals(value, targetValue)) continue;
            return false;
        }
        return true;
    }

    private AnnotationInvocationHandler asOneOfUs(Object obj) {
        InvocationHandler handler;
        if (Proxy.isProxyClass(obj.getClass()) && (handler = Proxy.getInvocationHandler(obj)) instanceof AnnotationInvocationHandler) {
            return (AnnotationInvocationHandler)handler;
        }
        return null;
    }

    private static boolean memberValueEquals(Object value, Object target) {
        Class<?> valueType = value.getClass();
        if (!valueType.isArray()) {
            return value.equals(target);
        }
        if (value instanceof Object[] && target instanceof Object[]) {
            return Arrays.equals((Object[])value, (Object[])target);
        }
        if (target.getClass() != valueType) {
            return false;
        }
        if (valueType == boolean[].class) {
            return Arrays.equals((boolean[])value, (boolean[])target);
        }
        if (valueType == byte[].class) {
            return Arrays.equals((byte[])value, (byte[])target);
        }
        if (valueType == char[].class) {
            return Arrays.equals((char[])value, (char[])target);
        }
        if (valueType == double[].class) {
            return Arrays.equals((double[])value, (double[])target);
        }
        if (valueType == float[].class) {
            return Arrays.equals((float[])value, (float[])target);
        }
        if (valueType == int[].class) {
            return Arrays.equals((int[])value, (int[])target);
        }
        if (valueType == long[].class) {
            return Arrays.equals((long[])value, (long[])target);
        }
        if (valueType == short[].class) {
            return Arrays.equals((short[])value, (short[])target);
        }
        return false;
    }

    private Method[] getMemberMethods() {
        if (this.memberMethods == null) {
            Method[] methods = this.annotationType.getDeclaredMethods();
            ArrayList<Method> list = new ArrayList<Method>();
            for (Method method : methods) {
                if (method.getParameterCount() != 0 || method.getReturnType() == Void.TYPE) continue;
                list.add(method);
            }
            this.memberMethods = list.toArray(new Method[0]);
        }
        return this.memberMethods;
    }

    private int hashCodeImpl() {
        int hash = 0;
        for (Map.Entry<String, Object> next : this.memberValues.entrySet()) {
            String key = next.getKey();
            Object val = next.getValue();
            hash += 127 * key.hashCode() ^ AnnotationInvocationHandler.memberValueHashCode(val);
        }
        return hash;
    }

    private static int memberValueHashCode(Object value) {
        Class<?> valueType = value.getClass();
        if (!valueType.isArray()) {
            return value.hashCode();
        }
        if (valueType == boolean[].class) {
            return Arrays.hashCode((boolean[])value);
        }
        if (valueType == byte[].class) {
            return Arrays.hashCode((byte[])value);
        }
        if (valueType == char[].class) {
            return Arrays.hashCode((char[])value);
        }
        if (valueType == double[].class) {
            return Arrays.hashCode((double[])value);
        }
        if (valueType == float[].class) {
            return Arrays.hashCode((float[])value);
        }
        if (valueType == int[].class) {
            return Arrays.hashCode((int[])value);
        }
        if (valueType == long[].class) {
            return Arrays.hashCode((long[])value);
        }
        if (valueType == short[].class) {
            return Arrays.hashCode((short[])value);
        }
        return Arrays.hashCode((Object[])value);
    }
}

