/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean;

import io.polaris.core.lang.bean.CaseMode;
import io.polaris.core.string.Hex;
import java.util.Objects;

public class CaseModeOption {
    private static final CaseModeOption[] VALUES;
    private final int mode;

    private CaseModeOption(int mode) {
        this.mode = mode;
    }

    public static CaseModeOption empty() {
        return VALUES[0];
    }

    public static CaseModeOption all() {
        return VALUES[VALUES.length - 1];
    }

    public static CaseModeOption of(boolean caseInsensitive, boolean caseCamel) {
        int mode = 0;
        if (caseInsensitive) {
            mode |= CaseMode.INSENSITIVE.value();
        }
        if (caseCamel) {
            mode |= CaseMode.CAMEL.value();
        }
        return CaseModeOption.of(mode);
    }

    public static CaseModeOption of(CaseMode ... caseModes) {
        int mode = 0;
        for (CaseMode caseMode : caseModes) {
            mode |= caseMode.value();
        }
        return CaseModeOption.of(mode);
    }

    public static CaseModeOption of(int mode) {
        if (mode < 0 || mode >= VALUES.length) {
            mode &= VALUES.length - 1;
        }
        return VALUES[mode];
    }

    public CaseModeOption plus(CaseModeOption option) {
        return CaseModeOption.of(this.mode | option.mode);
    }

    public CaseModeOption plus(CaseMode caseMode) {
        return CaseModeOption.of(this.mode | caseMode.value());
    }

    public CaseModeOption minus(CaseModeOption option) {
        return CaseModeOption.of(this.mode & ~option.mode);
    }

    public CaseModeOption minus(CaseMode caseMode) {
        return CaseModeOption.of(this.mode & ~caseMode.value());
    }

    public int getMode() {
        return this.mode;
    }

    public boolean is(CaseMode caseMode) {
        return caseMode.is(this.mode);
    }

    public String toString() {
        return "CaseModeOption(" + Hex.formatBin(this.mode, CaseMode.values().length) + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CaseModeOption)) {
            return false;
        }
        CaseModeOption that = (CaseModeOption)o;
        return this.getMode() == that.getMode();
    }

    public int hashCode() {
        return Objects.hashCode(this.getMode());
    }

    static {
        int len = 1 << CaseMode.values().length;
        VALUES = new CaseModeOption[len];
        for (int i = 0; i < len; ++i) {
            CaseModeOption.VALUES[i] = new CaseModeOption(i);
        }
    }
}

