/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.copier;

import io.polaris.core.asm.reflect.BeanCopier;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.lang.Types;
import io.polaris.core.lang.bean.MetaObject;
import io.polaris.core.lang.copier.BeanToBeanCopier;
import io.polaris.core.lang.copier.BeanToMapCopier;
import io.polaris.core.lang.copier.Copier;
import io.polaris.core.lang.copier.CopyOptions;
import io.polaris.core.lang.copier.IndexedObjectCopier;
import io.polaris.core.lang.copier.MapToBeanCopier;
import io.polaris.core.lang.copier.MapToMapCopier;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.reflect.Reflects;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

public class Copiers {
    private static final ILogger log = ILoggers.of(Copiers.class);

    public static <E> E fastCopy(@Nonnull Object source, @Nonnull E target) {
        return Copiers.fastCopy(source.getClass(), source, target.getClass(), target);
    }

    public static <E> E fastCopy(@Nonnull Object source, @Nonnull Type targetType, @Nonnull E target) {
        return Copiers.fastCopy(source.getClass(), source, targetType, target);
    }

    public static <E> E fastCopy(@Nonnull Type sourceType, @Nonnull Object source, @Nonnull Type targetType, @Nonnull E target) {
        if (source instanceof Collection || target instanceof Collection || source.getClass().isArray() || target.getClass().isArray()) {
            return Copiers.deepCopyIndexed(source, targetType, target, CopyOptions.DEFAULT, false);
        }
        if (source instanceof Map) {
            if (target instanceof Map) {
                ((Map)target).putAll((Map)source);
            } else {
                BeanCopier.get(JavaType.of(targetType).getRawClass()).copyMapToBean((Map)source, target);
            }
        } else if (target instanceof Map) {
            BeanCopier.get(JavaType.of(sourceType).getRawClass()).copyBeanToMap(source, (Map)target);
        } else {
            BeanCopier.get(JavaType.of(sourceType).getRawClass()).copyBeanToBean(source, JavaType.of(targetType).getRawClass(), target);
        }
        return target;
    }

    public static <E> E fastCopy(@Nonnull Object source, @Nonnull E target, @Nonnull CopyOptions options) {
        return Copiers.fastCopy(source.getClass(), source, target.getClass(), target, options);
    }

    public static <E> E fastCopy(@Nonnull Object source, @Nonnull Type targetType, @Nonnull E target, @Nonnull CopyOptions options) {
        return Copiers.fastCopy(source.getClass(), source, targetType, target, options);
    }

    public static <E> E fastCopy(@Nonnull Type sourceType, @Nonnull Object source, @Nonnull Type targetType, @Nonnull E target, @Nonnull CopyOptions options) {
        if (source instanceof Collection || target instanceof Collection || source.getClass().isArray() || target.getClass().isArray()) {
            return Copiers.deepCopyIndexed(source, targetType, target, options, false);
        }
        if (source instanceof Map) {
            if (target instanceof Map) {
                new MapToMapCopier((Map)source, targetType, (Map)target, options).copy();
            } else {
                BeanCopier.get(JavaType.of(targetType).getRawClass()).copyMapToBean((Map<String, Object>)((Map)source), target, options);
            }
        } else if (target instanceof Map) {
            BeanCopier.get(JavaType.of(sourceType).getRawClass()).copyBeanToMap(source, (Map)target, options);
        } else {
            BeanCopier.get(JavaType.of(sourceType).getRawClass()).copyBeanToBean(source, JavaType.of(targetType).getRawClass(), target, options);
        }
        return target;
    }

    public static <S> Map<String, Object> fastCopyBeanToMap(@Nonnull S source, @Nonnull Map<String, Object> target) {
        return Copiers.fastCopyBeanToMap(source.getClass(), source, target);
    }

    public static <S> Map<String, Object> fastCopyBeanToMap(@Nonnull Class<S> sourceType, @Nonnull S source, @Nonnull Map<String, Object> target) {
        BeanCopier.get(sourceType).copyBeanToMap(source, target);
        return target;
    }

    public static <S, K, V> Map<K, V> fastCopyBeanToMap(@Nonnull Class<S> sourceType, @Nonnull S source, @Nonnull Type targetType, @Nonnull Map<K, V> target, BiFunction<Type, Object, Object> converter) {
        BeanCopier.get(sourceType).copyBeanToMap(source, targetType, target, converter);
        return target;
    }

    public static <S> Map<String, Object> fastCopyBeanToMap(@Nonnull Class<S> sourceType, @Nonnull S source, @Nonnull Map<String, Object> target, @Nonnull CopyOptions options) {
        BeanCopier.get(sourceType).copyBeanToMap(source, target, options);
        return target;
    }

    public static <S, K, V> Map<K, V> fastCopyBeanToMap(@Nonnull Class<S> sourceType, @Nonnull S source, @Nonnull Type targetType, @Nonnull Map<K, V> target, @Nonnull CopyOptions options) {
        BeanCopier.get(sourceType).copyBeanToMap(source, targetType, target, options);
        return target;
    }

    public static <T> T fastCopyMapToBean(@Nonnull Map<String, Object> source, @Nonnull T target) {
        Copiers.fastCopyMapToBean(source, target.getClass(), target);
        return target;
    }

    public static <T> T fastCopyMapToBean(@Nonnull Map<String, Object> source, @Nonnull Class<T> targetType, @Nonnull T target) {
        BeanCopier.get(targetType).copyMapToBean(source, target);
        return target;
    }

    public static <T> T fastCopyMapToBean(@Nonnull Map<String, Object> source, @Nonnull T target, BiFunction<Type, Object, Object> converter) {
        return (T)Copiers.fastCopyMapToBean(source, target.getClass(), target, converter);
    }

    public static <T> T fastCopyMapToBean(@Nonnull Map<String, Object> source, @Nonnull Class<T> targetType, @Nonnull T target, BiFunction<Type, Object, Object> converter) {
        BeanCopier.get(targetType).copyMapToBean(source, target, converter);
        return target;
    }

    public static <T> T fastCopyMapToBean(@Nonnull Map<String, Object> source, @Nonnull T target, @Nonnull CopyOptions options) {
        return (T)Copiers.fastCopyMapToBean(source, target.getClass(), target, options);
    }

    public static <T> T fastCopyMapToBean(@Nonnull Map<String, Object> source, @Nonnull Class<T> targetType, @Nonnull T target, @Nonnull CopyOptions options) {
        BeanCopier.get(targetType).copyMapToBean(source, target, options);
        return target;
    }

    public static <S, T> T fastCopyBeanToBean(@Nonnull S source, @Nonnull T target) {
        return (T)Copiers.fastCopyBeanToBean(source.getClass(), source, target.getClass(), target);
    }

    public static <S, T> T fastCopyBeanToBean(@Nonnull Class<S> sourceType, @Nonnull S source, @Nonnull Class<T> targetType, @Nonnull T target) {
        BeanCopier.get(sourceType).copyBeanToBean(source, targetType, target);
        return target;
    }

    public static <S, T> T fastCopyBeanToBean(@Nonnull S source, @Nonnull T target, @Nonnull CopyOptions options) {
        return (T)Copiers.fastCopyBeanToBean(source.getClass(), source, target.getClass(), target, options);
    }

    public static <S, T> T fastCopyBeanToBean(@Nonnull Class<S> sourceType, @Nonnull S source, @Nonnull Class<T> targetType, @Nonnull T target, @Nonnull CopyOptions options) {
        BeanCopier.get(sourceType).copyBeanToBean(source, targetType, target, options);
        return target;
    }

    public static Map copyMapToMap(@Nonnull Map source, @Nonnull Map target, @Nonnull CopyOptions options) {
        return (Map)new MapToMapCopier(source, new TypeRef<Map<String, Object>>(){}.getType(), target, options).copy();
    }

    public static Map copyMapToMap(@Nonnull Map source, @Nonnull Type targetType, @Nonnull Map target, @Nonnull CopyOptions options) {
        return (Map)new MapToMapCopier(source, targetType, target, options).copy();
    }

    public static <S> Map copyBeanToMap(@Nonnull Type sourceType, @Nonnull S source, @Nonnull Type targetType, @Nonnull Map target, @Nonnull CopyOptions options) {
        return (Map)new BeanToMapCopier<S>(sourceType, source, targetType, target, options).copy();
    }

    public static <S> Map copyBeanToMap(@Nonnull Type sourceType, @Nonnull S source, @Nonnull Map target, @Nonnull CopyOptions options) {
        return (Map)new BeanToMapCopier<S>(sourceType, source, new TypeRef<Map<String, Object>>(){}.getType(), target, options).copy();
    }

    public static <S> Map copyBeanToMap(@Nonnull S source, @Nonnull Type targetType, @Nonnull Map target, @Nonnull CopyOptions options) {
        return (Map)new BeanToMapCopier<S>(source.getClass(), source, targetType, target, options).copy();
    }

    public static <S> Map copyBeanToMap(@Nonnull S source, @Nonnull Map target, @Nonnull CopyOptions options) {
        return (Map)new BeanToMapCopier<S>(source.getClass(), source, new TypeRef<Map<String, Object>>(){}.getType(), target, options).copy();
    }

    public static <T> T copyMapToBean(@Nonnull Map source, @Nonnull Type targetType, @Nonnull T target, @Nonnull CopyOptions options) {
        return new MapToBeanCopier<T>(source, targetType, target, options).copy();
    }

    public static <T> T copyMapToBean(@Nonnull Map source, @Nonnull T target, @Nonnull CopyOptions options) {
        return new MapToBeanCopier<T>(source, target.getClass(), target, options).copy();
    }

    public static <S, T> T copyBeanToBean(@Nonnull Type sourceType, @Nonnull S source, @Nonnull Type targetType, @Nonnull T target, @Nonnull CopyOptions options) {
        return new BeanToBeanCopier<S, T>(sourceType, source, targetType, target, options).copy();
    }

    public static <S, T> T copyBeanToBean(@Nonnull S source, @Nonnull Type targetType, @Nonnull T target, @Nonnull CopyOptions options) {
        return new BeanToBeanCopier<S, T>(source.getClass(), source, targetType, target, options).copy();
    }

    public static <S, T> T copyBeanToBean(@Nonnull Type sourceType, @Nonnull S source, @Nonnull T target, @Nonnull CopyOptions options) {
        return new BeanToBeanCopier<S, T>(sourceType, source, target.getClass(), target, options).copy();
    }

    public static <S, T> T copyBeanToBean(@Nonnull S source, @Nonnull T target, @Nonnull CopyOptions options) {
        return new BeanToBeanCopier<S, T>(source.getClass(), source, target.getClass(), target, options).copy();
    }

    public static <E> E copy(@Nonnull Object source, @Nonnull E target) {
        return Copiers.create(source.getClass(), source, target.getClass(), target, null).copy();
    }

    public static <E> E copy(@Nonnull Object source, @Nonnull E target, CopyOptions options) {
        return Copiers.create(source.getClass(), source, target.getClass(), target, options).copy();
    }

    public static <E> E copy(@Nonnull Object source, @Nonnull Type targetType, @Nonnull E target) {
        return Copiers.create(source.getClass(), source, targetType, target, null).copy();
    }

    public static <E> E copy(@Nonnull Object source, @Nonnull Type targetType, @Nonnull E target, CopyOptions options) {
        return Copiers.create(source.getClass(), source, targetType, target, options).copy();
    }

    public static <E> E copy(@Nonnull Type sourceType, @Nonnull Object source, @Nonnull Type targetType, @Nonnull E target, CopyOptions options) {
        return Copiers.create(sourceType, source, targetType, target, options).copy();
    }

    public static <E> Copier<E> create(@Nonnull Type sourceType, @Nonnull Object source, @Nonnull Type targetType, @Nonnull E target, CopyOptions options) {
        Copier<Object> copier = source instanceof Collection || target instanceof Collection || source.getClass().isArray() || target.getClass().isArray() ? new IndexedObjectCopier<E>(source, target, targetType, options) : (source instanceof Map ? (target instanceof Map ? new MapToMapCopier((Map)source, targetType, (Map)target, options) : new MapToBeanCopier<E>((Map)source, targetType, target, options)) : (target instanceof Map ? new BeanToMapCopier<Object>(sourceType, source, targetType, (Map)target, options) : new BeanToBeanCopier<Object, E>(sourceType, source, targetType, target, options)));
        return copier;
    }

    public static <E> Copier<E> create(@Nonnull Object source, @Nonnull E target) {
        return Copiers.create(source.getClass(), source, target.getClass(), target, null);
    }

    public static <E> Copier<E> create(@Nonnull Object source, @Nonnull E target, CopyOptions options) {
        return Copiers.create(source.getClass(), source, target.getClass(), target, options);
    }

    public static <E> Copier<E> create(@Nonnull Object source, @Nonnull Type targetType, @Nonnull E target) {
        return Copiers.create(source.getClass(), source, targetType, target, null);
    }

    public static <E> Copier<E> create(@Nonnull Object source, @Nonnull Type targetType, @Nonnull E target, CopyOptions options) {
        return Copiers.create(source.getClass(), source, targetType, target, options);
    }

    public static <E> E deepCopy(@Nonnull Object source, @Nonnull E target) {
        return Copiers.create(source.getClass(), source, target.getClass(), target, null).deepCopy();
    }

    public static <E> E deepCopy(@Nonnull Object source, @Nonnull E target, CopyOptions options) {
        return Copiers.create(source.getClass(), source, target.getClass(), target, options).deepCopy();
    }

    public static <E> E deepCopy(@Nonnull Object source, @Nonnull Type targetType, @Nonnull E target) {
        return Copiers.create(source.getClass(), source, targetType, target, null).deepCopy();
    }

    public static <E> E deepCopy(@Nonnull Object source, @Nonnull Type targetType, @Nonnull E target, CopyOptions options) {
        return Copiers.create(source.getClass(), source, targetType, target, options).deepCopy();
    }

    public static <E> E deepCopy(@Nonnull Type sourceType, @Nonnull Object source, @Nonnull Type targetType, @Nonnull E target, CopyOptions options) {
        return Copiers.create(sourceType, source, targetType, target, options).deepCopy();
    }

    public static <E> E deepClone(@Nonnull Object source, @Nonnull Type targetType, CopyOptions options) {
        MetaObject metaObject = MetaObject.of(targetType);
        if (metaObject.isBasic() || metaObject.isEnum() || metaObject.isObject()) {
            return (E)options.convert(targetType, source);
        }
        if (metaObject.isArray()) {
            if (source.getClass().isArray()) {
                Object target = Array.newInstance(metaObject.getElementType().getBeanType().getRawClass(), Array.getLength(source));
                Copiers.deepCopy(source.getClass(), source, targetType, target, options);
                return (E)target;
            }
            if (source instanceof List) {
                Object target = Array.newInstance(metaObject.getElementType().getBeanType().getRawClass(), ((List)source).size());
                Copiers.deepCopy(source.getClass(), source, targetType, target, options);
                return (E)target;
            }
            return (E)Reflects.newInstanceIfPossible(Types.getClass(targetType));
        }
        Object target = metaObject.newInstance();
        if (target != null) {
            Copiers.deepCopy(source.getClass(), source, targetType, target, options);
        } else {
            target = options.convert(targetType, Copiers.deepClone(source, options));
        }
        return (E)target;
    }

    public static Object deepClone(@Nonnull Object source) {
        return Copiers.deepClone(source, CopyOptions.DEFAULT);
    }

    public static Object deepClone(@Nonnull Object source, CopyOptions options) {
        MetaObject<?> metaObject = MetaObject.of(source.getClass());
        if (metaObject.isBasic() || metaObject.isEnum() || metaObject.isObject()) {
            return source;
        }
        if (metaObject.isArray()) {
            Object target = Array.newInstance(metaObject.getElementType().getBeanType().getRawClass(), Array.getLength(source));
            Copiers.deepCopy(source.getClass(), source, target.getClass(), target, options);
            return target;
        }
        Object target = metaObject.newInstance();
        if (target != null) {
            Copiers.deepCopy(source.getClass(), source, target.getClass(), target, options);
        }
        return target;
    }

    static void copyArrayToArray(Object source, Type targetType, Object target, CopyOptions options, boolean deep) {
        int sourceLength = Array.getLength(source);
        int targetLength = Array.getLength(target);
        int minLength = Math.min(sourceLength, targetLength);
        JavaType javaType = JavaType.of(targetType);
        JavaType componentType = javaType.getRawType() instanceof GenericArrayType ? JavaType.of(((GenericArrayType)javaType.getRawType()).getGenericComponentType()) : JavaType.of(javaType.getRawClass().getComponentType());
        for (int i = 0; i < minLength; ++i) {
            Object value = Array.get(source, i);
            if (value == null && options.ignoreNull()) continue;
            Object old = null;
            if ((deep || !options.override()) && (old = Array.get(target, i)) != null && !options.override()) continue;
            value = options.convert(componentType, value);
            value = options.editValue(String.valueOf(i), value);
            if (value == null && options.ignoreNull()) continue;
            if (deep && value != null) {
                if (old == null) {
                    if ((value = Copiers.deepClone(value, componentType, options)) == null && options.ignoreNull()) {
                        continue;
                    }
                } else {
                    Copiers.deepCopy(value.getClass(), value, componentType, old, options);
                    continue;
                }
            }
            Array.set(target, i, value);
        }
    }

    static void copyArrayToList(Object source, Type targetType, List target, CopyOptions options, boolean deep) {
        int sourceLength = Array.getLength(source);
        int targetLength = target.size();
        JavaType javaType = JavaType.of(targetType);
        JavaType componentType = JavaType.of(javaType.getActualType(List.class, 0));
        for (int i = 0; i < sourceLength; ++i) {
            Object value = Array.get(source, i);
            if (value == null && options.ignoreNull()) continue;
            Object old = null;
            if (deep || !options.override()) {
                Object e = old = i >= targetLength ? null : (Object)target.get(i);
                if (old != null && !options.override()) continue;
            }
            value = options.convert(componentType, value);
            value = options.editValue(String.valueOf(i), value);
            if (value == null && options.ignoreNull()) continue;
            if (deep && value != null) {
                if (old == null) {
                    if ((value = Copiers.deepClone(value, componentType, options)) == null && options.ignoreNull()) {
                        continue;
                    }
                } else {
                    Copiers.deepCopy(value.getClass(), value, componentType, old, options);
                    continue;
                }
            }
            if (i < targetLength) {
                target.set(i, value);
                continue;
            }
            for (int j = 0; j < i - target.size(); ++j) {
                target.add(null);
            }
            target.add(value);
        }
    }

    static void copyListToArray(List source, Type targetType, Object target, CopyOptions options, boolean deep) {
        int sourceLength = source.size();
        int targetLength = Array.getLength(target);
        int minLength = Math.min(sourceLength, targetLength);
        JavaType javaType = JavaType.of(targetType);
        JavaType componentType = javaType.getRawType() instanceof GenericArrayType ? JavaType.of(((GenericArrayType)javaType.getRawType()).getGenericComponentType()) : JavaType.of(javaType.getRawClass().getComponentType());
        for (int i = 0; i < minLength; ++i) {
            Object value = source.get(i);
            if (value == null && options.ignoreNull()) continue;
            Object old = null;
            if ((deep || !options.override()) && (old = Array.get(target, i)) != null && !options.override()) continue;
            value = options.convert(componentType, value);
            value = options.editValue(String.valueOf(i), value);
            if (value == null && options.ignoreNull()) continue;
            if (deep && value != null) {
                if (old == null) {
                    if ((value = Copiers.deepClone(value, componentType, options)) == null && options.ignoreNull()) {
                        continue;
                    }
                } else {
                    Copiers.deepCopy(value.getClass(), value, componentType, old, options);
                    continue;
                }
            }
            Array.set(target, i, value);
        }
    }

    static void copyListToList(List source, Type targetType, List target, CopyOptions options, boolean deep) {
        int sourceLength = source.size();
        int targetLength = target.size();
        JavaType javaType = JavaType.of(targetType);
        JavaType componentType = JavaType.of(javaType.getActualType(List.class, 0));
        for (int i = 0; i < sourceLength; ++i) {
            Object value = source.get(i);
            if (value == null && options.ignoreNull()) continue;
            Object old = null;
            if (deep || !options.override()) {
                Object e = old = i >= targetLength ? null : (Object)target.get(i);
                if (old != null && !options.override()) continue;
            }
            value = options.convert(componentType, value);
            value = options.editValue(String.valueOf(i), value);
            if (value == null && options.ignoreNull()) continue;
            if (deep && value != null) {
                if (old == null) {
                    if ((value = Copiers.deepClone(value, componentType, options)) == null && options.ignoreNull()) {
                        continue;
                    }
                } else {
                    Copiers.deepCopy(value.getClass(), value, componentType, old, options);
                    continue;
                }
            }
            if (i < targetLength) {
                target.set(i, value);
                continue;
            }
            for (int j = 0; j < i - target.size(); ++j) {
                target.add(null);
            }
            target.add(value);
        }
    }

    static <T> T deepCopyIndexed(Object source, Type targetType, T target, CopyOptions options, boolean deep) {
        block18: {
            options = options != null ? options : CopyOptions.DEFAULT;
            try {
                if (source.getClass().isArray()) {
                    if (target.getClass().isArray()) {
                        Copiers.copyArrayToArray(source, targetType, target, options, deep);
                    } else if (target instanceof List) {
                        Copiers.copyArrayToList(source, targetType, (List)target, options, deep);
                    } else if (log.isDebugEnabled()) {
                        log.debug("\u4e0d\u652f\u6301\u6570\u7ec4\u5230\u975e\u6570\u7ec4\u6216\u5217\u8868\u95f4\u7684\u5c5e\u6027\u590d\u5236");
                    }
                } else if (source instanceof List) {
                    if (target.getClass().isArray()) {
                        Copiers.copyListToArray((List)source, targetType, target, options, deep);
                    } else if (target instanceof List) {
                        Copiers.copyListToList((List)source, targetType, (List)target, options, deep);
                    } else if (log.isDebugEnabled()) {
                        log.debug("\u4e0d\u652f\u6301\u5217\u8868\u5230\u975e\u6570\u7ec4\u6216\u5217\u8868\u95f4\u7684\u5c5e\u6027\u590d\u5236");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("\u4e0d\u652f\u6301\u975e\u6570\u7ec4\u6216\u5217\u8868\u95f4\u7684\u5c5e\u6027\u590d\u5236");
                }
            }
            catch (Exception e) {
                if (!options.ignoreError()) {
                    throw new IllegalArgumentException(e);
                }
                log.warn("\u590d\u5236\u5c5e\u6027\u5931\u8d25\uff1a{}", e.getMessage());
                if (!log.isDebugEnabled()) break block18;
                log.debug(e.getMessage(), e);
            }
        }
        return target;
    }
}

