/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.copier;

import io.polaris.core.converter.Converters;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.Types;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CopyOptions
implements Cloneable {
    public static final BiFunction<Type, Object, Object> DEFAULT_CONVERTER = Converters::convertQuietly;
    public static final BiFunction<Type, Object, Object> PROPERTY_EDITOR_CONVERTER = (type, value) -> {
        Class<?> valueClass;
        if (value == null) {
            return null;
        }
        Class<?> rawClass = Types.getWrapperClass(Types.getClass(type));
        if (rawClass.isAssignableFrom(valueClass = Types.getWrapperClass(value.getClass()))) {
            return value;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor((Class)type);
        if (editor != null) {
            if (value instanceof String) {
                editor.setAsText((String)value);
            } else {
                editor.setAsText(value.toString());
            }
            return editor.getValue();
        }
        return value;
    };
    public static final CopyOptions DEFAULT = CopyOptions.create().immutable();
    private boolean ignoreError = true;
    private Set<String> ignoreKeys;
    private boolean ignoreCase = false;
    private boolean ignoreCapitalize = false;
    private boolean enableUnderlineToCamelCase = false;
    private boolean enableCamelToUnderlineCase = false;
    private boolean ignoreNull = true;
    private boolean override = true;
    private Function<String, String> keyMapping;
    private BiFunction<String, Object, Object> valueMapping;
    private boolean enableConverter = true;
    private BiFunction<Type, Object, Object> converter = DEFAULT_CONVERTER;
    private boolean mutable = true;

    public static CopyOptions create() {
        return new CopyOptions();
    }

    public static CopyOptions clone(CopyOptions options) {
        return CopyOptions.create().ignoreError(options.ignoreError).ignoreKeys(options.ignoreKeys).ignoreCase(options.ignoreCase).ignoreCapitalize(options.ignoreCapitalize).enableUnderlineToCamelCase(options.enableUnderlineToCamelCase).enableCamelToUnderlineCase(options.enableCamelToUnderlineCase).ignoreNull(options.ignoreNull).override(options.override).keyMapping(options.keyMapping).valueMapping(options.valueMapping).enableConverter(options.enableConverter).converter(options.converter);
    }

    protected Object clone() {
        try {
            CopyOptions clone = (CopyOptions)super.clone();
            clone.mutable = true;
            return clone;
        }
        catch (Exception ignored) {
            return CopyOptions.clone(this);
        }
    }

    public boolean hasKeyMapping() {
        return this.keyMapping != null;
    }

    public boolean isIgnoredKey(String key) {
        return this.ignoreKeys != null && this.ignoreKeys.contains(key);
    }

    public Object convert(Type type, Object value) {
        if (value == null) {
            return null;
        }
        if (JavaType.of(type).isInstance(value)) {
            return value;
        }
        if (!this.enableConverter) {
            return null;
        }
        if (this.converter == null) {
            return null;
        }
        return this.converter.apply(type, value);
    }

    public String editKey(String key) {
        if (this.keyMapping != null) {
            return this.keyMapping.apply(key);
        }
        return key;
    }

    public Object editValue(String key, Object value) {
        if (this.valueMapping != null) {
            return this.valueMapping.apply(key, value);
        }
        return value;
    }

    public CopyOptions immutable() {
        this.mutable = false;
        return this;
    }

    public CopyOptions ignoreNull(boolean ignoreNullValue) {
        if (this.mutable) {
            this.ignoreNull = ignoreNullValue;
        }
        return this;
    }

    public CopyOptions ignoreKeys(Set<String> keys) {
        if (this.mutable) {
            this.ignoreKeys = keys;
        }
        return this;
    }

    public CopyOptions ignoreError(boolean ignoreError) {
        if (this.mutable) {
            this.ignoreError = ignoreError;
        }
        return this;
    }

    public CopyOptions ignoreCase(boolean ignoreCase) {
        if (this.mutable) {
            this.ignoreCase = ignoreCase;
        }
        return this;
    }

    public CopyOptions ignoreCapitalize(boolean ignoreCapitalize) {
        if (this.mutable) {
            this.ignoreCapitalize = ignoreCapitalize;
        }
        return this;
    }

    public CopyOptions enableUnderlineToCamelCase(boolean underlineToCamelCase) {
        if (this.mutable) {
            this.enableUnderlineToCamelCase = underlineToCamelCase;
        }
        return this;
    }

    public CopyOptions enableCamelToUnderlineCase(boolean camelToUnderlineCase) {
        if (this.mutable) {
            this.enableCamelToUnderlineCase = camelToUnderlineCase;
        }
        return this;
    }

    public CopyOptions keyMapping(Map<String, String> keyMapping) {
        if (this.mutable) {
            return this.keyMapping((String key) -> keyMapping.getOrDefault(key, (String)key));
        }
        return this;
    }

    public CopyOptions keyMapping(Function<String, String> keyMapping) {
        if (this.mutable) {
            this.keyMapping = keyMapping;
        }
        return this;
    }

    public CopyOptions valueMapping(BiFunction<String, Object, Object> valueMapping) {
        if (this.mutable) {
            this.valueMapping = valueMapping;
        }
        return this;
    }

    public CopyOptions override(boolean override) {
        if (this.mutable) {
            this.override = override;
        }
        return this;
    }

    public CopyOptions enableConverter(boolean enableConverter) {
        if (this.mutable) {
            this.enableConverter = enableConverter;
        }
        return this;
    }

    public CopyOptions converter(BiFunction<Type, Object, Object> converter) {
        if (this.mutable) {
            this.converter = converter;
        }
        return this;
    }

    public CopyOptions useDefaultConverter() {
        if (this.mutable) {
            this.converter = DEFAULT_CONVERTER;
        }
        return this;
    }

    public CopyOptions usePropertyEditorConverter() {
        if (this.mutable) {
            this.converter = PROPERTY_EDITOR_CONVERTER;
        }
        return this;
    }

    public boolean ignoreNull() {
        return this.ignoreNull;
    }

    public boolean ignoreError() {
        return this.ignoreError;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }

    public boolean ignoreCapitalize() {
        return this.ignoreCapitalize;
    }

    public boolean enableUnderlineToCamelCase() {
        return this.enableUnderlineToCamelCase;
    }

    public boolean enableCamelToUnderlineCase() {
        return this.enableCamelToUnderlineCase;
    }

    public boolean override() {
        return this.override;
    }

    public Function<String, String> keyMapping() {
        return this.keyMapping;
    }

    public BiFunction<String, Object, Object> valueMapping() {
        return this.valueMapping;
    }

    public Set<String> ignoreKeys() {
        return this.ignoreKeys;
    }

    public boolean enableConverter() {
        return this.enableConverter;
    }

    public BiFunction<Type, Object, Object> converter() {
        return this.converter;
    }

    public String toString() {
        return "CopyOptions(ignoreError=" + this.ignoreError + ", ignoreKeys=" + this.ignoreKeys + ", ignoreCase=" + this.ignoreCase + ", ignoreCapitalize=" + this.ignoreCapitalize + ", enableUnderlineToCamelCase=" + this.enableUnderlineToCamelCase + ", enableCamelToUnderlineCase=" + this.enableCamelToUnderlineCase + ", ignoreNull=" + this.ignoreNull + ", override=" + this.override + ", keyMapping=" + this.keyMapping + ", valueMapping=" + this.valueMapping + ", enableConverter=" + this.enableConverter + ", converter=" + this.converter + ", mutable=" + this.mutable + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyOptions)) {
            return false;
        }
        CopyOptions other = (CopyOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.ignoreError != other.ignoreError) {
            return false;
        }
        if (this.ignoreCase != other.ignoreCase) {
            return false;
        }
        if (this.ignoreCapitalize != other.ignoreCapitalize) {
            return false;
        }
        if (this.enableUnderlineToCamelCase != other.enableUnderlineToCamelCase) {
            return false;
        }
        if (this.enableCamelToUnderlineCase != other.enableCamelToUnderlineCase) {
            return false;
        }
        if (this.ignoreNull != other.ignoreNull) {
            return false;
        }
        if (this.override != other.override) {
            return false;
        }
        if (this.enableConverter != other.enableConverter) {
            return false;
        }
        if (this.mutable != other.mutable) {
            return false;
        }
        Set<String> this$ignoreKeys = this.ignoreKeys;
        Set<String> other$ignoreKeys = other.ignoreKeys;
        if (this$ignoreKeys == null ? other$ignoreKeys != null : !((Object)this$ignoreKeys).equals(other$ignoreKeys)) {
            return false;
        }
        Function<String, String> this$keyMapping = this.keyMapping;
        Function<String, String> other$keyMapping = other.keyMapping;
        if (this$keyMapping == null ? other$keyMapping != null : !this$keyMapping.equals(other$keyMapping)) {
            return false;
        }
        BiFunction<String, Object, Object> this$valueMapping = this.valueMapping;
        BiFunction<String, Object, Object> other$valueMapping = other.valueMapping;
        if (this$valueMapping == null ? other$valueMapping != null : !this$valueMapping.equals(other$valueMapping)) {
            return false;
        }
        BiFunction<Type, Object, Object> this$converter = this.converter;
        BiFunction<Type, Object, Object> other$converter = other.converter;
        return !(this$converter == null ? other$converter != null : !this$converter.equals(other$converter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CopyOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ignoreError ? 79 : 97);
        result = result * 59 + (this.ignoreCase ? 79 : 97);
        result = result * 59 + (this.ignoreCapitalize ? 79 : 97);
        result = result * 59 + (this.enableUnderlineToCamelCase ? 79 : 97);
        result = result * 59 + (this.enableCamelToUnderlineCase ? 79 : 97);
        result = result * 59 + (this.ignoreNull ? 79 : 97);
        result = result * 59 + (this.override ? 79 : 97);
        result = result * 59 + (this.enableConverter ? 79 : 97);
        result = result * 59 + (this.mutable ? 79 : 97);
        Set<String> $ignoreKeys = this.ignoreKeys;
        result = result * 59 + ($ignoreKeys == null ? 43 : ((Object)$ignoreKeys).hashCode());
        Function<String, String> $keyMapping = this.keyMapping;
        result = result * 59 + ($keyMapping == null ? 43 : $keyMapping.hashCode());
        BiFunction<String, Object, Object> $valueMapping = this.valueMapping;
        result = result * 59 + ($valueMapping == null ? 43 : $valueMapping.hashCode());
        BiFunction<Type, Object, Object> $converter = this.converter;
        result = result * 59 + ($converter == null ? 43 : $converter.hashCode());
        return result;
    }
}

