/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.copier;

import io.polaris.core.lang.copier.Copier;
import io.polaris.core.lang.copier.Copiers;
import io.polaris.core.lang.copier.CopyOptions;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import java.lang.reflect.Type;

public class IndexedObjectCopier<T>
implements Copier<T> {
    private static final ILogger log = ILoggers.of(IndexedObjectCopier.class);
    private final Object source;
    private final T target;
    private final CopyOptions options;
    private final Type targetType;

    public IndexedObjectCopier(Object source, T target, Type targetType, CopyOptions options) {
        this.source = source;
        this.target = target;
        this.targetType = targetType != null ? targetType : target.getClass();
        this.options = options != null ? options : CopyOptions.DEFAULT;
    }

    @Override
    public T copy() {
        return Copiers.deepCopyIndexed(this.source, this.targetType, this.target, this.options, false);
    }

    @Override
    public T deepCopy() {
        return Copiers.deepCopyIndexed(this.source, this.targetType, this.target, this.options, true);
    }
}

