/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.copier;

import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.Types;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.lang.bean.PropertyAccessor;
import io.polaris.core.lang.copier.Copier;
import io.polaris.core.lang.copier.Copiers;
import io.polaris.core.lang.copier.CopyOptions;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.map.CaseInsensitiveMap;
import io.polaris.core.string.StringCases;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class MapToBeanCopier<T>
implements Copier<T> {
    private static final ILogger log = ILoggers.of(MapToBeanCopier.class);
    private final Map source;
    private final T target;
    private final Type targetType;
    private final CopyOptions options;

    public MapToBeanCopier(Map source, Type targetType, T target, CopyOptions options) {
        this.source = source;
        this.target = target;
        this.targetType = targetType != null ? targetType : target.getClass();
        this.options = options != null ? options : CopyOptions.DEFAULT;
    }

    @Override
    public T copy() {
        return this.copy(false);
    }

    @Override
    public T deepCopy() {
        return this.copy(true);
    }

    public T copy(boolean deep) {
        block10: {
            try {
                Map<String, PropertyAccessor> accessors = Beans.getIndexedFieldAndPropertyAccessors(JavaType.of(this.targetType).getRawClass());
                HashMap<String, PropertyAccessor> targetAccessors = new HashMap<String, PropertyAccessor>();
                accessors.forEach((key, accessor) -> {
                    if (accessor.hasSetter()) {
                        targetAccessors.put((String)key, (PropertyAccessor)accessor);
                    }
                });
                Function<String, String> mapping = this.options.keyMapping();
                if (mapping == null) {
                    mapping = Function.identity();
                }
                this.copyProperties(mapping, targetAccessors, deep);
                if (targetAccessors.isEmpty()) break block10;
                if (this.options.ignoreCapitalize()) {
                    mapping = key -> {
                        if (key.length() > 1) {
                            String mapKey = Character.isUpperCase(key.charAt(0)) ? Character.toLowerCase(key.charAt(0)) + key.substring(1) : Character.toUpperCase(key.charAt(0)) + key.substring(1);
                            return mapKey;
                        }
                        return null;
                    };
                    this.copyProperties(mapping, targetAccessors, deep);
                    if (targetAccessors.isEmpty()) break block10;
                }
                if (this.options.enableUnderlineToCamelCase()) {
                    mapping = key -> {
                        String mapKey = StringCases.underlineToCamelCase(key);
                        if (!key.equals(mapKey)) {
                            return mapKey;
                        }
                        return null;
                    };
                    this.copyProperties(mapping, targetAccessors, deep);
                    if (targetAccessors.isEmpty()) break block10;
                }
                if (this.options.enableCamelToUnderlineCase()) {
                    mapping = key -> {
                        String mapKey = StringCases.camelToUnderlineCase(key);
                        if (!key.equals(mapKey)) {
                            return mapKey;
                        }
                        return null;
                    };
                    this.copyProperties(mapping, targetAccessors, deep);
                    if (targetAccessors.isEmpty()) break block10;
                }
                if (!this.options.ignoreCase()) break block10;
                CaseInsensitiveMap<String, PropertyAccessor> upperTargetAccessors = new CaseInsensitiveMap<String, PropertyAccessor>(HashMap::new, targetAccessors);
                mapping = key -> this.options.editKey((String)key).toUpperCase();
                this.copyProperties(mapping, upperTargetAccessors, deep);
                if (upperTargetAccessors.isEmpty()) break block10;
                if (this.options.enableUnderlineToCamelCase()) {
                    mapping = key -> {
                        String mapKey = StringCases.underlineToCamelCase(key);
                        if (!key.equals(mapKey)) {
                            return mapKey;
                        }
                        return null;
                    };
                    this.copyProperties(mapping, upperTargetAccessors, deep);
                    if (upperTargetAccessors.isEmpty()) break block10;
                }
                if (this.options.enableCamelToUnderlineCase()) {
                    mapping = key -> {
                        String mapKey = StringCases.camelToUnderlineCase(key);
                        if (!key.equals(mapKey)) {
                            return mapKey;
                        }
                        return null;
                    };
                    this.copyProperties(mapping, upperTargetAccessors, deep);
                }
            }
            catch (Exception e) {
                if (!this.options.ignoreError()) {
                    throw new IllegalArgumentException(e);
                }
                log.warn("\u590d\u5236\u5c5e\u6027\u5931\u8d25\uff1a{}", e.getMessage());
                if (!log.isDebugEnabled()) break block10;
                log.debug(e.getMessage(), e);
            }
        }
        return this.target;
    }

    void copyProperties(Function<String, String> mapping, Map<String, PropertyAccessor> targetAccessors, boolean deep) {
        Set set = this.source.entrySet();
        for (Map.Entry entry : set) {
            if (targetAccessors.isEmpty()) {
                return;
            }
            String sourceKey = Objects.toString(entry.getKey(), null);
            if (sourceKey == null) continue;
            try {
                PropertyAccessor accessor;
                String targetKey;
                String mapKey;
                Object value = entry.getValue();
                if (this.options.isIgnoredKey(sourceKey) || (mapKey = this.options.editKey(sourceKey)) == null || (targetKey = mapping.apply(mapKey)) == null || value == null && this.options.ignoreNull() || (accessor = targetAccessors.get(targetKey)) == null) continue;
                Object old = null;
                if ((deep || !this.options.override()) && accessor.hasGetter() && (old = accessor.get(this.target)) != null && !this.options.override()) continue;
                Type type = accessor.type();
                value = this.options.editValue(sourceKey, value);
                if ((value = this.options.convert(type, value)) == null && (this.options.ignoreNull() || Types.isPrimitive(JavaType.of(type).getRawClass()))) continue;
                if (deep && value != null) {
                    if (old == null) {
                        if ((value = Copiers.deepClone(value, type, this.options)) == null && (this.options.ignoreNull() || Types.isPrimitive(JavaType.of(type).getRawClass()))) {
                            continue;
                        }
                    } else {
                        Copiers.deepCopy(value.getClass(), value, type, old, this.options);
                        continue;
                    }
                }
                accessor.set(this.target, value);
                targetAccessors.remove(targetKey);
            }
            catch (Exception e) {
                if (!this.options.ignoreError()) {
                    throw new IllegalArgumentException(e);
                }
                log.warn("\u590d\u5236\u5c5e\u6027\u5931[{}]\u8d25\uff1a{}", sourceKey, e.getMessage());
                if (!log.isDebugEnabled()) continue;
                log.debug(e.getMessage(), e);
            }
        }
    }
}

