/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.primitive;

import io.polaris.core.random.Randoms;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Random;

public class Booleans {
    public static boolean isTrue(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public static boolean isFalse(Boolean bool) {
        return Boolean.FALSE.equals(bool);
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(boolean[] array) {
        return !Booleans.isEmpty(array);
    }

    public static boolean toBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return 0 != ((Number)value).intValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue() != '\u0000';
        }
        if (value instanceof CharSequence) {
            return Booleans.parseBoolean(value.toString());
        }
        if (value instanceof Optional) {
            return ((Optional)value).isPresent();
        }
        if (value instanceof OptionalInt) {
            return ((OptionalInt)value).isPresent();
        }
        if (value instanceof OptionalDouble) {
            return ((OptionalDouble)value).isPresent();
        }
        if (value instanceof OptionalLong) {
            return ((OptionalLong)value).isPresent();
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return !((Map)value).isEmpty();
        }
        if (value instanceof Iterable) {
            return !((Iterable)value).iterator().hasNext();
        }
        if (value instanceof Iterator) {
            return ((Iterator)value).hasNext();
        }
        if (value instanceof long[]) {
            return ((long[])value).length != 0;
        }
        if (value instanceof int[]) {
            return ((int[])value).length != 0;
        }
        if (value instanceof short[]) {
            return ((short[])value).length != 0;
        }
        if (value instanceof char[]) {
            return ((char[])value).length != 0;
        }
        if (value instanceof byte[]) {
            return ((byte[])value).length != 0;
        }
        if (value instanceof boolean[]) {
            return ((boolean[])value).length != 0;
        }
        if (value instanceof double[]) {
            return ((double[])value).length != 0;
        }
        if (value instanceof float[]) {
            return ((float[])value).length != 0;
        }
        if (value instanceof Object[]) {
            return ((Object[])value).length != 0;
        }
        if (value.getClass().isArray()) {
            try {
                return Array.getLength(value) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean parseBoolean(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("1") || s.equalsIgnoreCase("y") || s.equalsIgnoreCase("t");
    }

    public static boolean[] join(boolean[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (boolean[] array : arrays) {
            if (!Booleans.isNotEmpty(array)) continue;
            length += array.length;
        }
        boolean[] result = new boolean[length];
        length = 0;
        for (boolean[] array : arrays) {
            if (!Booleans.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static int indexOf(boolean[] array, boolean value) {
        if (Booleans.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean value) {
        if (Booleans.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(boolean[] array, boolean value) {
        return Booleans.indexOf(array, value) > -1;
    }

    public static Boolean[] wrap(boolean ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Boolean[0];
        }
        Boolean[] array = new Boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static boolean[] unwrap(Boolean ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new boolean[0];
        }
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Optional.ofNullable(values[i]).orElse(false);
        }
        return array;
    }

    public static boolean[] sub(boolean[] array, int start, int end) {
        int length = array.length;
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new boolean[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new boolean[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static boolean[] remove(boolean[] array, int index) throws IllegalArgumentException {
        if (null == array) {
            return null;
        }
        int length = array.length;
        if (index < 0 || index >= length) {
            return array;
        }
        boolean[] result = new boolean[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static boolean[] removeElement(boolean[] array, boolean element) throws IllegalArgumentException {
        return Booleans.remove(array, Booleans.indexOf(array, element));
    }

    public static boolean[] reverse(boolean[] array, int startIndexInclusive, int endIndexExclusive) {
        if (Booleans.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            Booleans.swap(array, i, j);
        }
        return array;
    }

    public static boolean[] reverse(boolean[] array) {
        return Booleans.reverse(array, 0, array.length);
    }

    public static boolean[] shuffle(boolean[] array) {
        return Booleans.shuffle(array, Randoms.getRandom());
    }

    public static boolean[] shuffle(boolean[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            Booleans.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static boolean[] swap(boolean[] array, int index1, int index2) {
        boolean tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }
}

