/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.primitive;

import io.polaris.core.random.Randoms;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;

public class Chars {
    public static char[] join(char[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (char[] array : arrays) {
            if (!Chars.isNotEmpty(array)) continue;
            length += array.length;
        }
        char[] result = new char[length];
        length = 0;
        for (char[] array : arrays) {
            if (!Chars.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static Character[] wrap(char ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Character[0];
        }
        Character[] array = new Character[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Character.valueOf(values[i]);
        }
        return array;
    }

    public static char[] unwrap(Character ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new char[0];
        }
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Optional.ofNullable(values[i]).orElse(Character.valueOf('\u0000')).charValue();
        }
        return array;
    }

    public static char[] sub(char[] array, int start, int end) {
        int length = array.length;
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new char[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new char[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static char[] remove(char[] array, int index) throws IllegalArgumentException {
        if (null == array) {
            return null;
        }
        int length = array.length;
        if (index < 0 || index >= length) {
            return array;
        }
        char[] result = new char[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static char[] removeElement(char[] array, char element) throws IllegalArgumentException {
        return Chars.remove(array, Chars.indexOf(array, element));
    }

    public static char[] reverse(char[] array, int startIndexInclusive, int endIndexExclusive) {
        if (Chars.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            Chars.swap(array, i, j);
        }
        return array;
    }

    public static char[] reverse(char[] array) {
        return Chars.reverse(array, 0, array.length);
    }

    public static char min(char ... numberArray) {
        if (Chars.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static char max(char ... numberArray) {
        if (Chars.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static char[] shuffle(char[] array) {
        return Chars.shuffle(array, Randoms.getRandom());
    }

    public static char[] shuffle(char[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            Chars.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static char[] swap(char[] array, int index1, int index2) {
        char tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static int indexOf(char[] array, char value) {
        if (Chars.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char value) {
        if (Chars.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(char[] array, char value) {
        return Chars.indexOf(array, value) > -1;
    }

    public static boolean isSorted(char[] array) {
        return Chars.isSortedAsc(array);
    }

    public static boolean isSortedAsc(char[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDesc(char[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(char[] array) {
        return !Chars.isEmpty(array);
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isAsciiControl(char ch) {
        return ch < ' ' || ch == '\u007f';
    }

    public static boolean isLetter(char ch) {
        return Chars.isLetterUpper(ch) || Chars.isLetterLower(ch);
    }

    public static boolean isLetterUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isLetterLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isHexChar(char c) {
        return Chars.isNumber(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static boolean isLetterOrNumber(char ch) {
        return Chars.isLetter(ch) || Chars.isNumber(ch);
    }

    public static String toString(char c) {
        return ASCIIStrCache.toString(c);
    }

    public static boolean isCharClass(Class<?> clazz) {
        return clazz == Character.class || clazz == Character.TYPE;
    }

    public static boolean isChar(Object value) {
        return value instanceof Character || value.getClass() == Character.TYPE;
    }

    public static boolean isBlankChar(char c) {
        return Chars.isBlankChar((int)c);
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0 || c == 12644 || c == 10240 || c == 6158;
    }

    public static boolean isEmoji(char c) {
        return false == (c == '\u0000' || c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u100000' && c <= '\u10ffff');
    }

    public static boolean isFileSeparator(char c) {
        return '/' == c || '\\' == c;
    }

    public static boolean equals(char c1, char c2, boolean caseInsensitive) {
        if (caseInsensitive) {
            return Character.toLowerCase(c1) == Character.toLowerCase(c2);
        }
        return c1 == c2;
    }

    public static int getType(int c) {
        return Character.getType(c);
    }

    public static int digit16(int b) {
        return Character.digit(b, 16);
    }

    public static char toCloseChar(char c) {
        int result = c;
        if (c >= 49 && c <= 57) {
            result = 9312 + c - 49;
        } else if (c >= 65 && c <= 90) {
            result = 9398 + c - 65;
        } else if (c >= 97 && c <= 122) {
            result = 9424 + c - 97;
        }
        return (char)result;
    }

    public static char toCloseByNumber(int number) {
        if (number > 20) {
            throw new IllegalArgumentException("Number must be [1-20]");
        }
        return (char)(9312 + number - 1);
    }

    static class ASCIIStrCache {
        private static final int ASCII_LENGTH = 128;
        private static final String[] CACHE = new String[128];

        ASCIIStrCache() {
        }

        public static String toString(char c) {
            return c < '\u0080' ? CACHE[c] : String.valueOf(c);
        }

        static {
            for (char c = '\u0000'; c < '\u0080'; c = (char)(c + '\u0001')) {
                ASCIIStrCache.CACHE[c] = String.valueOf(c);
            }
        }
    }
}

