/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.primitive;

import io.polaris.core.lang.Numbers;
import io.polaris.core.random.Randoms;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;

public class Floats {
    public static float[] join(float[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (float[] array : arrays) {
            if (!Floats.isNotEmpty(array)) continue;
            length += array.length;
        }
        float[] result = new float[length];
        length = 0;
        for (float[] array : arrays) {
            if (!Floats.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static Float[] wrap(float ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Float[0];
        }
        Float[] array = new Float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Float.valueOf(values[i]);
        }
        return array;
    }

    public static float[] unwrap(Float ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new float[0];
        }
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Optional.ofNullable(values[i]).orElse(Float.valueOf(0.0f)).floatValue();
        }
        return array;
    }

    public static float[] sub(float[] array, int start, int end) {
        int length = array.length;
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new float[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new float[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static float[] remove(float[] array, int index) throws IllegalArgumentException {
        if (null == array) {
            return null;
        }
        int length = array.length;
        if (index < 0 || index >= length) {
            return array;
        }
        float[] result = new float[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static float[] removeElement(float[] array, float element) throws IllegalArgumentException {
        return Floats.remove(array, Floats.indexOf(array, element));
    }

    public static float[] reverse(float[] array, int startIndexInclusive, int endIndexExclusive) {
        if (Floats.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            Floats.swap(array, i, j);
        }
        return array;
    }

    public static float[] reverse(float[] array) {
        return Floats.reverse(array, 0, array.length);
    }

    public static float min(float ... numberArray) {
        if (Floats.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (!(min > numberArray[i])) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static float max(float ... numberArray) {
        if (Floats.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (!(max < numberArray[i])) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static float[] shuffle(float[] array) {
        return Floats.shuffle(array, Randoms.getRandom());
    }

    public static float[] shuffle(float[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            Floats.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static float[] swap(float[] array, int index1, int index2) {
        float tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static int indexOf(float[] array, float value) {
        if (Floats.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (!Numbers.equals(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float value) {
        if (Floats.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!Numbers.equals(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(float[] array, float value) {
        return Floats.indexOf(array, value) > -1;
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(float[] array) {
        return !Floats.isEmpty(array);
    }

    public static boolean isSorted(float[] array) {
        return Floats.isSortedAsc(array);
    }

    public static boolean isSortedAsc(float[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] > array[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDesc(float[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] < array[i + 1])) continue;
            return false;
        }
        return true;
    }
}

