/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.primitive;

import io.polaris.core.random.Randoms;
import io.polaris.core.string.Hex;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;

public class Ints {
    public static String toBinString(int num) {
        return Hex.formatBin(num);
    }

    public static String toOctString(int num) {
        return Hex.formatOct(num);
    }

    public static String toHexString(int num) {
        return Hex.formatHex(num);
    }

    public static int parseBin(String text) {
        return Hex.parseBinAsInt(text);
    }

    public static int parseOct(String text) {
        return Hex.parseOctAsInt(text);
    }

    public static int parseHex(String text) {
        return Hex.parseHexAsInt(text);
    }

    public static int parse(String text, int radix) {
        return Integer.parseInt(text, radix);
    }

    public static int[] join(int[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (int[] array : arrays) {
            if (!Ints.isNotEmpty(array)) continue;
            length += array.length;
        }
        int[] result = new int[length];
        length = 0;
        for (int[] array : arrays) {
            if (!Ints.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static int[] range(int excludedEnd) {
        return Ints.range(0, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd) {
        return Ints.range(includedStart, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd, int step) {
        if (includedStart > excludedEnd) {
            int tmp = includedStart;
            includedStart = excludedEnd;
            excludedEnd = tmp;
        }
        if (step <= 0) {
            step = 1;
        }
        int deviation = excludedEnd - includedStart;
        int length = deviation / step;
        if (deviation % step != 0) {
            ++length;
        }
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = includedStart;
            includedStart += step;
        }
        return range;
    }

    public static Integer[] wrap(int ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Integer[0];
        }
        Integer[] array = new Integer[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static int[] unwrap(Integer ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Optional.ofNullable(values[i]).orElse(0);
        }
        return array;
    }

    public static int[] sub(int[] array, int start, int end) {
        int length = array.length;
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new int[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new int[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static int[] remove(int[] array, int index) throws IllegalArgumentException {
        if (null == array) {
            return null;
        }
        int length = array.length;
        if (index < 0 || index >= length) {
            return array;
        }
        int[] result = new int[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static int[] removeElement(int[] array, int element) throws IllegalArgumentException {
        return Ints.remove(array, Ints.indexOf(array, element));
    }

    public static int[] reverse(int[] array, int startIndexInclusive, int endIndexExclusive) {
        if (Ints.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            Ints.swap(array, i, j);
        }
        return array;
    }

    public static int[] reverse(int[] array) {
        return Ints.reverse(array, 0, array.length);
    }

    public static int min(int ... numberArray) {
        if (Ints.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static int max(int ... numberArray) {
        if (Ints.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static int[] shuffle(int[] array) {
        return Ints.shuffle(array, Randoms.getRandom());
    }

    public static int[] shuffle(int[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            Ints.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static int[] swap(int[] array, int index1, int index2) {
        int tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static int indexOf(int[] array, int value) {
        if (Ints.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int value) {
        if (Ints.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(int[] array, int value) {
        return Ints.indexOf(array, value) > -1;
    }

    public static boolean isSorted(int[] array) {
        return Ints.isSortedAsc(array);
    }

    public static boolean isSortedAsc(int[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDesc(int[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(int[] array) {
        return !Ints.isEmpty(array);
    }

    public static byte[] toBytes(int value) {
        byte[] result = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return result;
    }

    public static int toInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static int defaultIfZero(int value, int defaultValue) {
        return 0 == value ? defaultValue : value;
    }

    public static int defaultIfZero(int value) {
        return 0 == value ? 1 : value;
    }
}

