/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.primitive;

import io.polaris.core.random.Randoms;
import io.polaris.core.string.Hex;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;

public class Shorts {
    public static String toBinString(short num) {
        return Hex.formatBin(num);
    }

    public static String toOctString(short num) {
        return Hex.formatOct(num);
    }

    public static String toHexString(short num) {
        return Hex.formatHex(num);
    }

    public static short parseBin(String text) {
        return Hex.parseBinAsShort(text);
    }

    public static short parseOct(String text) {
        return Hex.parseOctAsShort(text);
    }

    public static short parseHex(String text) {
        return Hex.parseHexAsShort(text);
    }

    public static short parse(String text, int radix) {
        return Short.parseShort(text, radix);
    }

    public static short[] join(short[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (short[] array : arrays) {
            if (!Shorts.isNotEmpty(array)) continue;
            length += array.length;
        }
        short[] result = new short[length];
        length = 0;
        for (short[] array : arrays) {
            if (!Shorts.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static Short[] wrap(short ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Short[0];
        }
        Short[] array = new Short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static short[] unwrap(Short ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new short[0];
        }
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Optional.ofNullable(values[i]).orElse((short)0);
        }
        return array;
    }

    public static short[] sub(short[] array, int start, int end) {
        int length = array.length;
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new short[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new short[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static short[] remove(short[] array, int index) throws IllegalArgumentException {
        if (null == array) {
            return null;
        }
        int length = array.length;
        if (index < 0 || index >= length) {
            return array;
        }
        short[] result = new short[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static short[] removeElement(short[] array, short element) throws IllegalArgumentException {
        return Shorts.remove(array, Shorts.indexOf(array, element));
    }

    public static short[] reverse(short[] array, int startIndexInclusive, int endIndexExclusive) {
        if (Shorts.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            Shorts.swap(array, i, j);
        }
        return array;
    }

    public static short[] reverse(short[] array) {
        return Shorts.reverse(array, 0, array.length);
    }

    public static short min(short ... numberArray) {
        if (Shorts.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static short max(short ... numberArray) {
        if (Shorts.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static short[] shuffle(short[] array) {
        return Shorts.shuffle(array, Randoms.getRandom());
    }

    public static short[] shuffle(short[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            Shorts.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static short[] swap(short[] array, int index1, int index2) {
        short tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static int indexOf(short[] array, short value) {
        if (Shorts.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short value) {
        if (Shorts.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(short[] array, short value) {
        return Shorts.indexOf(array, value) > -1;
    }

    public static boolean isSorted(short[] array) {
        return Shorts.isSortedAsc(array);
    }

    public static boolean isSortedAsc(short[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDesc(short[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(short[] array) {
        return !Shorts.isEmpty(array);
    }
}

