/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.log.support;

import io.polaris.core.collection.ObjectArrays;
import io.polaris.core.log.ILogger;
import io.polaris.core.string.Strings;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JdkLogger
implements ILogger {
    static final String INNER_CALLER = JdkLogger.class.getName();
    private final Logger logger;

    public JdkLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    public JdkLogger(Class clazz) {
        this.logger = Logger.getLogger(clazz.getName());
    }

    private void fillSource(LogRecord record) {
        this.fillSource(record, null);
    }

    private void fillSource(LogRecord record, Throwable throwable) {
        if (throwable != null) {
            record.setThrown(throwable);
        }
        if (record.getSourceClassName() == null) {
            if (throwable == null) {
                throwable = new Throwable();
            }
            StackTraceElement[] frames = throwable.getStackTrace();
            for (int i = 0; i < frames.length; ++i) {
                StackTraceElement frame = frames[i];
                String cname = frame.getClassName();
                if (cname.equals(INNER_CALLER)) continue;
                record.setSourceClassName(cname);
                record.setSourceMethodName(frame.getMethodName());
                break;
            }
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.ALL);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void trace(String msg) {
        this.trace(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void trace(String msg, Object ... arguments) {
        this.trace(msg, arguments, null);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.trace(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void trace(String msg, Object[] arguments, Throwable t) {
        if (this.isTraceEnabled()) {
            LogRecord lr = new LogRecord(Level.ALL, Strings.format(msg, arguments));
            this.fillSource(lr, t);
            this.logger.log(lr);
        }
    }

    @Override
    public void trace(Throwable t, String msg, Object ... arguments) {
        this.trace(msg, arguments, t);
    }

    @Override
    public void debug(String msg) {
        this.debug(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void debug(String msg, Object ... arguments) {
        this.debug(msg, arguments, null);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.debug(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void debug(String msg, Object[] arguments, Throwable t) {
        if (this.isDebugEnabled()) {
            LogRecord lr = new LogRecord(Level.FINE, Strings.format(msg, arguments));
            this.fillSource(lr, t);
            this.logger.log(lr);
        }
    }

    @Override
    public void debug(Throwable t, String msg, Object ... arguments) {
        this.debug(msg, arguments, t);
    }

    @Override
    public void info(String msg) {
        this.info(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void info(String msg, Object ... arguments) {
        this.info(msg, arguments, null);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.info(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void info(String msg, Object[] arguments, Throwable t) {
        if (this.isInfoEnabled()) {
            LogRecord lr = new LogRecord(Level.INFO, Strings.format(msg, arguments));
            this.fillSource(lr, t);
            this.logger.log(lr);
        }
    }

    @Override
    public void info(Throwable t, String msg, Object ... arguments) {
        this.info(msg, arguments, t);
    }

    @Override
    public void warn(String msg) {
        this.warn(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void warn(String msg, Object ... arguments) {
        this.warn(msg, arguments, null);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.warn(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void warn(String msg, Object[] arguments, Throwable t) {
        if (this.isWarnEnabled()) {
            LogRecord lr = new LogRecord(Level.WARNING, Strings.format(msg, arguments));
            this.fillSource(lr, t);
            this.logger.log(lr);
        }
    }

    @Override
    public void warn(Throwable t, String msg, Object ... arguments) {
        this.warn(msg, arguments, t);
    }

    @Override
    public void error(String msg) {
        this.error(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void error(String msg, Object ... arguments) {
        this.error(msg, arguments, null);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.error(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void error(String msg, Object[] arguments, Throwable t) {
        if (this.isErrorEnabled()) {
            LogRecord lr = new LogRecord(Level.SEVERE, Strings.format(msg, arguments));
            this.fillSource(lr, t);
            this.logger.log(lr);
        }
    }

    @Override
    public void error(Throwable t, String msg, Object ... arguments) {
        this.error(msg, arguments, t);
    }
}

