/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.log.support;

import io.polaris.core.log.support.IStack;
import io.polaris.core.log.support.Log4j2Stack;
import io.polaris.core.log.support.NoopStack;
import io.polaris.core.log.support.Slf4jStack;
import java.util.ArrayDeque;
import java.util.Objects;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.MDC;

public class LogStack {
    private static IStack iStack;

    public static void put(String key, String val) {
        iStack.put(key, val);
    }

    public static String get(String key) {
        return iStack.get(key);
    }

    public static void remove(String key) {
        iStack.remove(key);
    }

    public static void clear() {
        iStack.clear();
    }

    public static void push(String msg) {
        iStack.push(msg);
    }

    public static void pushIfAbsent(String msg) {
        String last = iStack.peek();
        if (!Objects.equals(last, msg)) {
            iStack.push(msg);
        }
    }

    public static void pop(String msg) {
        String pop;
        ArrayDeque<String> queue = new ArrayDeque<String>();
        while ((pop = LogStack.pop()) != null && pop.trim().length() != 0 && !pop.equals(msg)) {
            queue.addLast(pop);
        }
        for (String s : queue) {
            LogStack.push(s);
        }
    }

    public static String pop() {
        return iStack.pop();
    }

    public static String peek() {
        return iStack.peek();
    }

    static {
        try {
            ThreadContext.peek();
            iStack = new Log4j2Stack();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (iStack == null) {
            try {
                MDC.getMDCAdapter();
                iStack = new Slf4jStack();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (iStack == null) {
            iStack = new NoopStack();
        }
    }
}

