/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.map;

import java.util.Map;
import java.util.function.Consumer;

public class FluentMap<K, V> {
    private final Map<K, V> map;

    public FluentMap(Map<K, V> map) {
        this.map = map;
    }

    public static <K, V> FluentMap<K, V> of(Map<K, V> map) {
        return new FluentMap<K, V>(map);
    }

    public Map<K, V> get() {
        return this.map;
    }

    public FluentMap<K, V> visit(Consumer<Map<K, V>> consumer) {
        consumer.accept(this.map);
        return this;
    }

    public FluentMap<K, V> put(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    public FluentMap<K, V> remove(Object key) {
        this.map.remove(key);
        return this;
    }

    public FluentMap<K, V> putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
        return this;
    }

    public FluentMap<K, V> clear() {
        this.map.clear();
        return this;
    }
}

