/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.net.http;

import io.polaris.core.string.Strings;
import java.nio.charset.Charset;

public enum ContentType {
    FORM_URLENCODED("application/x-www-form-urlencoded"),
    MULTIPART("multipart/form-data"),
    JSON("application/json"),
    XML("application/xml"),
    TEXT_XML("text/xml");

    private String value;

    private ContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public String toString(String charset) {
        return this.value + ";charset=" + charset;
    }

    public String toString(Charset charset) {
        return this.value + ";charset=" + charset.name();
    }

    public static boolean isFormUrlEncoded(String contentType) {
        return contentType.startsWith(ContentType.FORM_URLENCODED.value);
    }

    public static ContentType get(String body) {
        ContentType contentType = null;
        if (Strings.isNotBlank(body)) {
            char firstChar = body.charAt(0);
            switch (firstChar) {
                case '[': 
                case '{': {
                    contentType = JSON;
                    break;
                }
                case '<': {
                    contentType = XML;
                    break;
                }
            }
        }
        return contentType;
    }
}

