/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.net.http;

import io.polaris.core.net.http.ContentType;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class RequestSettings {
    public static final String POST = "POST";
    public static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36 Edg/113.0.1774.50";
    private String url;
    private SSLContext sslContext;
    private String keyStorePassword;
    private String keyStorePath;
    private String requestMethod;
    private String content;
    private String charset;
    private ContentType contentType;
    private Map<String, String> headers;
    private String userAgent;
    private int connectTimeout;
    private int readTimeout;
    private boolean readBytes = false;

    public String getRequestMethod() {
        return Strings.isNotBlank(this.requestMethod) ? this.requestMethod : POST;
    }

    public ContentType getContentType() {
        return this.contentType != null ? this.contentType : ContentType.JSON;
    }

    public String getCharset() {
        return Strings.isNotBlank(this.charset) ? this.charset : "UTF-8";
    }

    public String getUserAgent() {
        return Strings.isNotBlank(this.userAgent) ? this.userAgent : DEFAULT_USER_AGENT;
    }

    public RequestSettings withHeader(String name, String value) {
        (this.headers == null ? (this.headers = new HashMap<String, String>()) : this.headers).put(name, value);
        return this;
    }

    public RequestSettings withUrl(String url) {
        this.url = url;
        return this;
    }

    public RequestSettings withSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public RequestSettings withKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public RequestSettings withKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public RequestSettings withRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public RequestSettings withContent(String content) {
        this.content = content;
        return this;
    }

    public RequestSettings withCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public RequestSettings withContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public RequestSettings withHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public RequestSettings withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public RequestSettings withConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public RequestSettings withReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public RequestSettings withReadBytes(boolean readBytes) {
        this.readBytes = readBytes;
        return this;
    }

    public static void main(String[] args) {
        Field[] fields;
        for (Field field2 : fields = Reflects.getFields(RequestSettings.class, field -> !Modifier.isStatic(field.getModifiers()))) {
            String methodName = "with" + Strings.capitalize(field2.getName());
            Method method = Reflects.getPublicMethod(RequestSettings.class, methodName, field2.getType());
            if (method != null) continue;
            System.out.printf("public %s %s(%s %s){\n\tthis.%s = %s;\n\treturn this;\n}\n", RequestSettings.class.getSimpleName(), methodName, field2.getGenericType().getTypeName(), field2.getName(), field2.getName(), field2.getName());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getContent() {
        return this.content;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isReadBytes() {
        return this.readBytes;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setReadBytes(boolean readBytes) {
        this.readBytes = readBytes;
    }
}

