/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.os;

import io.polaris.core.io.IO;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.os.OS;
import io.polaris.core.os.OsType;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Shells {
    private static final ILogger log = ILoggers.of(Shells.class);

    public static Result executeScriptContent(File workDir, String scriptFileName, String scriptContent) throws IOException {
        Shells.makeScriptFile(workDir, scriptFileName, scriptContent);
        return Shells.execute(workDir, Shells.wrapCmd(scriptFileName));
    }

    public static Result executeScriptContent(File workDir, String scriptFileName, String scriptContent, String cmdArgs) throws IOException {
        Shells.makeScriptFile(workDir, scriptFileName, scriptContent);
        return Shells.execute(workDir, Shells.wrapCmd(scriptFileName + " " + cmdArgs));
    }

    public static Result executeScriptContent(String charset, File workDir, String scriptFileName, String scriptContent) throws IOException {
        Shells.makeScriptFile(workDir, scriptFileName, scriptContent, charset);
        return Shells.execute(charset, workDir, Shells.wrapCmd(scriptFileName));
    }

    public static Result executeScriptContent(String charset, File workDir, String scriptFileName, String scriptContent, String cmdArgs) throws IOException {
        Shells.makeScriptFile(workDir, scriptFileName, scriptContent, charset);
        return Shells.execute(charset, workDir, Shells.wrapCmd(scriptFileName + " " + cmdArgs));
    }

    public static Result executeScriptContent(String charset, Map<String, String> env, File workDir, String scriptFileName, String scriptContent) throws IOException {
        Shells.makeScriptFile(workDir, scriptFileName, scriptContent, charset);
        return Shells.execute(charset, env, workDir, Shells.wrapCmd(scriptFileName));
    }

    public static Result executeScriptContent(String charset, Map<String, String> env, File workDir, String scriptFileName, String scriptContent, String cmdArgs) throws IOException {
        Shells.makeScriptFile(workDir, scriptFileName, scriptContent, charset);
        return Shells.execute(charset, env, workDir, Shells.wrapCmd(scriptFileName + " " + cmdArgs));
    }

    public static void makeScriptFile(String scriptFileName, String content) throws IOException {
        Shells.makeScriptFile(null, scriptFileName, content, "UTF-8");
    }

    public static void makeScriptFile(String scriptFileName, String content, String charset) throws IOException {
        Shells.makeScriptFile(null, scriptFileName, content, charset);
    }

    public static void makeScriptFile(File workDir, String scriptFileName, String content) throws IOException {
        Shells.makeScriptFile(workDir, scriptFileName, content, "UTF-8");
    }

    public static void makeScriptFile(File workDir, String scriptFileName, String content, String charset) throws IOException {
        File scriptFile = workDir != null ? new File(workDir, scriptFileName) : new File(scriptFileName);
        FileOutputStream fos = null;
        try {
            scriptFile.createNewFile();
            scriptFile.setExecutable(true);
            fos = new FileOutputStream(scriptFile);
            fos.write(content.getBytes(charset));
            fos.flush();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IO.close(fos);
                throw throwable;
            }
        }
        IO.close(fos);
    }

    public static String[] wrapCmd(String cmdStr) {
        OsType osType = OS.getOsType();
        switch (osType) {
            case WINDOWS: {
                return new String[]{"cmd", "/c", cmdStr};
            }
            case LINUX: 
            case MAC: 
            case SOLARIS: {
                return new String[]{"/bin/sh", "-c", '\"' + cmdStr.replace("\\", "\\\\").replace("\"", "\\\"") + '\"'};
            }
        }
        return Shells.parse(cmdStr);
    }

    public static String[] parse(String cmdStr) {
        ArrayList<String> list = new ArrayList<String>();
        char[] chs = cmdStr.toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        boolean singleQuota = false;
        boolean doubleQuota = false;
        for (char ch : chs) {
            if (ch == '\\') {
                escape = !escape;
                sb.append(ch);
                continue;
            }
            if (escape) {
                sb.append(ch);
                escape = false;
                continue;
            }
            if (ch == '\"') {
                if (singleQuota) {
                    sb.append(ch);
                    continue;
                }
                if (doubleQuota) {
                    doubleQuota = false;
                    if (sb.length() <= 0) continue;
                    list.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                doubleQuota = true;
                continue;
            }
            if (ch == '\'') {
                if (doubleQuota) {
                    sb.append(ch);
                    continue;
                }
                if (singleQuota) {
                    singleQuota = false;
                    if (sb.length() <= 0) continue;
                    list.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                singleQuota = true;
                continue;
            }
            if (doubleQuota || singleQuota) {
                sb.append(ch);
                continue;
            }
            if (Character.isWhitespace(ch)) {
                if (sb.length() <= 0) continue;
                list.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
            sb.setLength(0);
        }
        return list.toArray(new String[0]);
    }

    public static Result execute(String charset, File workDir, String ... cmdLine) {
        return Shells.execute(charset, null, workDir, cmdLine);
    }

    public static Result execute(File workDir, String ... cmdLine) {
        return Shells.execute("UTF-8", null, workDir, cmdLine);
    }

    public static Result execute(String charset, Map<String, String> env, File workDir, String ... cmdLine) {
        if (cmdLine.length == 0) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (workDir != null) {
            processBuilder.directory(workDir);
        }
        if (env != null) {
            processBuilder.environment().putAll(env);
        }
        processBuilder.command(cmdLine);
        Process process = null;
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            return Shells.toErrorResult(bos, e);
        }
        try {
            return Shells.waitFor(bos, process, charset);
        }
        catch (InterruptedException e) {
            return Shells.toErrorResult(bos, e);
        }
    }

    public static Result waitFor(Process process) throws InterruptedException {
        return Shells.waitFor(new ByteArrayOutputStream(), process, "UTF-8");
    }

    public static Result waitFor(Process process, String charset) throws InterruptedException {
        return Shells.waitFor(new ByteArrayOutputStream(), process, charset);
    }

    private static Result waitFor(ByteArrayOutputStream bos, Process process, String charset) throws InterruptedException {
        StreamCollector outputCollector = new StreamCollector(charset, process.getInputStream(), bos);
        StreamCollector errorCollector = new StreamCollector(charset, process.getErrorStream(), bos);
        outputCollector.start();
        errorCollector.start();
        int code = process.waitFor();
        outputCollector.waitFor();
        errorCollector.waitFor();
        return new Result(code, bos.toString());
    }

    private static Result toErrorResult(ByteArrayOutputStream bos, Exception ex) {
        ex.printStackTrace(new PrintStream(bos));
        return new Result(-1, bos.toString());
    }

    static class StreamCollector {
        private final InputStream in;
        private final OutputStream out;
        private final String charset;
        private final Lock lock;
        private final Condition condition;
        private volatile boolean completed = false;
        private Thread thread;

        public StreamCollector(InputStream in, OutputStream out) {
            this("UTF-8", in, out);
        }

        public StreamCollector(String charset, InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
            this.charset = charset;
            this.lock = new ReentrantLock();
            this.condition = this.lock.newCondition();
            this.thread = new Thread(() -> {
                BufferedReader br = null;
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(in, charset));
                    while ((line = br.readLine()) != null) {
                        if (out == null) continue;
                        out.write(line.getBytes());
                        out.write("\n".getBytes());
                    }
                    out.flush();
                    this.completed = true;
                }
                catch (IOException e) {
                    try {
                        if (out != null) {
                            e.printStackTrace(new PrintStream(out));
                        }
                        this.completed = true;
                    }
                    catch (Throwable throwable) {
                        this.completed = true;
                        IO.close(br);
                        throw throwable;
                    }
                    IO.close(br);
                }
                IO.close(br);
                this.lock.lock();
                try {
                    this.condition.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            });
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void waitFor() {
            if (this.completed) {
                return;
            }
            this.lock.lock();
            try {
                this.condition.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void start() {
            this.thread.start();
        }
    }

    public static final class Result {
        private final int exitCode;
        private final String output;

        public Result(int exitCode, String output) {
            this.output = output;
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getOutput() {
            return this.output;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (this.exitCode != other.exitCode) {
                return false;
            }
            String this$output = this.output;
            String other$output = other.output;
            return !(this$output == null ? other$output != null : !this$output.equals(other$output));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.exitCode;
            String $output = this.output;
            result = result * 59 + ($output == null ? 43 : $output.hashCode());
            return result;
        }

        public String toString() {
            return "Shells.Result(exitCode=" + this.exitCode + ", output=" + this.output + ")";
        }
    }
}

