/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.random;

import io.polaris.core.collection.Iterables;
import io.polaris.core.string.Strings;
import java.awt.Color;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class Randoms {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_CHAR = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String BASE_CHAR_LOWER = "abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_CHAR_NUMBER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final String BASE_CHAR_NUMBER_LOWER = "abcdefghijklmnopqrstuvwxyz0123456789";

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom createSecureRandom(byte[] seed) {
        return seed == null ? new SecureRandom() : new SecureRandom(seed);
    }

    public static SecureRandom getSecureRandom() {
        return Randoms.getSecureRandom(null);
    }

    public static SecureRandom getSecureRandom(byte[] seed) {
        return Randoms.createSecureRandom(seed);
    }

    public static SecureRandom getSHA1PRNGRandom(byte[] seed) throws NoSuchAlgorithmException {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        if (null != seed) {
            random.setSeed(seed);
        }
        return random;
    }

    public static Random getRandom(boolean isSecure) {
        return isSecure ? Randoms.getSecureRandom() : Randoms.getRandom();
    }

    public static boolean randomBoolean() {
        return 0 == Randoms.randomInt(2);
    }

    public static char randomChinese() {
        return (char)Randoms.randomInt(19968, 40959);
    }

    public static int randomInt(int min, int max) {
        return Randoms.getRandom().nextInt(min, max);
    }

    public static int randomInt() {
        return Randoms.getRandom().nextInt();
    }

    public static int randomInt(int limit) {
        return Randoms.getRandom().nextInt(limit);
    }

    public static long randomLong(long min, long max) {
        return Randoms.getRandom().nextLong(min, max);
    }

    public static long randomLong() {
        return Randoms.getRandom().nextLong();
    }

    public static long randomLong(long limit) {
        return Randoms.getRandom().nextLong(limit);
    }

    public static double randomDouble(double min, double max) {
        return Randoms.getRandom().nextDouble(min, max);
    }

    public static double randomDouble() {
        return Randoms.getRandom().nextDouble();
    }

    public static double randomDouble(double limit) {
        return Randoms.getRandom().nextDouble(limit);
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        Randoms.getRandom().nextBytes(bytes);
        return bytes;
    }

    public static <T> T randomElement(List<T> list) {
        return Randoms.randomElement(list, list.size());
    }

    public static <T> T randomElement(List<T> list, int limit) {
        if (list.size() < limit || limit < 0) {
            limit = list.size();
        }
        return list.get(Randoms.randomInt(limit));
    }

    public static <T> T randomElement(T[] array) {
        return Randoms.randomElement(array, array.length);
    }

    public static <T> T randomElement(T[] array, int limit) {
        if (array.length < limit || limit < 0) {
            limit = array.length;
        }
        return array[Randoms.randomInt(limit)];
    }

    public static <T> List<T> randomSubList(List<T> source, int count) {
        int size = source.size();
        if (count >= size) {
            return Iterables.asList(source);
        }
        ArrayList<T> result = new ArrayList<T>();
        int[] indices = Randoms.randomIndices(size);
        for (int i = 0; i < count; ++i) {
            result.add(source.get(indices[i]));
        }
        return result;
    }

    public static <T> Set<T> randomSubSet(Set<T> set, int count) {
        int size = set.size();
        if (count >= size) {
            return Iterables.asCollection(LinkedHashSet::new, set);
        }
        ArrayList<T> source = new ArrayList<T>(set);
        LinkedHashSet<T> result = new LinkedHashSet<T>(count);
        int[] indices = Randoms.randomIndices(size);
        for (int i = 0; i < count; ++i) {
            result.add(source.get(indices[i]));
        }
        return result;
    }

    public static int[] randomIndices(int length) {
        int i;
        int[] range = new int[length];
        for (i = 0; i < length; ++i) {
            range[i] = i;
        }
        for (i = 0; i < length; ++i) {
            int random = Randoms.randomInt(i, length);
            int v = range[i];
            range[i] = range[random];
            range[random] = v;
        }
        return range;
    }

    public static String randomString(String baseString, int length) {
        if (Strings.isEmpty(baseString)) {
            return "";
        }
        if (length < 1) {
            length = 1;
        }
        StringBuilder sb = new StringBuilder(length);
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = Randoms.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public static String randomNumberString(int length) {
        return Randoms.randomString(BASE_NUMBER, length);
    }

    public static String randomString(int length) {
        return Randoms.randomString(BASE_CHAR_NUMBER, length);
    }

    public static String randomStringLowerCase(int length) {
        return Randoms.randomString(BASE_CHAR_NUMBER_LOWER, length);
    }

    public static String randomChineseString(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(Randoms.randomChinese());
        }
        return sb.toString();
    }

    public static char randomNumberChar() {
        return Randoms.randomChar(BASE_NUMBER);
    }

    public static char randomChar() {
        return Randoms.randomChar(BASE_CHAR_NUMBER);
    }

    public static char randomChar(String baseString) {
        return baseString.charAt(Randoms.randomInt(baseString.length()));
    }

    public static Color randomColor() {
        ThreadLocalRandom random = Randoms.getRandom();
        return new Color(((Random)random).nextInt(256), ((Random)random).nextInt(256), ((Random)random).nextInt(256));
    }

    public static Date randomDate(Date baseDate, int min, int max) {
        long time = baseDate.getTime();
        return new Date(time += (long)Randoms.randomInt(min, max));
    }
}

