/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.regex;

import io.polaris.core.regex.Patterns;
import java.util.regex.Pattern;

public interface PatternConsts {
    public static final Pattern IDENTIFIER = Patterns.getPattern("\\w+");
    public static final Pattern IDENTIFIER_WHOLE = Patterns.quoteWhole(IDENTIFIER);
    public static final Pattern DIGIT = Patterns.getPattern("\\d+");
    public static final Pattern DIGIT_WHOLE = Patterns.quoteWhole(DIGIT);
    public static final Pattern ALPHABET = Patterns.getPattern("[a-zA-Z]+");
    public static final Pattern ALPHABET_WHOLE = Patterns.quoteWhole(ALPHABET);
    public static final Pattern CHINESE = Patterns.getPattern("[\u2e80-\u2eff\u2f00-\u2fdf\u31c0-\u31ef\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\ud840\udc00-\ud869\udedf\ud869\udf00-\ud86d\udf3f\ud86d\udf40-\ud86e\udc1f\ud86e\udc20-\ud873\udeaf\ud87e\udc00-\ud87e\ude1f]+");
    public static final Pattern CHINESE_WHOLE = Patterns.quoteWhole(CHINESE);
    public static final Pattern IPV4 = Patterns.getPattern("(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)");
    public static final Pattern IPV4_WHOLE = Patterns.quoteWhole(IPV4);
    public static final Pattern IPV6 = Patterns.getPattern("(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]+|::(ffff(:0{1,4})?:)?((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9]))");
    public static final Pattern IPV6_WHOLE = Patterns.quoteWhole(IPV6);
    public static final Pattern MONEY = Patterns.getPattern("(\\d+(?:\\.\\d+)?)");
    public static final Pattern MONEY_WHOLE = Patterns.quoteWhole(MONEY);
    public static final Pattern EMAIL = Patterns.getPattern("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])");
    public static final Pattern EMAIL_WHOLE = Patterns.quoteWhole(EMAIL);
    public static final Pattern EMAIL_WITH_CHINESE = Patterns.getPattern("(?:[a-z0-9\\u4e00-\\u9fa5!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9\\u4e00-\\u9fa5!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9\\u4e00-\\u9fa5](?:[a-z0-9\\u4e00-\\u9fa5-]*[a-z0-9\\u4e00-\\u9fa5])?\\.)+[a-z0-9\\u4e00-\\u9fa5](?:[a-z0-9\\u4e00-\\u9fa5-]*[a-z0-9\\u4e00-\\u9fa5])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9\\u4e00-\\u9fa5-]*[a-z0-9\\u4e00-\\u9fa5]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])");
    public static final Pattern EMAIL_WITH_CHINESE_WHOLE = Patterns.quoteWhole(EMAIL_WITH_CHINESE);
    public static final Pattern MOBILE = Patterns.getPattern("(?:0|86|\\+86)?1[3-9]\\d{9}");
    public static final Pattern MOBILE_WHOLE = Patterns.quoteWhole(MOBILE);
    public static final Pattern MOBILE_HK = Patterns.getPattern("(?:0|852|\\+852)?\\d{8}");
    public static final Pattern MOBILE_HK_WHOLE = Patterns.quoteWhole(MOBILE_HK);
    public static final Pattern MOBILE_TW = Patterns.getPattern("(?:0|886|\\+886)?(?:|-)09\\d{8}");
    public static final Pattern MOBILE_TW_WHOLE = Patterns.quoteWhole(MOBILE_TW);
    public static final Pattern MOBILE_MO = Patterns.getPattern("(?:0|853|\\+853)?(?:|-)6\\d{7}");
    public static final Pattern MOBILE_MO_WHOLE = Patterns.quoteWhole(MOBILE_MO);
    public static final Pattern TEL = Patterns.getPattern("(010|02\\d|0[3-9]\\d{2})-?(\\d{6,8})");
    public static final Pattern TEL_WHOLE = Patterns.quoteWhole(TEL);
    public static final Pattern TEL_400_800 = Patterns.getPattern("0\\d{2,3}[\\- ]?[1-9]\\d{6,7}|[48]00[\\- ]?[1-9]\\d{2}[\\- ]?\\d{4}");
    public static final Pattern TEL_400_800_WHOLE = Patterns.quoteWhole(TEL_400_800);
    public static final Pattern CITIZEN_ID = Patterns.getPattern("[1-9]\\d{5}[1-2]\\d{3}((0\\d)|(1[0-2]))(([012]\\d)|3[0-1])\\d{3}(\\d|X|x)");
    public static final Pattern CITIZEN_ID_WHOLE = Patterns.quoteWhole(CITIZEN_ID);
    public static final Pattern ZIP_CODE = Patterns.getPattern("(0[1-7]|1[0-356]|2[0-7]|3[0-6]|4[0-7]|5[0-7]|6[0-7]|7[0-5]|8[0-9]|9[0-8])\\d{4}|99907[78]");
    public static final Pattern ZIP_CODE_WHOLE = Patterns.quoteWhole(ZIP_CODE);
    public static final Pattern BIRTHDAY = Patterns.getPattern("(\\d{2,4})([/\\-.\u5e74]?)(\\d{1,2})([/\\-.\u6708]?)(\\d{1,2})\u65e5?");
    public static final Pattern BIRTHDAY_WHOLE = Patterns.quoteWhole(BIRTHDAY);
    public static final Pattern URI = Patterns.getPattern("(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    public static final Pattern URI_WHOLE = Patterns.quoteWhole(URI);
    public static final Pattern URL = Patterns.getPattern("[a-zA-Z]+://[\\w-+&@#/%?=~_|!:,.;]*[\\w-+&@#/%=~_|]");
    public static final Pattern URL_WHOLE = Patterns.quoteWhole(URL);
    public static final Pattern URL_HTTP = Patterns.getPattern("(https?|ftp|file)://[\\w-+&@#/%?=~_|!:,.;]*[\\w-+&@#/%=~_|]");
    public static final Pattern URL_HTTP_WHOLE = Patterns.quoteWhole(URL_HTTP);
    public static final Pattern IDENTIFIER_WITH_CHINESE = Patterns.getPattern("[\u4e00-\u9fff\\w]+");
    public static final Pattern IDENTIFIER_WITH_CHINESE_WHOLE = Patterns.quoteWhole(IDENTIFIER_WITH_CHINESE);
    public static final Pattern UUID = Patterns.getPattern("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
    public static final Pattern UUID_WHOLE = Patterns.quoteWhole(UUID);
    public static final Pattern UUID_SIMPLE = Patterns.getPattern("[0-9a-fA-F]{32}");
    public static final Pattern UUID_SIMPLE_WHOLE = Patterns.quoteWhole(UUID_SIMPLE);
    public static final Pattern MAC_ADDRESS = Patterns.getPattern("((?:[a-fA-F0-9]{1,2}[:-]){5}[a-fA-F0-9]{1,2})|0x(\\d{12}).+ETHER");
    public static final Pattern MAC_ADDRESS_WHOLE = Patterns.quoteWhole(MAC_ADDRESS);
    public static final Pattern HEX = Patterns.getPattern("[a-fA-F0-9]+");
    public static final Pattern HEX_WHOLE = Patterns.quoteWhole(HEX);
    public static final Pattern TIME = Patterns.getPattern("\\d{1,2}[:\u65f6]\\d{1,2}([:\u5206]\\d{1,2})?\u79d2?");
    public static final Pattern TIME_WHOLE = Patterns.quoteWhole(TIME);
    public static final Pattern PLATE_NUMBER = Patterns.getPattern("(([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886][A-Z](([0-9]{5}[ABCDEFGHJK])|([ABCDEFGHJK]([A-HJ-NP-Z0-9])[0-9]{4})))|([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886]\\d{3}\\d{1,3}[\u9886])|([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886][A-Z][A-HJ-NP-Z0-9]{4}[A-HJ-NP-Z0-9\u6302\u5b66\u8b66\u6e2f\u6fb3\u4f7f\u9886]))");
    public static final Pattern PLATE_NUMBER_WHOLE = Patterns.quoteWhole(PLATE_NUMBER);
    public static final Pattern CREDIT_CODE = Patterns.getPattern("[0-9A-HJ-NPQRTUWXY]{2}\\d{6}[0-9A-HJ-NPQRTUWXY]{10}");
    public static final Pattern CREDIT_CODE_WHOLE = Patterns.quoteWhole(CREDIT_CODE);
    public static final Pattern CAR_VIN = Patterns.getPattern("[A-HJ-NPR-Z0-9]{8}[X0-9]([A-HJ-NPR-Z0-9]{3}\\d{5}|[A-HJ-NPR-Z0-9]{5}\\d{3})");
    public static final Pattern CAR_VIN_WHOLE = Patterns.quoteWhole(CAR_VIN);
    public static final Pattern CAR_DRIVING_LICENCE = Patterns.getPattern("[0-9]{12}");
    public static final Pattern CAR_DRIVING_LICENCE_WHOLE = Patterns.quoteWhole(CAR_DRIVING_LICENCE);
    public static final Pattern CHINESE_NAME = Patterns.getPattern("[\u2e80-\u9fff\u00b7]{2,60}");
    public static final Pattern CHINESE_NAME_WHOLE = Patterns.quoteWhole(CHINESE_NAME);
}

