/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.regex;

import io.polaris.core.collection.Sets;
import io.polaris.core.string.Strings;
import io.polaris.core.tuple.Tuple2;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Patterns {
    private static final Map<String, Pattern> CACHED_PATTERNS = new ConcurrentHashMap<String, Pattern>();
    private static final Map<Tuple2<String, Integer>, Pattern> CACHED_FLAG_PATTERNS = new ConcurrentHashMap<Tuple2<String, Integer>, Pattern>();
    private static final Set<Character> RE_KEYS = Sets.asSet(Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'));

    public static Pattern getPattern(String regex) {
        return CACHED_PATTERNS.computeIfAbsent(regex, k -> Pattern.compile(regex));
    }

    public static Pattern getPattern(String regex, int flags) {
        return CACHED_FLAG_PATTERNS.computeIfAbsent(Tuple2.of(regex, flags), k -> Pattern.compile(regex, flags));
    }

    public static Pattern getWholePattern(String regex) {
        return Patterns.getPattern(Patterns.quoteWhole(regex));
    }

    public static Pattern getWholePattern(String regex, int flags) {
        return Patterns.getPattern(Patterns.quoteWhole(regex), flags);
    }

    public static String quote(String regex) {
        return Pattern.quote(regex);
    }

    public static Pattern quoteWhole(Pattern pattern) {
        return Patterns.getWholePattern(pattern.pattern(), pattern.flags());
    }

    public static String quoteWhole(String regex) {
        if (regex.startsWith("^")) {
            if (regex.endsWith("$")) {
                return regex;
            }
            return regex + "$";
        }
        if (regex.endsWith("$")) {
            return "^" + regex;
        }
        return "^" + regex + "$";
    }

    public static boolean find(String regex, CharSequence content) {
        return Patterns.getPattern(regex).matcher(content).find();
    }

    public static boolean find(Pattern pattern, CharSequence content) {
        return pattern.matcher(content).find();
    }

    public static boolean matches(String regex, CharSequence content) {
        return Patterns.getPattern(regex).matcher(content).matches();
    }

    public static boolean matches(Pattern pattern, CharSequence content) {
        return pattern.matcher(content).matches();
    }

    public static boolean matchesAny(Pattern pattern, CharSequence ... contents) {
        if (contents != null) {
            for (CharSequence content : contents) {
                if (!Patterns.matches(pattern, content)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matchesAll(Pattern pattern, CharSequence ... contents) {
        if (contents != null) {
            for (CharSequence content : contents) {
                if (Patterns.matches(pattern, content)) continue;
                return false;
            }
        }
        return true;
    }

    public static Matcher matcher(String regex, CharSequence content) {
        return Patterns.getPattern(regex).matcher(content);
    }

    public static Matcher matcher(Pattern pattern, CharSequence content) {
        return pattern.matcher(content);
    }

    public static String getGroup(String regex, CharSequence content, int groupIndex) {
        return Patterns.getGroup(Patterns.getPattern(regex), content, groupIndex);
    }

    public static String getGroup(String regex, CharSequence content, String groupName) {
        return Patterns.getGroup(Patterns.getPattern(regex), content, groupName);
    }

    public static String getGroup(Pattern pattern, CharSequence content, int groupIndex) {
        Matcher m = pattern.matcher(content);
        if (m.find()) {
            return m.group(groupIndex);
        }
        return null;
    }

    public static String getGroup(Pattern pattern, CharSequence content, String groupName) {
        Matcher m = pattern.matcher(content);
        if (m.find()) {
            return m.group(groupName);
        }
        return null;
    }

    public static List<String> getAllGroups(String regex, CharSequence content, boolean withGroup0) {
        return Patterns.getAllGroups(Patterns.getPattern(regex), content, withGroup0, false);
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content, boolean withGroup0) {
        return Patterns.getAllGroups(pattern, content, withGroup0, false);
    }

    public static List<String> getAllGroups(String regex, CharSequence content, boolean withGroup0, boolean findAll) {
        return Patterns.getAllGroups(Patterns.getPattern(regex), content, withGroup0, findAll);
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content, boolean withGroup0, boolean findAll) {
        if (null == content || null == pattern) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            int startGroup = withGroup0 ? 0 : 1;
            int groupCount = matcher.groupCount();
            for (int i = startGroup; i <= groupCount; ++i) {
                result.add(matcher.group(i));
            }
            if (findAll) continue;
            break;
        }
        return result;
    }

    public static MatchResult indexOf(String regex, CharSequence content) {
        return Patterns.indexOf(Patterns.getPattern(regex), content);
    }

    public static MatchResult indexOf(Pattern pattern, CharSequence content) {
        Matcher matcher;
        if (null != pattern && null != content && (matcher = pattern.matcher(content)).find()) {
            return matcher.toMatchResult();
        }
        return null;
    }

    public static MatchResult lastIndexOf(String regex, CharSequence content) {
        return Patterns.lastIndexOf(Patterns.getPattern(regex), content);
    }

    public static MatchResult lastIndexOf(Pattern pattern, CharSequence content) {
        MatchResult result = null;
        if (null != pattern && null != content) {
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                result = matcher.toMatchResult();
            }
        }
        return result;
    }

    public static String escape(char c) {
        StringBuilder builder = new StringBuilder();
        if (RE_KEYS.contains(Character.valueOf(c))) {
            builder.append('\\');
        }
        builder.append(c);
        return builder.toString();
    }

    public static String escape(CharSequence content) {
        if (Strings.isBlank(content)) {
            return content == null ? null : content.toString();
        }
        StringBuilder builder = new StringBuilder();
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char current = content.charAt(i);
            if (RE_KEYS.contains(Character.valueOf(current))) {
                builder.append('\\');
            }
            builder.append(current);
        }
        return builder.toString();
    }
}

