/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.script;

import io.polaris.core.cache.ICache;
import io.polaris.core.cache.MapCache;
import io.polaris.core.crypto.digest.Digests;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.script.Evaluator;
import io.polaris.core.script.ScriptEvalException;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public abstract class AbstractStandardEvaluator
implements Evaluator {
    private static final ILogger log = ILoggers.of(AbstractStandardEvaluator.class);
    public static final String OUT = "out";
    public static final String ERR = "err";
    protected final ScriptEngineManager manager = new ScriptEngineManager();
    protected final ScriptEngine scriptEngine;
    private boolean compilable;
    private ICache<String, CompiledScript> cache;

    public AbstractStandardEvaluator() {
        String engineName = this.getEngineName();
        this.scriptEngine = this.manager.getEngineByName(engineName);
        if (this.scriptEngine != null) {
            this.initGlobalScope(this.scriptEngine);
            if (this.scriptEngine instanceof Compilable) {
                this.compilable = true;
                ICache<String, CompiledScript> iCache = this.createCache();
                if (iCache == null) {
                    iCache = new MapCache<String, CompiledScript>(4096, true);
                }
                this.cache = iCache;
            }
        } else {
            log.error("\u811a\u672c\u5f15\u64ce\u4e0d\u652f\u6301:{}", engineName);
        }
    }

    protected abstract String getEngineName();

    protected ICache<String, CompiledScript> createCache() {
        return null;
    }

    protected void initGlobalScope(ScriptEngine scriptEngine) {
        Bindings globalBindings = scriptEngine.createBindings();
        globalBindings.put(OUT, (Object)System.out);
        globalBindings.put(ERR, (Object)System.err);
        scriptEngine.setBindings(globalBindings, 200);
    }

    protected ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String scriptContent, Object input, Object output, Map<String, Object> mergeBindings) throws ScriptEvalException {
        try {
            Object rs;
            if (this.scriptEngine == null) {
                throw new ScriptEvalException("\u811a\u672c\u5f15\u64ce\u4e0d\u652f\u6301:" + this.getEngineName());
            }
            Bindings bindings = this.scriptEngine.createBindings();
            if (mergeBindings != null) {
                bindings.putAll((Map<? extends String, ? extends Object>)mergeBindings);
                bindings.put("bindings", (Object)mergeBindings);
            } else if (input instanceof Map) {
                bindings.putAll((Map)input);
            }
            bindings.put("input", input);
            if (output == null) {
                bindings.put("output", (Object)new LinkedHashMap());
            } else {
                bindings.put("output", output);
            }
            if (this.compilable) {
                String sourceId = Base64.getEncoder().encodeToString(Digests.sha1(scriptContent));
                CompiledScript compiledScript = this.cache.getIfPresent(sourceId);
                if (compiledScript == null) {
                    AbstractStandardEvaluator abstractStandardEvaluator = this;
                    synchronized (abstractStandardEvaluator) {
                        compiledScript = this.cache.getIfPresent(sourceId);
                        if (compiledScript == null) {
                            compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(scriptContent);
                            this.cache.put(sourceId, compiledScript);
                        }
                    }
                }
                rs = compiledScript.eval(bindings);
            } else {
                rs = this.scriptEngine.eval(scriptContent, bindings);
            }
            if (output instanceof Map) {
                ((Map)output).putIfAbsent("result", rs);
            }
            return rs;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ScriptEvalException(e.getMessage(), e);
        }
    }
}

