/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.string;

public class KmpMatchers {
    public static boolean contains(CharSequence container, CharSequence pattern) {
        return KmpMatchers.indexOf(container, pattern) >= 0;
    }

    public static boolean contains(char[] container, char[] pattern) {
        return KmpMatchers.indexOf(container, pattern) >= 0;
    }

    public static int indexOf(CharSequence container, CharSequence pattern) {
        return KmpMatchers.indexOf(container, pattern, 0);
    }

    public static int indexOf(CharSequence container, CharSequence pattern, int fromIndex) {
        int cl = container.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= cl) {
            return -1;
        }
        int pl = pattern.length();
        if (pl == 0) {
            return fromIndex;
        }
        if (cl - fromIndex < pl) {
            return -1;
        }
        if (pl == 1) {
            for (int i = fromIndex; i < cl; ++i) {
                if (container.charAt(i) != pattern.charAt(0)) continue;
                return i;
            }
            return -1;
        }
        int[] next = KmpMatchers.calcNextArray(pattern);
        int j = 0;
        int i = fromIndex;
        while (i < cl) {
            if (container.charAt(i) == pattern.charAt(j)) {
                if (j == pl - 1) {
                    return i - j;
                }
                ++i;
                ++j;
                continue;
            }
            if (j == 0) {
                ++i;
                continue;
            }
            j = next[j];
        }
        return -1;
    }

    public static int indexOf(char[] container, char[] pattern) {
        return KmpMatchers.indexOf(container, pattern, 0);
    }

    public static int indexOf(char[] container, char[] pattern, int fromIndex) {
        int cl = container.length;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= cl) {
            return -1;
        }
        int pl = pattern.length;
        if (pl == 0) {
            return fromIndex;
        }
        if (cl - fromIndex < pl) {
            return -1;
        }
        if (pl == 1) {
            for (int i = fromIndex; i < cl; ++i) {
                if (container[i] != pattern[0]) continue;
                return i;
            }
            return -1;
        }
        int[] next = KmpMatchers.calcNextArray(pattern);
        int j = 0;
        int i = fromIndex;
        while (i < cl) {
            if (container[i] == pattern[j]) {
                if (j == pl - 1) {
                    return i - j;
                }
                ++i;
                ++j;
                continue;
            }
            if (j == 0) {
                ++i;
                continue;
            }
            j = next[j];
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence container, CharSequence pattern) {
        return KmpMatchers.indexOfIgnoreCase(container.toString().toCharArray(), pattern.toString().toCharArray());
    }

    public static int indexOfIgnoreCase(CharSequence container, CharSequence pattern, int fromIndex) {
        int cl = container.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= cl) {
            return -1;
        }
        int pl = pattern.length();
        if (pl == 0) {
            return fromIndex;
        }
        if (cl - fromIndex < pl) {
            return -1;
        }
        if (pl == 1) {
            for (int i = fromIndex; i < cl; ++i) {
                if (container.charAt(i) != pattern.charAt(0) && container.charAt(i) != Character.toLowerCase(pattern.charAt(0))) continue;
                return i;
            }
            return -1;
        }
        int[] next = KmpMatchers.calcNextArray(pattern);
        int j = 0;
        int i = fromIndex;
        while (i < cl) {
            if (container.charAt(i) == pattern.charAt(j) || container.charAt(i) == Character.toLowerCase(pattern.charAt(j))) {
                if (j == pl - 1) {
                    return i - j;
                }
                ++i;
                ++j;
                continue;
            }
            if (j == 0) {
                ++i;
                continue;
            }
            j = next[j];
        }
        return -1;
    }

    public static int indexOfIgnoreCase(char[] container, char[] pattern) {
        return KmpMatchers.indexOfIgnoreCase(container, pattern, 0);
    }

    public static int indexOfIgnoreCase(char[] container, char[] pattern, int fromIndex) {
        int cl = container.length;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= cl) {
            return -1;
        }
        int pl = pattern.length;
        if (pl == 0) {
            return fromIndex;
        }
        if (cl - fromIndex < pl) {
            return -1;
        }
        if (pl == 1) {
            for (int i = fromIndex; i < cl; ++i) {
                if (container[i] != pattern[0] && container[i] != Character.toLowerCase(pattern[0])) continue;
                return i;
            }
            return -1;
        }
        int[] next = KmpMatchers.calcNextArray(pattern);
        int j = 0;
        int i = fromIndex;
        while (i < cl) {
            if (container[i] == pattern[j] || container[i] == Character.toLowerCase(pattern[j])) {
                if (j == pl - 1) {
                    return i - j;
                }
                ++i;
                ++j;
                continue;
            }
            if (j == 0) {
                ++i;
                continue;
            }
            j = next[j];
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence container, CharSequence pattern) {
        return KmpMatchers.lastIndexOf(container.toString().toCharArray(), pattern.toString().toCharArray());
    }

    public static int lastIndexOf(CharSequence container, CharSequence pattern, int fromIndex) {
        return KmpMatchers.lastIndexOf(container.toString().toCharArray(), pattern.toString().toCharArray(), fromIndex);
    }

    public static int lastIndexOf(char[] container, char[] pattern) {
        return KmpMatchers.lastIndexOf(container, pattern, container.length - 1);
    }

    public static int lastIndexOf(char[] container, char[] pattern, int fromIndex) {
        int pl;
        int cl = container.length;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex >= cl) {
            fromIndex = cl - 1;
        }
        if ((pl = pattern.length) == 0) {
            return fromIndex;
        }
        if (fromIndex + 1 < pl) {
            return -1;
        }
        if (pl == 1) {
            for (int i = fromIndex; i >= 0; --i) {
                if (container[i] != pattern[0]) continue;
                return i;
            }
            return -1;
        }
        int[] next = KmpMatchers.calcNextArrayReverse(pattern);
        int j = 0;
        int i = fromIndex;
        while (i >= 0) {
            if (container[i] == pattern[pl - j - 1]) {
                if (j == pl - 1) {
                    return i;
                }
                --i;
                ++j;
                continue;
            }
            if (j == 0) {
                --i;
                continue;
            }
            j = next[j];
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence container, CharSequence pattern) {
        return KmpMatchers.lastIndexOfIgnoreCase(container.toString().toCharArray(), pattern.toString().toCharArray());
    }

    public static int lastIndexOfIgnoreCase(CharSequence container, CharSequence pattern, int fromIndex) {
        return KmpMatchers.lastIndexOfIgnoreCase(container.toString().toCharArray(), pattern.toString().toCharArray(), fromIndex);
    }

    public static int lastIndexOfIgnoreCase(char[] container, char[] pattern) {
        return KmpMatchers.lastIndexOfIgnoreCase(container, pattern, container.length - 1);
    }

    public static int lastIndexOfIgnoreCase(char[] container, char[] pattern, int fromIndex) {
        int pl;
        int cl = container.length;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex >= cl) {
            fromIndex = cl - 1;
        }
        if ((pl = pattern.length) == 0) {
            return fromIndex;
        }
        if (fromIndex + 1 < pl) {
            return -1;
        }
        if (pl == 1) {
            for (int i = fromIndex; i >= 0; --i) {
                if (container[i] != pattern[0] && container[i] != Character.toLowerCase(pattern[0])) continue;
                return i;
            }
            return -1;
        }
        int[] next = KmpMatchers.calcNextArrayReverse(pattern);
        int j = 0;
        int i = fromIndex;
        while (i >= 0) {
            if (container[i] == pattern[pl - j - 1] || container[i] == Character.toLowerCase(pattern[pl - j - 1])) {
                if (j == pl - 1) {
                    return i;
                }
                --i;
                ++j;
                continue;
            }
            if (j == 0) {
                --i;
                continue;
            }
            j = next[j];
        }
        return -1;
    }

    static int[] calcNextArray(CharSequence pattern) {
        return KmpMatchers.calcNextArray(pattern.toString().toCharArray());
    }

    static int[] calcNextArray(char[] pattern) {
        int len = pattern.length;
        int[] next = new int[len];
        if (len == 0) {
            return next;
        }
        next[0] = -1;
        if (len == 1) {
            return next;
        }
        next[1] = 0;
        int i = 2;
        int lastVal = next[1];
        while (i < len) {
            if (pattern[i - 1] == pattern[lastVal]) {
                next[i++] = ++lastVal;
                continue;
            }
            if (lastVal == 0) {
                next[i++] = 0;
                continue;
            }
            lastVal = next[lastVal];
        }
        return next;
    }

    static int[] calcNextArrayReverse(CharSequence pattern) {
        return KmpMatchers.calcNextArrayReverse(pattern.toString().toCharArray());
    }

    static int[] calcNextArrayReverse(char[] pattern) {
        int len = pattern.length;
        int[] next = new int[len];
        if (len == 0) {
            return next;
        }
        next[0] = -1;
        if (len == 1) {
            return next;
        }
        next[1] = 0;
        int i = 2;
        int lastVal = next[1];
        while (i < len) {
            if (pattern[len - i] == pattern[len - 1 - lastVal]) {
                next[i++] = ++lastVal;
                continue;
            }
            if (lastVal == 0) {
                next[i++] = 0;
                continue;
            }
            lastVal = next[lastVal];
        }
        return next;
    }
}

