/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.time;

import io.polaris.core.time.DateConsts;
import io.polaris.core.time.Dates;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public class Calendars
implements DateConsts {
    public static String format(String format, Calendar calendar) {
        return Dates.format(format, calendar.getTime());
    }

    public static String formatDefault(Calendar calendar) {
        return Dates.formatDefault(calendar.getTime());
    }

    public static Calendar parse(@Nonnull String format, @Nonnull String calendar) {
        return Calendars.toCalendar(Dates.parseDate(format, calendar));
    }

    public static Calendar parse(@Nonnull String val) {
        return Calendars.toCalendar(Dates.parseDate(val));
    }

    public static Calendar toCalendar(@Nonnull Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static Calendar toCalendar(@Nonnull Date date, TimeZone tz) {
        Calendar c = Calendar.getInstance(tz);
        c.setTime(date);
        return c;
    }

    public static boolean isSameDay(@Nonnull Calendar cal1, @Nonnull Calendar cal2) {
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameDay(@Nonnull Date date1, @Nonnull Date date2) {
        return Calendars.isSameDay(Calendars.toCalendar(date1), Calendars.toCalendar(date2));
    }

    public static boolean isSameInstant(@Nonnull Date date1, @Nonnull Date date2) {
        return date1.getTime() == date2.getTime();
    }

    public static boolean isSameInstant(@Nonnull Calendar cal1, @Nonnull Calendar cal2) {
        return cal1.getTime().getTime() == cal2.getTime().getTime();
    }

    public static Calendar ceil(Calendar cal, int field) {
        return Calendars.upOrDown(cal, field, 1);
    }

    public static Calendar floor(Calendar cal, int field) {
        return Calendars.upOrDown(cal, field, -1);
    }

    public static Calendar round(Calendar cal, int field) {
        return Calendars.upOrDown(cal, field, 0);
    }

    private static Calendar upOrDown(Calendar cal, int field, int upOrDown) {
        boolean trim = false;
        boolean withHourOfDay = false;
        switch (field) {
            case 1: {
                if (upOrDown == 0) {
                    Calendars.setRoundVal(cal, 1, 0);
                } else if (upOrDown > 0) {
                    Calendars.setCeilVal(cal, new int[]{1, 2, 5, 11, 12, 13, 14}, 0);
                } else {
                    Calendars.floorFieldVal(cal, 1);
                }
                trim = true;
            }
            case 2: {
                if (trim) {
                    cal.set(2, cal.getActualMinimum(2));
                } else {
                    if (upOrDown == 0) {
                        Calendars.setRoundVal(cal, 2, 1);
                    } else if (upOrDown > 0) {
                        Calendars.setCeilVal(cal, new int[]{2, 5, 11, 12, 13, 14}, 1);
                    } else {
                        Calendars.floorFieldVal(cal, 2);
                    }
                    trim = true;
                }
            }
            case 5: {
                if (trim) {
                    cal.set(5, cal.getActualMinimum(5));
                } else {
                    if (upOrDown == 0) {
                        Calendars.setRoundVal(cal, 5, 2);
                    } else if (upOrDown > 0) {
                        Calendars.setCeilVal(cal, new int[]{5, 11, 12, 13, 14}, 2);
                    } else {
                        Calendars.floorFieldVal(cal, 5);
                    }
                    trim = true;
                }
            }
            case 11: {
                if (trim) {
                    cal.set(11, cal.getActualMinimum(11));
                } else {
                    if (upOrDown == 0) {
                        Calendars.setRoundVal(cal, 11, 5);
                    } else if (upOrDown > 0) {
                        Calendars.setCeilVal(cal, new int[]{11, 12, 13, 14}, 5);
                    } else {
                        Calendars.floorFieldVal(cal, 11);
                    }
                    trim = true;
                }
                withHourOfDay = true;
            }
            case 10: {
                if (!withHourOfDay) {
                    if (upOrDown == 0) {
                        Calendars.setRoundVal(cal, 10, 9);
                    } else if (upOrDown > 0) {
                        Calendars.setCeilVal(cal, new int[]{10, 12, 13, 14}, 9);
                    } else {
                        Calendars.floorFieldVal(cal, 10);
                    }
                    trim = true;
                }
            }
            case 12: {
                if (trim) {
                    cal.set(12, cal.getActualMinimum(12));
                } else {
                    if (upOrDown == 0) {
                        Calendars.setRoundVal(cal, 12, 11);
                    } else if (upOrDown > 0) {
                        Calendars.setCeilVal(cal, new int[]{12, 13, 14}, 11);
                    } else {
                        Calendars.floorFieldVal(cal, 12);
                    }
                    trim = true;
                }
            }
            case 13: {
                if (trim) {
                    cal.set(13, cal.getActualMinimum(13));
                } else {
                    if (upOrDown == 0) {
                        Calendars.setRoundVal(cal, 13, 12);
                    } else if (upOrDown > 0) {
                        Calendars.setCeilVal(cal, new int[]{13, 14}, 12);
                    } else {
                        Calendars.floorFieldVal(cal, 13);
                    }
                    trim = true;
                }
            }
            case 14: {
                if (trim) {
                    cal.set(14, cal.getActualMinimum(14));
                    break;
                }
                if (upOrDown == 0) {
                    Calendars.setRoundVal(cal, 14, 13);
                } else if (upOrDown > 0) {
                    Calendars.setCeilVal(cal, new int[]{14}, 13);
                } else {
                    Calendars.floorFieldVal(cal, 14);
                }
                trim = true;
            }
        }
        return cal;
    }

    private static void setCeilVal(@Nonnull Calendar cal, int[] fields, int upField) {
        for (int field : fields) {
            int min;
            int v = cal.get(field);
            if (v <= (min = cal.getActualMinimum(field))) continue;
            cal.set(field, min);
            if (upField > 0) {
                cal.add(upField, 1);
            }
            return;
        }
    }

    private static void floorFieldVal(@Nonnull Calendar cal, int field) {
        int min;
        int v = cal.get(field);
        if (v > (min = cal.getActualMinimum(field))) {
            cal.set(field, min);
        }
    }

    private static void setRoundVal(@Nonnull Calendar cal, int field, int upField) {
        int max;
        int min;
        int v = cal.get(field);
        if (v - (min = cal.getActualMinimum(field)) >= (max = cal.getActualMaximum(field)) - v) {
            cal.set(field, min);
            if (upField > 0) {
                cal.add(upField, 1);
            }
        } else {
            cal.set(field, min);
        }
    }

    public static Date addYears(@Nonnull Date date, int amount) {
        return Calendars.add(date, 1, amount);
    }

    public static Date addMonths(@Nonnull Date date, int amount) {
        return Calendars.add(date, 2, amount);
    }

    public static Date addWeeks(@Nonnull Date date, int amount) {
        return Calendars.add(date, 3, amount);
    }

    public static Date addDays(@Nonnull Date date, int amount) {
        return Calendars.add(date, 5, amount);
    }

    public static Date addHours(@Nonnull Date date, int amount) {
        return Calendars.add(date, 11, amount);
    }

    public static Date addMinutes(@Nonnull Date date, int amount) {
        return Calendars.add(date, 12, amount);
    }

    public static Date addSeconds(@Nonnull Date date, int amount) {
        return Calendars.add(date, 13, amount);
    }

    public static Date addMilliseconds(@Nonnull Date date, int amount) {
        return Calendars.add(date, 14, amount);
    }

    public static Date add(@Nonnull Date date, int calendarField, int amount) {
        return Calendars.add(Calendars.toCalendar(date), calendarField, amount).getTime();
    }

    public static Calendar addYears(@Nonnull Calendar calendar, int amount) {
        return Calendars.add(calendar, 1, amount);
    }

    public static Calendar addMonths(@Nonnull Calendar calendar, int amount) {
        return Calendars.add(calendar, 2, amount);
    }

    public static Calendar addWeeks(@Nonnull Calendar calendar, int amount) {
        return Calendars.add(calendar, 3, amount);
    }

    public static Calendar addDays(@Nonnull Calendar calendar, int amount) {
        return Calendars.add(calendar, 5, amount);
    }

    public static Calendar addHours(@Nonnull Calendar calendar, int amount) {
        return Calendars.add(calendar, 11, amount);
    }

    public static Calendar addMinutes(@Nonnull Calendar calendar, int amount) {
        return Calendars.add(calendar, 12, amount);
    }

    public static Calendar addSeconds(@Nonnull Calendar calendar, int amount) {
        return Calendars.add(calendar, 13, amount);
    }

    public static Calendar addMilliseconds(@Nonnull Calendar calendar, int amount) {
        return Calendars.add(calendar, 14, amount);
    }

    public static Calendar add(@Nonnull Calendar calendar, int calendarField, int amount) {
        calendar.add(calendarField, amount);
        return calendar;
    }

    public static Date setYear(@Nonnull Date date, int amount) {
        return Calendars.set(date, 1, amount);
    }

    public static Date setMonth(@Nonnull Date date, int amount) {
        return Calendars.set(date, 2, amount);
    }

    public static Date setDay(@Nonnull Date date, int amount) {
        return Calendars.set(date, 5, amount);
    }

    public static Date setHour(@Nonnull Date date, int amount) {
        return Calendars.set(date, 11, amount);
    }

    public static Date setMinute(@Nonnull Date date, int amount) {
        return Calendars.set(date, 12, amount);
    }

    public static Date setSecond(@Nonnull Date date, int amount) {
        return Calendars.set(date, 13, amount);
    }

    public static Date setMillisecond(@Nonnull Date date, int amount) {
        return Calendars.set(date, 14, amount);
    }

    private static Date set(@Nonnull Date date, int calendarField, int amount) {
        return Calendars.set(Calendars.toCalendar(date), calendarField, amount).getTime();
    }

    public static Calendar setYear(@Nonnull Calendar calendar, int amount) {
        return Calendars.set(calendar, 1, amount);
    }

    public static Calendar setMonth(@Nonnull Calendar calendar, int amount) {
        return Calendars.set(calendar, 2, amount);
    }

    public static Calendar setDay(@Nonnull Calendar calendar, int amount) {
        return Calendars.set(calendar, 5, amount);
    }

    public static Calendar setHour(@Nonnull Calendar calendar, int amount) {
        return Calendars.set(calendar, 11, amount);
    }

    public static Calendar setMinute(@Nonnull Calendar calendar, int amount) {
        return Calendars.set(calendar, 12, amount);
    }

    public static Calendar setSecond(@Nonnull Calendar calendar, int amount) {
        return Calendars.set(calendar, 13, amount);
    }

    public static Calendar setMillisecond(@Nonnull Calendar calendar, int amount) {
        return Calendars.set(calendar, 14, amount);
    }

    public static Calendar set(@Nonnull Calendar calendar, int calendarField, int amount) {
        calendar.set(calendarField, amount);
        return calendar;
    }

    public static int getYear(@Nonnull Date date) {
        return Calendars.toCalendar(date).get(1);
    }

    public static int getMonth(@Nonnull Date date) {
        return Calendars.toCalendar(date).get(2);
    }

    public static int getDay(@Nonnull Date date) {
        return Calendars.toCalendar(date).get(5);
    }

    public static int getHour(@Nonnull Date date) {
        return Calendars.toCalendar(date).get(11);
    }

    public static int getMinute(@Nonnull Date date) {
        return Calendars.toCalendar(date).get(12);
    }

    public static int getSecond(@Nonnull Date date) {
        return Calendars.toCalendar(date).get(13);
    }

    public static int getMillisecond(@Nonnull Date date) {
        return Calendars.toCalendar(date).get(14);
    }

    public static int get(@Nonnull Date date, int calendarField) {
        return Calendars.get(Calendars.toCalendar(date), calendarField);
    }

    public static int getYear(@Nonnull Calendar calendar) {
        return calendar.get(1);
    }

    public static int getMonth(@Nonnull Calendar calendar) {
        return calendar.get(2);
    }

    public static int getDay(@Nonnull Calendar calendar) {
        return calendar.get(5);
    }

    public static int getHour(@Nonnull Calendar calendar) {
        return calendar.get(11);
    }

    public static int getMinute(@Nonnull Calendar calendar) {
        return calendar.get(12);
    }

    public static int getSecond(@Nonnull Calendar calendar) {
        return calendar.get(13);
    }

    public static int getMillisecond(@Nonnull Calendar calendar) {
        return calendar.get(14);
    }

    public static int get(@Nonnull Calendar calendar, int calendarField) {
        return calendar.get(calendarField);
    }
}

