/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.time;

import io.polaris.core.time.DateConsts;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateFormats
implements DateConsts {
    private static ThreadLocal<Map<String, DateFormat>> LOCAL = ThreadLocal.withInitial(ConcurrentHashMap::new);

    public static DateFormat get(String pattern) {
        return LOCAL.get().computeIfAbsent(pattern, p -> new SimpleDateFormat(pattern));
    }

    public static String formatNow(String pattern) {
        return DateFormats.get(pattern).format(new Date());
    }

    public static String format(Date date, String pattern) {
        return DateFormats.get(pattern).format(date);
    }

    public static String format(Calendar calendar, String pattern) {
        return DateFormats.get(pattern).format(calendar.getTime());
    }

    public static String format(long millis, String pattern) {
        return DateFormats.get(pattern).format(new Date(millis));
    }

    public static String formatDefault(Date date) {
        return DateFormats.get("yyyy-MM-dd HH:mm:ss.SSS").format(date);
    }

    public static String formatDefault(Calendar calendar) {
        return DateFormats.get("yyyy-MM-dd HH:mm:ss.SSS").format(calendar.getTime());
    }

    public static String formatDefault(long millis) {
        return DateFormats.get("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(millis));
    }

    public static Date parse(String date, String pattern) throws ParseException {
        return DateFormats.get(pattern).parse(date);
    }

    public static Date parseDefault(String date) throws ParseException {
        return DateFormats.get("yyyy-MM-dd HH:mm:ss.SSS").parse(date);
    }
}

