/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.time;

import io.polaris.core.time.DateConsts;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Dates
implements DateConsts {
    private static final Map<String, DateTimeFormatter> formatterCache = new ConcurrentHashMap<String, DateTimeFormatter>();
    public static final DateTimeFormatter YYYYMMDD = Dates.getFormatter("yyyyMMdd");
    public static final DateTimeFormatter YYYYMMDDHHMMSS = Dates.getFormatter("yyyyMMddHHmmss");
    public static final DateTimeFormatter YYYYMMDDHHMMSSSSS = Dates.getFormatter("yyyyMMddHHmmssSSS");
    public static final DateTimeFormatter HHMMSS = Dates.getFormatter("HHmmss");
    public static final DateTimeFormatter HHMMSSSSS = Dates.getFormatter("HHmmssSSS");
    public static final DateTimeFormatter YYYY_MM_DD = Dates.getFormatter("yyyy-MM-dd");
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = Dates.getFormatter("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_SSS = Dates.getFormatter("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateTimeFormatter HH_MM_SS = Dates.getFormatter("HH:mm:ss");
    public static final DateTimeFormatter HH_MM_SS_SSS = Dates.getFormatter("HH:mm:ss.SSS");

    public static DateTimeFormatter getFormatter(String formatterStr) {
        return formatterCache.computeIfAbsent(formatterStr, key -> DateTimeFormatter.ofPattern(formatterStr).withZone(ZoneId.systemDefault()));
    }

    public static Instant now() {
        return Instant.now();
    }

    public static String nowStr() {
        return YYYY_MM_DD_HH_MM_SS_SSS.format(LocalDateTime.now());
    }

    public static Date nowDate() {
        return new Date();
    }

    public static String formatDefault(LocalDateTime localDateTime) {
        return YYYY_MM_DD_HH_MM_SS_SSS.format(localDateTime);
    }

    public static String formatDefault(TemporalAccessor temporal) {
        return YYYY_MM_DD_HH_MM_SS_SSS.format(Dates.toLocalDateTime(temporal));
    }

    public static String format(String format, TemporalAccessor temporal) {
        return Dates.getFormatter(format).format(temporal);
    }

    public static String formatDefault(Date date) {
        return YYYY_MM_DD_HH_MM_SS_SSS.format(Dates.toLocalDateTime(date));
    }

    public static String format(String format, Date date) {
        return Dates.getFormatter(format).format(Dates.toLocalDateTime(date));
    }

    public static TemporalAccessor parse(String format, String temporal) {
        return Dates.getFormatter(format).parse(temporal);
    }

    public static Date parseDate(String format, String temporal) {
        return Dates.toDate(Dates.getFormatter(format).parse(temporal));
    }

    public static LocalDateTime parseLocalDateTime(String format, String temporal) {
        return Dates.toLocalDateTime(Dates.getFormatter(format).parse(temporal));
    }

    public static LocalDate parseLocalDate(String format, String temporal) {
        return Dates.toLocalDate(Dates.getFormatter(format).parse(temporal));
    }

    public static LocalTime parseLocalTime(String format, String temporal) {
        return Dates.toLocalTime(Dates.getFormatter(format).parse(temporal));
    }

    public static TemporalAccessor parse(String valueStr) {
        TemporalAccessor accessor = null;
        try {
            if (valueStr.length() == "yyyy-MM-dd HH:mm:ss.SSS".length()) {
                accessor = YYYY_MM_DD_HH_MM_SS_SSS.parse(valueStr);
            } else if (valueStr.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                accessor = YYYY_MM_DD_HH_MM_SS.parse(valueStr);
            } else if (valueStr.length() == "yyyy-MM-dd".length()) {
                accessor = YYYY_MM_DD.parse(valueStr);
            } else if (valueStr.length() == "yyyyMMddHHmmssSSS".length()) {
                accessor = YYYYMMDDHHMMSSSSS.parse(valueStr);
            } else if (valueStr.length() == "yyyyMMddHHmmss".length()) {
                accessor = YYYYMMDDHHMMSS.parse(valueStr);
            } else if (valueStr.length() == "yyyyMMdd".length()) {
                try {
                    accessor = YYYYMMDD.parse(valueStr);
                }
                catch (Exception e) {
                    accessor = HH_MM_SS.parse(valueStr);
                }
            } else if (valueStr.length() == "HH:mm:ss.SSS".length()) {
                accessor = HH_MM_SS_SSS.parse(valueStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (accessor == null) {
            accessor = DateTimeFormatter.ISO_DATE_TIME.parse(valueStr);
        }
        return accessor;
    }

    public static Date parseDate(String valueStr) {
        return Dates.toDate(Dates.parse(valueStr));
    }

    public static LocalDateTime parseLocalDateTime(String valueStr) {
        return Dates.toLocalDateTime(Dates.parse(valueStr));
    }

    public static LocalDate parseLocalDate(String valueStr) {
        return Dates.toLocalDate(Dates.parse(valueStr));
    }

    public static LocalTime parseLocalTime(String valueStr) {
        return Dates.toLocalTime(Dates.parse(valueStr));
    }

    public static long toMills(Date date) {
        return date.getTime();
    }

    public static long toMills(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long toMills(Instant instant) {
        return instant.toEpochMilli();
    }

    public static long toMills(TemporalAccessor temporal) {
        return Dates.toMills(Dates.toLocalDateTime(temporal));
    }

    public static Date toDate(long mills) {
        return new Date(mills);
    }

    public static Date toDate(Instant instant) {
        return Date.from(instant);
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(Dates.toInstant(localDateTime));
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(Dates.toInstant(localDate));
    }

    public static Date toDate(TemporalAccessor temporal) {
        return Dates.toDate(Dates.toLocalDateTime(temporal));
    }

    public static Instant toInstant(long mills) {
        return Instant.ofEpochMilli(mills);
    }

    public static Instant toInstant(Date date) {
        return date.toInstant();
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Instant toInstant(LocalDate localDate) {
        return localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Instant toInstant(TemporalAccessor temporal) {
        return Dates.toInstant(Dates.toLocalDateTime(temporal));
    }

    public static LocalDateTime toLocalDateTime(long mills) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(mills), ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(TemporalAccessor temporal) {
        if (temporal instanceof LocalDateTime) {
            return (LocalDateTime)temporal;
        }
        if (temporal instanceof Instant) {
            return LocalDateTime.ofInstant((Instant)temporal, ZoneId.systemDefault());
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toLocalDateTime();
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toLocalDateTime();
        }
        if (temporal instanceof LocalDate) {
            return LocalDateTime.of((LocalDate)temporal, LocalTime.of(0, 0, 0, 0));
        }
        if (temporal instanceof LocalTime) {
            return LocalDateTime.of(LocalDate.now(), (LocalTime)temporal);
        }
        if (temporal instanceof OffsetTime) {
            return LocalDateTime.of(LocalDate.now(), ((OffsetTime)temporal).toLocalTime());
        }
        if (temporal instanceof YearMonth) {
            return LocalDateTime.of(((YearMonth)temporal).atDay(1), LocalTime.of(0, 0, 0, 0));
        }
        if (temporal instanceof Year) {
            return LocalDateTime.of(((Year)temporal).atMonth(1).atDay(1), LocalTime.of(0, 0, 0, 0));
        }
        if (temporal instanceof Month) {
            return LocalDateTime.of(LocalDate.now().with(ChronoField.MONTH_OF_YEAR, ((Month)temporal).getValue()), LocalTime.of(0, 0, 0, 0));
        }
        if (temporal instanceof MonthDay) {
            return LocalDateTime.of(LocalDate.now().with(ChronoField.MONTH_OF_YEAR, ((MonthDay)temporal).getMonth().getValue()).with(ChronoField.DAY_OF_MONTH, ((MonthDay)temporal).getDayOfMonth()), LocalTime.of(0, 0, 0, 0));
        }
        if (temporal instanceof DayOfWeek) {
            return LocalDateTime.of(LocalDate.now().with(ChronoField.DAY_OF_WEEK, ((DayOfWeek)temporal).getValue()), LocalTime.of(0, 0, 0, 0));
        }
        int year = Dates.getChronoFieldOrDefault(temporal, ChronoField.YEAR);
        int month = Dates.getChronoFieldOrDefault(temporal, ChronoField.MONTH_OF_YEAR);
        int day = Dates.getChronoFieldOrDefault(temporal, ChronoField.DAY_OF_MONTH);
        int hour = Dates.getChronoFieldOrDefault(temporal, ChronoField.HOUR_OF_DAY);
        int minute = Dates.getChronoFieldOrDefault(temporal, ChronoField.MINUTE_OF_HOUR);
        int second = Dates.getChronoFieldOrDefault(temporal, ChronoField.SECOND_OF_MINUTE);
        int nano = Dates.getChronoFieldOrDefault(temporal, ChronoField.NANO_OF_SECOND);
        return LocalDateTime.of(year, month, day, hour, minute, second, nano);
    }

    public static LocalDate toLocalDate(long mills) {
        return Dates.toLocalDateTime(mills).toLocalDate();
    }

    public static LocalDate toLocalDate(Date date) {
        return Dates.toLocalDateTime(date).toLocalDate();
    }

    public static LocalDate toLocalDate(TemporalAccessor temporal) {
        if (temporal instanceof LocalDate) {
            return (LocalDate)temporal;
        }
        if (temporal instanceof Instant) {
            return ((Instant)temporal).atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (temporal instanceof LocalDateTime) {
            return ((LocalDateTime)temporal).toLocalDate();
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toLocalDate();
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toLocalDate();
        }
        if (temporal instanceof LocalTime) {
            return LocalDate.now();
        }
        if (temporal instanceof OffsetTime) {
            return LocalDate.now();
        }
        if (temporal instanceof YearMonth) {
            return ((YearMonth)temporal).atDay(1);
        }
        if (temporal instanceof Year) {
            return ((Year)temporal).atMonth(1).atDay(1);
        }
        if (temporal instanceof Month) {
            return LocalDate.now().with(ChronoField.MONTH_OF_YEAR, ((Month)temporal).getValue());
        }
        if (temporal instanceof MonthDay) {
            return LocalDate.now().with(ChronoField.MONTH_OF_YEAR, ((MonthDay)temporal).getMonth().getValue()).with(ChronoField.DAY_OF_MONTH, ((MonthDay)temporal).getDayOfMonth());
        }
        if (temporal instanceof DayOfWeek) {
            return LocalDate.now().with(ChronoField.DAY_OF_WEEK, ((DayOfWeek)temporal).getValue());
        }
        int year = Dates.getChronoFieldOrDefault(temporal, ChronoField.YEAR);
        int month = Dates.getChronoFieldOrDefault(temporal, ChronoField.MONTH_OF_YEAR);
        int day = Dates.getChronoFieldOrDefault(temporal, ChronoField.DAY_OF_MONTH);
        return LocalDate.of(year, month, day);
    }

    public static LocalTime toLocalTime(long mills) {
        return Dates.toLocalDateTime(mills).toLocalTime();
    }

    public static LocalTime toLocalTime(Date date) {
        return Dates.toLocalDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(TemporalAccessor temporal) {
        if (temporal instanceof LocalTime) {
            return (LocalTime)temporal;
        }
        if (temporal instanceof Instant) {
            return LocalDateTime.ofInstant((Instant)temporal, ZoneId.systemDefault()).toLocalTime();
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toLocalTime();
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toLocalTime();
        }
        if (temporal instanceof LocalDate) {
            return LocalTime.of(0, 0, 0, 0);
        }
        if (temporal instanceof OffsetTime) {
            return ((OffsetTime)temporal).toLocalTime();
        }
        if (temporal instanceof YearMonth) {
            return LocalTime.of(0, 0, 0, 0);
        }
        if (temporal instanceof Year) {
            return LocalTime.of(0, 0, 0, 0);
        }
        if (temporal instanceof Month) {
            return LocalTime.of(0, 0, 0, 0);
        }
        if (temporal instanceof MonthDay) {
            return LocalTime.of(0, 0, 0, 0);
        }
        if (temporal instanceof DayOfWeek) {
            return LocalTime.of(0, 0, 0, 0);
        }
        int hour = Dates.getChronoFieldOrDefault(temporal, ChronoField.HOUR_OF_DAY);
        int minute = Dates.getChronoFieldOrDefault(temporal, ChronoField.MINUTE_OF_HOUR);
        int second = Dates.getChronoFieldOrDefault(temporal, ChronoField.SECOND_OF_MINUTE);
        int nano = Dates.getChronoFieldOrDefault(temporal, ChronoField.NANO_OF_SECOND);
        return LocalTime.of(hour, minute, second, nano);
    }

    private static int getChronoFieldOrDefault(TemporalAccessor temporal, ChronoField field) {
        return temporal.isSupported(field) ? temporal.get(field) : (int)field.range().getMinimum();
    }

    public static int diffYears(Date t1, Date t2) {
        return Dates.diffYears(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
    }

    public static int diffMonths(Date t1, Date t2) {
        return Dates.diffMonths(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
    }

    public static long diffDays(Date t1, Date t2) {
        return Dates.diffDays(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
    }

    public static long diffHours(Date t1, Date t2) {
        return Dates.diffHours(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
    }

    public static long diffMinutes(Date t1, Date t2) {
        return Dates.diffMinutes(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
    }

    public static long diffSeconds(Date t1, Date t2) {
        return Dates.diffSeconds(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
    }

    public static long diffMillis(Date t1, Date t2) {
        return Dates.diffMillis(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
    }

    public static int diffYears(TemporalAccessor t1, TemporalAccessor t2) {
        Period period = Period.between(Dates.toLocalDate(t1), Dates.toLocalDate(t2));
        return period.getYears();
    }

    public static int diffMonths(TemporalAccessor t1, TemporalAccessor t2) {
        Period period = Period.between(Dates.toLocalDate(t1), Dates.toLocalDate(t2));
        return period.getYears() * 12 + period.getMonths();
    }

    public static long diffDays(TemporalAccessor t1, TemporalAccessor t2) {
        Duration duration = Duration.between(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
        return duration.toDays();
    }

    public static long diffHours(TemporalAccessor t1, TemporalAccessor t2) {
        Duration duration = Duration.between(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
        return duration.toHours();
    }

    public static long diffMinutes(TemporalAccessor t1, TemporalAccessor t2) {
        Duration duration = Duration.between(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
        return duration.toMinutes();
    }

    public static long diffSeconds(TemporalAccessor t1, TemporalAccessor t2) {
        Duration duration = Duration.between(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
        return duration.toMillis() / 1000L;
    }

    public static long diffMillis(TemporalAccessor t1, TemporalAccessor t2) {
        Duration duration = Duration.between(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
        return duration.toMillis();
    }

    public static long diffNanos(TemporalAccessor t1, TemporalAccessor t2) {
        Duration duration = Duration.between(Dates.toLocalDateTime(t1), Dates.toLocalDateTime(t2));
        return duration.toNanos();
    }
}

