/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.ulid;

import io.polaris.core.ulid.Ulid;
import io.polaris.core.ulid.UlidFactory;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class UlidCreator {
    private UlidCreator() {
    }

    public static Ulid getUlid() {
        return UlidFactoryHolder.INSTANCE.create();
    }

    public static Ulid getUlid(long time) {
        return UlidFactoryHolder.INSTANCE.create(time);
    }

    public static Ulid getMonotonicUlid() {
        return MonotonicFactoryHolder.INSTANCE.create();
    }

    public static Ulid getMonotonicUlid(long time) {
        return MonotonicFactoryHolder.INSTANCE.create(time);
    }

    public static Ulid getHashUlid(long time, String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return UlidCreator.getHashUlid(time, bytes);
    }

    public static Ulid getHashUlid(long time, byte[] bytes) {
        byte[] hash = UlidCreator.hasher("SHA-256").digest(bytes);
        byte[] rand = Arrays.copyOf(hash, 10);
        return new Ulid(time, rand);
    }

    private static MessageDigest hasher(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(String.format("%s not supported", algorithm));
        }
    }

    private static class MonotonicFactoryHolder {
        static final UlidFactory INSTANCE = UlidFactory.newMonotonicInstance();

        private MonotonicFactoryHolder() {
        }
    }

    private static class UlidFactoryHolder {
        static final UlidFactory INSTANCE = UlidFactory.newInstance();

        private UlidFactoryHolder() {
        }
    }
}

