/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.ulid;

import io.polaris.core.ulid.Ulid;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.LongSupplier;

public final class UlidFactory {
    private final LongSupplier timeFunction;
    private final LongFunction<Ulid> ulidFunction;
    private final ReentrantLock lock = new ReentrantLock();

    public UlidFactory() {
        this(new UlidFunction());
    }

    private UlidFactory(LongFunction<Ulid> ulidFunction) {
        this(ulidFunction, System::currentTimeMillis);
    }

    private UlidFactory(LongFunction<Ulid> ulidFunction, LongSupplier timeFunction) {
        Objects.requireNonNull(ulidFunction, "ULID function must not be null");
        Objects.requireNonNull(timeFunction, "Time function must not be null");
        this.ulidFunction = ulidFunction;
        this.timeFunction = timeFunction;
        if (this.ulidFunction instanceof MonotonicFunction) {
            ((MonotonicFunction)this.ulidFunction).initialize(this.timeFunction);
        }
    }

    public static UlidFactory newInstance() {
        return new UlidFactory(new UlidFunction());
    }

    public static UlidFactory newInstance(Random random) {
        return new UlidFactory(new UlidFunction(random));
    }

    public static UlidFactory newInstance(LongSupplier randomFunction) {
        return new UlidFactory(new UlidFunction(randomFunction));
    }

    public static UlidFactory newInstance(IntFunction<byte[]> randomFunction) {
        return new UlidFactory(new UlidFunction(randomFunction));
    }

    public static UlidFactory newMonotonicInstance() {
        return new UlidFactory(new MonotonicFunction());
    }

    public static UlidFactory newMonotonicInstance(Random random) {
        return new UlidFactory(new MonotonicFunction(random));
    }

    public static UlidFactory newMonotonicInstance(LongSupplier randomFunction) {
        return new UlidFactory(new MonotonicFunction(randomFunction));
    }

    public static UlidFactory newMonotonicInstance(IntFunction<byte[]> randomFunction) {
        return new UlidFactory(new MonotonicFunction(randomFunction));
    }

    public static UlidFactory newMonotonicInstance(Random random, LongSupplier timeFunction) {
        return new UlidFactory(new MonotonicFunction(random), timeFunction);
    }

    public static UlidFactory newMonotonicInstance(LongSupplier randomFunction, LongSupplier timeFunction) {
        return new UlidFactory(new MonotonicFunction(randomFunction), timeFunction);
    }

    public static UlidFactory newMonotonicInstance(IntFunction<byte[]> randomFunction, LongSupplier timeFunction) {
        return new UlidFactory(new MonotonicFunction(randomFunction), timeFunction);
    }

    public Ulid create() {
        return this.create(this.timeFunction.getAsLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ulid create(long time) {
        this.lock.lock();
        try {
            Ulid ulid = this.ulidFunction.apply(time);
            return ulid;
        }
        finally {
            this.lock.unlock();
        }
    }

    static class ByteRandom
    implements IRandom {
        private final IntFunction<byte[]> randomFunction;

        public ByteRandom() {
            this(ByteRandom.newRandomFunction(null));
        }

        public ByteRandom(Random random) {
            this(ByteRandom.newRandomFunction(random));
        }

        public ByteRandom(IntFunction<byte[]> randomFunction) {
            this.randomFunction = randomFunction != null ? randomFunction : ByteRandom.newRandomFunction(null);
        }

        @Override
        public long nextLong() {
            long number = 0L;
            byte[] bytes = this.randomFunction.apply(8);
            for (int i = 0; i < 8; ++i) {
                number = number << 8 | (long)(bytes[i] & 0xFF);
            }
            return number;
        }

        @Override
        public byte[] nextBytes(int length) {
            return this.randomFunction.apply(length);
        }

        static IntFunction<byte[]> newRandomFunction(Random random) {
            Random entropy = random != null ? random : new SecureRandom();
            return length -> {
                byte[] bytes = new byte[length];
                entropy.nextBytes(bytes);
                return bytes;
            };
        }
    }

    static class LongRandom
    implements IRandom {
        private final LongSupplier randomFunction;

        public LongRandom() {
            this(LongRandom.newRandomFunction(null));
        }

        public LongRandom(Random random) {
            this(LongRandom.newRandomFunction(random));
        }

        public LongRandom(LongSupplier randomFunction) {
            this.randomFunction = randomFunction != null ? randomFunction : LongRandom.newRandomFunction(null);
        }

        @Override
        public long nextLong() {
            return this.randomFunction.getAsLong();
        }

        @Override
        public byte[] nextBytes(int length) {
            int shift = 0;
            long random = 0L;
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                if (shift < 8) {
                    shift = 64;
                    random = this.randomFunction.getAsLong();
                }
                bytes[i] = (byte)(random >>> (shift -= 8));
            }
            return bytes;
        }

        static LongSupplier newRandomFunction(Random random) {
            Random entropy = random != null ? random : new SecureRandom();
            return entropy::nextLong;
        }
    }

    static interface IRandom {
        public long nextLong();

        public byte[] nextBytes(int var1);

        public static IRandom newInstance() {
            return new ByteRandom();
        }

        public static IRandom newInstance(Random random) {
            if (random == null) {
                return new ByteRandom();
            }
            if (random instanceof SecureRandom) {
                return new ByteRandom(random);
            }
            return new LongRandom(random);
        }

        public static IRandom newInstance(LongSupplier randomFunction) {
            return new LongRandom(randomFunction);
        }

        public static IRandom newInstance(IntFunction<byte[]> randomFunction) {
            return new ByteRandom(randomFunction);
        }
    }

    static final class MonotonicFunction
    implements LongFunction<Ulid> {
        private Ulid lastUlid;
        private final IRandom random;
        static final int CLOCK_DRIFT_TOLERANCE = 10000;

        private MonotonicFunction(IRandom random) {
            this.random = random;
        }

        public MonotonicFunction() {
            this(IRandom.newInstance());
        }

        public MonotonicFunction(Random random) {
            this(IRandom.newInstance(random));
        }

        public MonotonicFunction(LongSupplier randomFunction) {
            this(IRandom.newInstance(randomFunction));
        }

        public MonotonicFunction(IntFunction<byte[]> randomFunction) {
            this(IRandom.newInstance(randomFunction));
        }

        void initialize(LongSupplier timeFunction) {
            this.lastUlid = new Ulid(0L, this.random.nextBytes(10));
        }

        @Override
        public Ulid apply(long time) {
            long lastTime = this.lastUlid.getTime();
            if (time > lastTime - 10000L && time <= lastTime) {
                this.lastUlid = this.lastUlid.increment();
            } else if (this.random instanceof ByteRandom) {
                this.lastUlid = new Ulid(time, this.random.nextBytes(10));
            } else {
                long msb = time << 16 | this.random.nextLong() & 0xFFFFL;
                long lsb = this.random.nextLong();
                this.lastUlid = new Ulid(msb, lsb);
            }
            return new Ulid(this.lastUlid);
        }
    }

    static final class UlidFunction
    implements LongFunction<Ulid> {
        private final IRandom random;

        private UlidFunction(IRandom random) {
            this.random = random;
        }

        public UlidFunction() {
            this(IRandom.newInstance());
        }

        public UlidFunction(Random random) {
            this(IRandom.newInstance(random));
        }

        public UlidFunction(LongSupplier randomFunction) {
            this(IRandom.newInstance(randomFunction));
        }

        public UlidFunction(IntFunction<byte[]> randomFunction) {
            this(IRandom.newInstance(randomFunction));
        }

        @Override
        public Ulid apply(long time) {
            if (this.random instanceof ByteRandom) {
                return new Ulid(time, this.random.nextBytes(10));
            }
            long msb = time << 16 | this.random.nextLong() & 0xFFFFL;
            long lsb = this.random.nextLong();
            return new Ulid(msb, lsb);
        }
    }
}

