/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.xml;

import io.polaris.core.collection.Iterables;
import io.polaris.core.io.IO;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.map.Maps;
import io.polaris.core.string.Escapes;
import io.polaris.core.string.Strings;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Xml {
    public static final String NBSP = "&nbsp;";
    public static final String AMP = "&amp;";
    public static final String QUOTE = "&quot;";
    public static final String APOS = "&apos;";
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String INVALID_REGEX = "[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]";
    public static final String COMMENT_REGEX = "(?s)<!--.+?-->";
    public static final int INDENT_DEFAULT = 2;
    private static String defaultDocumentBuilderFactory = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    private static boolean namespaceAware = true;
    private static SAXParserFactory factory;

    public static synchronized void disableDefaultDocumentBuilderFactory() {
        defaultDocumentBuilderFactory = null;
    }

    public static synchronized void setNamespaceAware(boolean isNamespaceAware) {
        namespaceAware = isNamespaceAware;
    }

    public static Document readXML(@Nonnull File file) throws IOException {
        Document document;
        BufferedInputStream in = null;
        try {
            file = file.getCanonicalFile();
            in = IO.getInputStream(file);
            document = Xml.readXML(in);
        }
        catch (Throwable throwable) {
            IO.close(in);
            throw throwable;
        }
        IO.close(in);
        return document;
    }

    public static Document readXML(@Nonnull String pathOrContent) throws IOException {
        if (pathOrContent.startsWith("<")) {
            return Xml.parseXml(pathOrContent);
        }
        return Xml.readXML(IO.getInputStream(pathOrContent));
    }

    public static Document readXML(InputStream inputStream) throws IOException {
        return Xml.readXML(new InputSource(inputStream));
    }

    public static Document readXML(Reader reader) throws IOException {
        return Xml.readXML(new InputSource(reader));
    }

    public static Document readXML(InputSource source) throws IOException {
        DocumentBuilder builder = Xml.createDocumentBuilder();
        try {
            return builder.parse(source);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static void readBySax(File file, ContentHandler contentHandler) throws IOException {
        BufferedInputStream in = null;
        try {
            in = IO.getInputStream(file);
            Xml.readBySax(new InputSource(in), contentHandler);
        }
        finally {
            IO.close(in);
        }
    }

    public static void readBySax(Reader reader, ContentHandler contentHandler) throws IOException {
        try {
            Xml.readBySax(new InputSource(reader), contentHandler);
        }
        finally {
            IO.close(reader);
        }
    }

    public static void readBySax(InputStream source, ContentHandler contentHandler) throws IOException {
        try {
            Xml.readBySax(new InputSource(source), contentHandler);
        }
        finally {
            IO.close(source);
        }
    }

    public static void readBySax(InputSource source, ContentHandler contentHandler) throws IOException {
        if (null == factory) {
            factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(namespaceAware);
        }
        try {
            SAXParser parse = factory.newSAXParser();
            if (contentHandler instanceof DefaultHandler) {
                parse.parse(source, (DefaultHandler)contentHandler);
                return;
            }
            XMLReader reader = parse.getXMLReader();
            reader.setContentHandler(contentHandler);
            reader.parse(source);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static Document parseXml(String xmlStr) throws IOException {
        if (Strings.isBlank(xmlStr)) {
            throw new IllegalArgumentException("XML content string is empty !");
        }
        xmlStr = Xml.cleanInvalid(xmlStr);
        return Xml.readXML(new StringReader(xmlStr));
    }

    public static String toStr(Node doc) throws IOException {
        return Xml.toStr(doc, false);
    }

    public static String toStr(Document doc) throws IOException {
        return Xml.toStr((Node)doc);
    }

    public static String toStr(Node doc, boolean isPretty) throws IOException {
        return Xml.toStr(doc, "UTF-8", isPretty);
    }

    public static String toStr(Document doc, boolean isPretty) throws IOException {
        return Xml.toStr((Node)doc, isPretty);
    }

    public static String toStr(Node doc, String charset, boolean isPretty) throws IOException {
        return Xml.toStr(doc, charset, isPretty, false);
    }

    public static String toStr(Document doc, String charset, boolean isPretty) throws IOException {
        return Xml.toStr((Node)doc, charset, isPretty);
    }

    public static String toStr(Node doc, String charset, boolean isPretty, boolean omitXmlDeclaration) throws IOException {
        StringWriter writer = new StringWriter();
        Xml.write(doc, writer, charset, isPretty ? 2 : 0, omitXmlDeclaration);
        return writer.toString();
    }

    public static String format(Document doc) throws IOException {
        return Xml.toStr(doc, true);
    }

    public static String format(String xmlStr) throws IOException {
        return Xml.format(Xml.parseXml(xmlStr));
    }

    public static void toFile(Document doc, String absolutePath) throws IOException {
        Xml.toFile(doc, absolutePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(Document doc, String path, String charsetName) throws IOException {
        if (Strings.isBlank(charsetName)) {
            charsetName = doc.getXmlEncoding();
        }
        if (Strings.isBlank(charsetName)) {
            charsetName = "UTF-8";
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream fos = new FileOutputStream(path);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, charsetName);
            writer = new BufferedWriter(osw);
            Xml.write((Node)doc, writer, charsetName, 2);
        }
        catch (Throwable throwable) {
            IO.close(writer);
            throw throwable;
        }
        IO.close(writer);
    }

    public static void write(Node node, Writer writer, String charset, int indent) throws IOException {
        Xml.transform(new DOMSource(node), new StreamResult(writer), charset, indent);
    }

    public static void write(Node node, Writer writer, String charset, int indent, boolean omitXmlDeclaration) throws IOException {
        Xml.transform(new DOMSource(node), new StreamResult(writer), charset, indent, omitXmlDeclaration);
    }

    public static void write(Node node, OutputStream out, String charset, int indent) throws IOException {
        Xml.transform(new DOMSource(node), new StreamResult(out), charset, indent);
    }

    public static void write(Node node, OutputStream out, String charset, int indent, boolean omitXmlDeclaration) throws IOException {
        Xml.transform(new DOMSource(node), new StreamResult(out), charset, indent, omitXmlDeclaration);
    }

    public static void transform(Source source, Result result, String charset, int indent) throws IOException {
        Xml.transform(source, result, charset, indent, false);
    }

    public static void transform(Source source, Result result, String charset, int indent, boolean omitXmlDeclaration) throws IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer xformer = factory.newTransformer();
            if (indent > 0) {
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("doctype-public", "yes");
                xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
            }
            if (Strings.isNotBlank(charset)) {
                xformer.setOutputProperty("encoding", charset);
            }
            if (omitXmlDeclaration) {
                xformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static Document createXml() throws IOException {
        return Xml.createDocumentBuilder().newDocument();
    }

    public static DocumentBuilder createDocumentBuilder() throws IOException {
        DocumentBuilder builder;
        try {
            builder = Xml.createDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage(), e);
        }
        return builder;
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = Strings.isNotEmpty(defaultDocumentBuilderFactory) ? DocumentBuilderFactory.newInstance(defaultDocumentBuilderFactory, null) : DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaceAware);
        return Xml.disableXXE(factory);
    }

    public static Document createXml(String rootElementName) throws IOException {
        return Xml.createXml(rootElementName, null);
    }

    public static Document createXml(String rootElementName, String namespace) throws IOException {
        Document doc = Xml.createXml();
        doc.appendChild(null == namespace ? doc.createElement(rootElementName) : doc.createElementNS(namespace, rootElementName));
        return doc;
    }

    public static Element getRootElement(Document doc) {
        return null == doc ? null : doc.getDocumentElement();
    }

    public static Document getOwnerDocument(Node node) {
        return node instanceof Document ? (Document)node : node.getOwnerDocument();
    }

    public static String cleanInvalid(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return xmlContent.replaceAll(INVALID_REGEX, "");
    }

    public static String cleanComment(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return xmlContent.replaceAll(COMMENT_REGEX, "");
    }

    public static List<Element> getElements(Element element, String tagName) {
        NodeList nodeList = Strings.isBlank(tagName) ? element.getChildNodes() : element.getElementsByTagName(tagName);
        return Xml.transElements(element, nodeList);
    }

    public static Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        int length = nodeList.getLength();
        if (length < 1) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            Element childEle = (Element)nodeList.item(i);
            if (childEle != null && childEle.getParentNode() != element) continue;
            return childEle;
        }
        return null;
    }

    public static String elementText(Element element, String tagName) {
        Element child = Xml.getElement(element, tagName);
        return child == null ? null : child.getTextContent();
    }

    public static String elementText(Element element, String tagName, String defaultValue) {
        Element child = Xml.getElement(element, tagName);
        return child == null ? defaultValue : child.getTextContent();
    }

    public static List<Element> transElements(NodeList nodeList) {
        return Xml.transElements(null, nodeList);
    }

    public static List<Element> transElements(Element parentEle, NodeList nodeList) {
        int length = nodeList.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            Element element = (Element)nodeList.item(i);
            if (parentEle != null && element.getParentNode() != parentEle) continue;
            elements.add(element);
        }
        return elements;
    }

    public static void writeObjectAsXml(File dest, Object bean) throws IOException {
        XMLEncoder xmlenc = null;
        try {
            xmlenc = new XMLEncoder(IO.getOutputStream(dest));
            xmlenc.writeObject(bean);
        }
        catch (Throwable throwable) {
            IO.close(xmlenc);
            throw throwable;
        }
        IO.close(xmlenc);
    }

    public static XPath createXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public static Element getElementByXPath(String expression, Object source) throws IOException {
        return (Element)Xml.getNodeByXPath(expression, source);
    }

    public static NodeList getNodeListByXPath(String expression, Object source) throws IOException {
        return (NodeList)Xml.getByXPath(expression, source, XPathConstants.NODESET);
    }

    public static Node getNodeByXPath(String expression, Object source) throws IOException {
        return (Node)Xml.getByXPath(expression, source, XPathConstants.NODE);
    }

    public static Object getByXPath(String expression, Object source, QName returnType) throws IOException {
        UniversalNamespaceCache nsContext = null;
        if (source instanceof Node) {
            nsContext = new UniversalNamespaceCache((Node)source, false);
        }
        return Xml.getByXPath(expression, source, returnType, nsContext);
    }

    public static Object getByXPath(String expression, Object source, QName returnType, NamespaceContext nsContext) throws IOException {
        XPath xPath = Xml.createXPath();
        if (null != nsContext) {
            xPath.setNamespaceContext(nsContext);
        }
        try {
            if (source instanceof InputSource) {
                return xPath.evaluate(expression, (InputSource)source, returnType);
            }
            return xPath.evaluate(expression, source, returnType);
        }
        catch (XPathExpressionException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static String escape(String string) {
        return Escapes.escapeHtml4(string);
    }

    public static String unescape(String string) {
        return Escapes.unescapeHtml4(string);
    }

    public static Map<String, Object> xmlToMap(String xmlStr) throws IOException {
        return Xml.xmlToMap(xmlStr, new HashMap<String, Object>());
    }

    public static <T> T xmlToBean(Node node, Class<T> bean) {
        String simpleName;
        Map<String, Object> map = Xml.xmlToMap(node);
        if (null != map && map.size() == 1 && map.containsKey(simpleName = bean.getSimpleName())) {
            return Beans.copyBean(map.get(simpleName), bean);
        }
        return Beans.copyBean(map, bean);
    }

    public static Map<String, Object> xmlToMap(Node node) {
        return Xml.xmlToMap(node, new HashMap<String, Object>());
    }

    public static Map<String, Object> xmlToMap(String xmlStr, Map<String, Object> result) throws IOException {
        Document doc = Xml.parseXml(xmlStr);
        Element root = Xml.getRootElement(doc);
        root.normalize();
        return Xml.xmlToMap(root, result);
    }

    public static Map<String, Object> xmlToMap(Node node, Map<String, Object> result) {
        if (null == result) {
            result = new HashMap<String, Object>();
        }
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Map<String, Object> map;
            Node childNode = nodeList.item(i);
            if (!Xml.isElement(childNode)) continue;
            Element childEle = (Element)childNode;
            Object value = result.get(childEle.getNodeName());
            Object newValue = childEle.hasChildNodes() ? ((map = Xml.xmlToMap(childEle)) != null && !map.isEmpty() ? map : childEle.getTextContent()) : childEle.getTextContent();
            if (null == newValue) continue;
            if (null != value) {
                if (value instanceof List) {
                    ((List)value).add(newValue);
                    continue;
                }
                result.put(childEle.getNodeName(), Iterables.asList(value, newValue));
                continue;
            }
            result.put(childEle.getNodeName(), newValue);
        }
        return result;
    }

    public static String mapToXmlStr(Map<?, ?> data) throws IOException {
        return Xml.toStr(Xml.mapToXml(data, "xml"));
    }

    public static String mapToXmlStr(Map<?, ?> data, boolean omitXmlDeclaration) throws IOException {
        return Xml.toStr(Xml.mapToXml(data, "xml"), "UTF-8", false, omitXmlDeclaration);
    }

    public static String mapToXmlStr(Map<?, ?> data, String rootName) throws IOException {
        return Xml.toStr(Xml.mapToXml(data, rootName));
    }

    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace) throws IOException {
        return Xml.toStr(Xml.mapToXml(data, rootName, namespace));
    }

    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace, boolean omitXmlDeclaration) throws IOException {
        return Xml.toStr(Xml.mapToXml(data, rootName, namespace), "UTF-8", false, omitXmlDeclaration);
    }

    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace, boolean isPretty, boolean omitXmlDeclaration) throws IOException {
        return Xml.toStr(Xml.mapToXml(data, rootName, namespace), "UTF-8", isPretty, omitXmlDeclaration);
    }

    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace, String charset, boolean isPretty, boolean omitXmlDeclaration) throws IOException {
        return Xml.toStr(Xml.mapToXml(data, rootName, namespace), charset, isPretty, omitXmlDeclaration);
    }

    public static Document mapToXml(Map<?, ?> data, String rootName) throws IOException {
        return Xml.mapToXml(data, rootName, null);
    }

    public static Document mapToXml(Map<?, ?> data, String rootName, String namespace) throws IOException {
        Document doc = Xml.createXml();
        Element root = Xml.appendChild(doc, rootName, namespace);
        Xml.appendMap(doc, root, data);
        return doc;
    }

    public static Document beanToXml(Object bean) throws IOException {
        return Xml.beanToXml(bean, null);
    }

    public static Document beanToXml(Object bean, String namespace) throws IOException {
        return Xml.beanToXml(bean, namespace, false);
    }

    public static Document beanToXml(Object bean, String namespace, boolean ignoreNull) throws IOException {
        if (null == bean) {
            return null;
        }
        return Xml.mapToXml(Beans.newMapFromBean(bean, false, ignoreNull), bean.getClass().getSimpleName(), namespace);
    }

    public static boolean isElement(Node node) {
        return null != node && 1 == node.getNodeType();
    }

    public static Element appendChild(Node node, String tagName) {
        return Xml.appendChild(node, tagName, null);
    }

    public static Element appendChild(Node node, String tagName, String namespace) {
        Document doc = Xml.getOwnerDocument(node);
        Element child = null == namespace ? doc.createElement(tagName) : doc.createElementNS(namespace, tagName);
        node.appendChild(child);
        return child;
    }

    public static Node appendText(Node node, CharSequence text) {
        return Xml.appendText(Xml.getOwnerDocument(node), node, text);
    }

    public static void append(Node node, Object data) {
        Xml.append(Xml.getOwnerDocument(node), node, data);
    }

    private static void append(Document doc, Node node, Object data) {
        if (data instanceof Map) {
            Xml.appendMap(doc, node, (Map)data);
        } else if (data instanceof Iterator) {
            Xml.appendIterator(doc, node, (Iterator)data);
        } else if (data instanceof Iterable) {
            Xml.appendIterator(doc, node, ((Iterable)data).iterator());
        } else {
            Xml.appendText(doc, node, data.toString());
        }
    }

    private static void appendMap(Document doc, Node node, Map data) {
        data.forEach((key, value) -> {
            if (null != key) {
                Element child = Xml.appendChild(node, key.toString());
                if (null != value) {
                    Xml.append(doc, child, value);
                }
            }
        });
    }

    private static void appendIterator(Document doc, Node node, Iterator data) {
        Node parentNode = node.getParentNode();
        boolean isFirst = true;
        while (data.hasNext()) {
            Object eleData = data.next();
            if (isFirst) {
                Xml.append(doc, node, eleData);
                isFirst = false;
                continue;
            }
            Node cloneNode = node.cloneNode(false);
            parentNode.appendChild(cloneNode);
            Xml.append(doc, cloneNode, eleData);
        }
    }

    private static Node appendText(Document doc, Node node, CharSequence text) {
        return node.appendChild(doc.createTextNode(text.toString()));
    }

    private static DocumentBuilderFactory disableXXE(DocumentBuilderFactory dbf) {
        try {
            String feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(feature, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return dbf;
    }

    public static class UniversalNamespaceCache
    implements NamespaceContext {
        private static final String DEFAULT_NS = "DEFAULT";
        private final Map<String, String> prefixUri = new HashMap<String, String>();

        public UniversalNamespaceCache(Node node, boolean toplevelOnly) {
            this.examineNode(node.getFirstChild(), toplevelOnly);
        }

        private void examineNode(Node node, boolean attributesOnly) {
            NodeList childNodes;
            NamedNodeMap attributes = node.getAttributes();
            if (null != attributes) {
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    Node attribute = attributes.item(i);
                    this.storeAttribute(attribute);
                }
            }
            if (!attributesOnly && null != (childNodes = node.getChildNodes())) {
                int childLength = childNodes.getLength();
                for (int i = 0; i < childLength; ++i) {
                    Node item = childNodes.item(i);
                    if (item.getNodeType() != 1) continue;
                    this.examineNode(item, false);
                }
            }
        }

        private void storeAttribute(Node attribute) {
            if (null == attribute) {
                return;
            }
            if ("http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) {
                if ("xmlns".equals(attribute.getNodeName())) {
                    this.prefixUri.put(DEFAULT_NS, attribute.getNodeValue());
                } else {
                    this.prefixUri.put(attribute.getLocalName(), attribute.getNodeValue());
                }
            }
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null || "".equals(prefix)) {
                return this.prefixUri.get(DEFAULT_NS);
            }
            return this.prefixUri.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return Maps.reverse(this.prefixUri).get(namespaceURI);
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

