/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.crypto;

import io.polaris.core.crypto.CryptoKeys;
import io.polaris.crypto.ECKeys;
import io.polaris.crypto.PemKeys;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.KeySpec;
import java.util.Base64;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;

public class BCKeys {
    public static byte[] encodeECPrivateKey(PrivateKey privateKey) {
        return ((BCECPrivateKey)privateKey).getD().toByteArray();
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey) {
        return BCKeys.encodeECPublicKey(publicKey, true);
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey, boolean isCompressed) {
        return ((BCECPublicKey)publicKey).getQ().getEncoded(isCompressed);
    }

    public static PublicKey decodeECPoint(String encode, String curveName) throws GeneralSecurityException {
        return BCKeys.decodeECPoint(Base64.getDecoder().decode(encode), curveName);
    }

    public static PublicKey decodeECPoint(byte[] encodeByte, String curveName) throws GeneralSecurityException {
        X9ECParameters x9ECParameters = ECUtil.getNamedCurveByName((String)curveName);
        ECCurve curve = x9ECParameters.getCurve();
        ECPoint point = EC5Util.convertPoint((org.bouncycastle.math.ec.ECPoint)curve.decodePoint(encodeByte));
        ECNamedCurveSpec ecSpec = new ECNamedCurveSpec(curveName, curve, x9ECParameters.getG(), x9ECParameters.getN());
        return CryptoKeys.generatePublicKey((String)"EC", (KeySpec)new ECPublicKeySpec(point, (ECParameterSpec)ecSpec));
    }

    public static ECDomainParameters toDomainParams(org.bouncycastle.jce.spec.ECParameterSpec parameterSpec) {
        return new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
    }

    public static ECDomainParameters toDomainParams(String curveName) {
        return BCKeys.toDomainParams(ECUtil.getNamedCurveByName((String)curveName));
    }

    public static ECDomainParameters toDomainParams(X9ECParameters x9ECParameters) {
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());
    }

    public static AsymmetricKeyParameter toParams(Key key) throws InvalidKeyException {
        return ECKeys.toParams(key);
    }

    public static ECPrivateKeyParameters toSm2Params(String d) {
        return ECKeys.toSm2PrivateParams(d);
    }

    public static ECPrivateKeyParameters toParams(String dHex, ECDomainParameters domainParameters) {
        return ECKeys.toPrivateParams(dHex, domainParameters);
    }

    public static ECPrivateKeyParameters toSm2Params(byte[] d) {
        return ECKeys.toSm2PrivateParams(d);
    }

    public static ECPrivateKeyParameters toParams(byte[] d, ECDomainParameters domainParameters) {
        return ECKeys.toPrivateParams(d, domainParameters);
    }

    public static ECPrivateKeyParameters toSm2Params(BigInteger d) {
        return ECKeys.toSm2PrivateParams(d);
    }

    public static ECPrivateKeyParameters toParams(BigInteger d, ECDomainParameters domainParameters) {
        return ECKeys.toPrivateParams(d, domainParameters);
    }

    public static ECPublicKeyParameters toParams(BigInteger x, BigInteger y, ECDomainParameters domainParameters) {
        return ECKeys.toPublicParams(x, y, domainParameters);
    }

    public static ECPublicKeyParameters toSm2Params(String xHex, String yHex) {
        return ECKeys.toSm2PublicParams(xHex, yHex);
    }

    public static ECPublicKeyParameters toParams(String xHex, String yHex, ECDomainParameters domainParameters) {
        return ECKeys.toPublicParams(xHex, yHex, domainParameters);
    }

    public static ECPublicKeyParameters toSm2Params(byte[] xBytes, byte[] yBytes) {
        return ECKeys.toSm2PublicParams(xBytes, yBytes);
    }

    public static ECPublicKeyParameters toParams(byte[] xBytes, byte[] yBytes, ECDomainParameters domainParameters) {
        return ECKeys.toPublicParams(xBytes, yBytes, domainParameters);
    }

    public static ECPublicKeyParameters toParams(PublicKey publicKey) throws InvalidKeyException {
        return ECKeys.toPublicParams(publicKey);
    }

    public static ECPrivateKeyParameters toParams(PrivateKey privateKey) throws InvalidKeyException {
        return ECKeys.toPrivateParams(privateKey);
    }

    public static PrivateKey readPemPrivateKey(InputStream pemStream) throws GeneralSecurityException, IOException {
        return PemKeys.readPemPrivateKey(pemStream);
    }

    public static PublicKey readPemPublicKey(InputStream pemStream) throws GeneralSecurityException, IOException {
        return PemKeys.readPemPublicKey(pemStream);
    }

    public static byte[] toPkcs1(PrivateKey privateKey) throws IOException {
        PrivateKeyInfo pkInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
        return pkInfo.parsePrivateKey().toASN1Primitive().getEncoded();
    }

    public static byte[] toPkcs1(PublicKey publicKey) throws IOException {
        SubjectPublicKeyInfo spkInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        return spkInfo.parsePublicKey().getEncoded();
    }
}

