/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.json;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.filter.Filter;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.service.StatefulServiceLoader;
import io.polaris.json.IFastjsonCustomizer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fastjsons {
    private static final Logger log = LoggerFactory.getLogger(Fastjsons.class);
    private static final JSONReader.Feature[] readerFeatures = new JSONReader.Feature[]{JSONReader.Feature.SupportSmartMatch, JSONReader.Feature.AllowUnQuotedFieldNames, JSONReader.Feature.NonZeroNumberCastToBooleanAsTrue};
    private static final JSONWriter.Feature[] writerFeatures = new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.IgnoreErrorGetter, JSONWriter.Feature.WriteLongAsString, JSONWriter.Feature.WriteBigDecimalAsPlain, JSONWriter.Feature.WriteEnumsUsingName};
    private static final JSONWriter.Feature[] writerClassNameFeatures = new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.IgnoreErrorGetter, JSONWriter.Feature.WriteLongAsString, JSONWriter.Feature.WriteBigDecimalAsPlain, JSONWriter.Feature.WriteEnumsUsingName, JSONWriter.Feature.WriteClassName};
    private static final JSONWriter.Feature[] writerPrettyFeatures = new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.IgnoreErrorGetter, JSONWriter.Feature.WriteLongAsString, JSONWriter.Feature.WriteBigDecimalAsPlain, JSONWriter.Feature.WriteEnumsUsingName, JSONWriter.Feature.PrettyFormat};

    public static JSONWriter.Feature[] merge(JSONWriter.Feature[] standard, JSONWriter.Feature[] features) {
        if (features.length > 0) {
            EnumSet<JSONWriter.Feature> set = EnumSet.noneOf(JSONWriter.Feature.class);
            Collections.addAll(set, features);
            Collections.addAll(set, standard);
            return set.toArray(new JSONWriter.Feature[0]);
        }
        return standard;
    }

    public static JSONReader.Feature[] merge(JSONReader.Feature[] standard, JSONReader.Feature[] features) {
        if (features.length > 0) {
            EnumSet<JSONReader.Feature> set = EnumSet.noneOf(JSONReader.Feature.class);
            Collections.addAll(set, features);
            Collections.addAll(set, standard);
            return set.toArray(new JSONReader.Feature[0]);
        }
        return standard;
    }

    public static JSONReader.Feature[] getDefaultReaderFeatures() {
        return readerFeatures;
    }

    public static JSONWriter.Feature[] getDefaultWriterFeatures() {
        return writerFeatures;
    }

    public static byte[] toJsonBytes(Object target) {
        try {
            return JSON.toJSONBytes((Object)target, (JSONWriter.Feature[])writerFeatures);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] toJsonBytesWithClassName(Object target) {
        try {
            return JSON.toJSONBytes((Object)target, (JSONWriter.Feature[])writerClassNameFeatures);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] toJsonBytes(Object target, JSONWriter.Feature ... features) {
        try {
            return JSON.toJSONBytes((Object)target, (JSONWriter.Feature[])Fastjsons.merge(writerFeatures, features));
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonString(Object target) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])writerFeatures);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonStringWithClassName(Object target) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])writerClassNameFeatures);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonString(Object target, JSONWriter.Feature ... features) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])Fastjsons.merge(writerFeatures, features));
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonStringOrNull(Object target) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])writerFeatures);
        }
        catch (Throwable e) {
            log.error("json\u5e8f\u5217\u5316\u5931\u8d25", e);
            return null;
        }
    }

    public static String toJsonStringOrNullWithClassName(Object target) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])writerClassNameFeatures);
        }
        catch (Throwable e) {
            log.error("json\u5e8f\u5217\u5316\u5931\u8d25", e);
            return null;
        }
    }

    public static String toJsonStringOrNull(Object target, JSONWriter.Feature ... features) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])Fastjsons.merge(writerFeatures, features));
        }
        catch (Throwable e) {
            log.error("json\u5e8f\u5217\u5316\u5931\u8d25", e);
            return null;
        }
    }

    public static String toJsonPrettyString(Object target) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])writerPrettyFeatures);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonPrettyString(Object target, JSONWriter.Feature ... features) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])Fastjsons.merge(writerPrettyFeatures, features));
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonPrettyStringOrNull(Object target) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])writerPrettyFeatures);
        }
        catch (Throwable e) {
            log.error("json\u5e8f\u5217\u5316\u5931\u8d25", e);
            return null;
        }
    }

    public static String toJsonPrettyStringOrNull(Object target, JSONWriter.Feature ... features) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])Fastjsons.merge(writerPrettyFeatures, features));
        }
        catch (Throwable e) {
            log.error("json\u5e8f\u5217\u5316\u5931\u8d25", e);
            return null;
        }
    }

    public static String toJsonOrJavaString(Object target) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])writerFeatures);
        }
        catch (Throwable e) {
            return target == null ? null : target.toString();
        }
    }

    public static String toJsonOrJavaString(Object target, JSONWriter.Feature ... features) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])Fastjsons.merge(writerFeatures, features));
        }
        catch (Throwable e) {
            return target == null ? null : target.toString();
        }
    }

    public static Object toJsonObject(Object obj) {
        return JSON.toJSON((Object)obj, (JSONWriter.Feature[])writerFeatures);
    }

    public static Object toJsonObjectWithClassName(Object obj) {
        return JSON.toJSON((Object)obj, (JSONWriter.Feature[])writerClassNameFeatures);
    }

    public static Object toJsonObject(Object obj, JSONWriter.Feature ... features) {
        return JSON.toJSON((Object)obj, (JSONWriter.Feature[])Fastjsons.merge(writerFeatures, features));
    }

    public static Object toJson(String text) {
        return JSON.parse((String)text, (JSONReader.Feature[])readerFeatures);
    }

    public static Object toJson(String text, JSONReader.Feature ... features) {
        return JSON.parse((String)text, (JSONReader.Feature[])Fastjsons.merge(readerFeatures, features));
    }

    public static JSONObject toJsonObject(String text) {
        return JSON.parseObject((String)text, (JSONReader.Feature[])readerFeatures);
    }

    public static JSONObject toJsonObject(String text, JSONReader.Feature ... features) {
        return JSON.parseObject((String)text, (JSONReader.Feature[])Fastjsons.merge(readerFeatures, features));
    }

    public static JSONArray toJsonList(String text) {
        return JSON.parseArray((String)text, (JSONReader.Feature[])readerFeatures);
    }

    public static JSONArray toJsonList(String text, JSONReader.Feature ... features) {
        return JSON.parseArray((String)text, (JSONReader.Feature[])Fastjsons.merge(readerFeatures, features));
    }

    public static <T> T toJavaObject(String json, TypeRef<T> type) {
        return Fastjsons.toJavaObject(json, type.getType());
    }

    public static <T> T toJavaObject(String json, TypeRef<T> type, Filter filter) {
        return Fastjsons.toJavaObject(json, type.getType(), filter);
    }

    public static <T> T toJavaObject(String json, TypeRef<T> type, Class<?> ... autoTypes) {
        return Fastjsons.toJavaObject(json, type.getType(), (Filter)JSONReader.autoTypeFilter((boolean)true, (Class[])autoTypes));
    }

    public static <T> T toJavaObject(String json, TypeRef<T> type, JSONReader.Feature ... features) {
        return Fastjsons.toJavaObject(json, type.getType(), features);
    }

    public static <T> T toJavaObject(String json, TypeRef<T> type, Filter filter, JSONReader.Feature ... features) {
        return Fastjsons.toJavaObject(json, type.getType(), filter, features);
    }

    public static <T> T toJavaObject(String text, Type type) {
        if (type instanceof JavaType) {
            return Fastjsons.toJavaObject(text, ((JavaType)type).getRawType());
        }
        return (T)JSON.parseObject((String)text, (Type)type, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> T toJavaObject(String text, Type type, Filter filter) {
        if (type instanceof JavaType) {
            return Fastjsons.toJavaObject(text, ((JavaType)type).getRawType(), filter);
        }
        return (T)JSON.parseObject((String)text, (Type)type, (Filter)filter, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> T toJavaObject(String text, Type type, Class<?> ... autoTypes) {
        if (type instanceof JavaType) {
            return Fastjsons.toJavaObject(text, ((JavaType)type).getRawType(), autoTypes);
        }
        return (T)JSON.parseObject((String)text, (Type)type, (Filter)JSONReader.autoTypeFilter((boolean)true, (Class[])autoTypes), (JSONReader.Feature[])readerFeatures);
    }

    public static <T> T toJavaObject(String text, Type type, JSONReader.Feature ... features) {
        if (type instanceof JavaType) {
            return Fastjsons.toJavaObject(text, ((JavaType)type).getRawType(), features);
        }
        return (T)JSON.parseObject((String)text, (Type)type, (JSONReader.Feature[])Fastjsons.merge(readerFeatures, features));
    }

    public static <T> T toJavaObject(String text, Type type, Filter filter, JSONReader.Feature ... features) {
        if (type instanceof JavaType) {
            return Fastjsons.toJavaObject(text, ((JavaType)type).getRawType(), filter, features);
        }
        return (T)JSON.parseObject((String)text, (Type)type, (Filter)filter, (JSONReader.Feature[])Fastjsons.merge(readerFeatures, features));
    }

    public static <T> T toJavaObject(String text, Class<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> T toJavaObject(String text, Class<T> clazz, Filter filter) {
        return (T)JSON.parseObject((String)text, clazz, (Filter)filter, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> T toJavaObject(String text, Class<T> clazz, Class<?> ... autoTypes) {
        return (T)JSON.parseObject((String)text, clazz, (Filter)JSONReader.autoTypeFilter((boolean)true, (Class[])autoTypes), (JSONReader.Feature[])readerFeatures);
    }

    public static <T> T toJavaObject(String text, Class<T> clazz, Filter filter, JSONReader.Feature ... features) {
        return (T)JSON.parseObject((String)text, clazz, (Filter)filter, (JSONReader.Feature[])Fastjsons.merge(readerFeatures, features));
    }

    public static <T> T toJavaObject(String text, Class<T> clazz, JSONReader.Feature ... features) {
        return (T)JSON.parseObject((String)text, clazz, (JSONReader.Feature[])Fastjsons.merge(readerFeatures, features));
    }

    public static <T> T toJavaObject(String text, TypeReference<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> T toJavaObject(String text, TypeReference<T> clazz, Filter filter) {
        return (T)JSON.parseObject((String)text, clazz, (Filter)filter, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> T toJavaObject(String text, TypeReference<T> clazz, Class<?> ... autoTypes) {
        return (T)JSON.parseObject((String)text, clazz, (Filter)JSONReader.autoTypeFilter((boolean)true, (Class[])autoTypes), (JSONReader.Feature[])readerFeatures);
    }

    public static <T> T toJavaObject(String text, TypeReference<T> clazz, Filter filter, JSONReader.Feature ... features) {
        return (T)JSON.parseObject((String)text, clazz, (Filter)filter, (JSONReader.Feature[])Fastjsons.merge(readerFeatures, features));
    }

    public static <T> T toJavaObject(String text, TypeReference<T> clazz, JSONReader.Feature ... features) {
        return (T)JSON.parseObject((String)text, clazz, (JSONReader.Feature[])Fastjsons.merge(readerFeatures, features));
    }

    public static <T> List<T> toJavaList(String text, Type type) {
        if (type instanceof JavaType) {
            return Fastjsons.toJavaList(text, ((JavaType)type).getRawType());
        }
        return JSON.parseArray((String)text, (Type)type, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> List<T> toJavaList(String text, Type type, JSONReader.Feature ... features) {
        if (type instanceof JavaType) {
            return Fastjsons.toJavaList(text, ((JavaType)type).getRawType(), features);
        }
        return JSON.parseArray((String)text, (Type)type, (JSONReader.Feature[])Fastjsons.merge(readerFeatures, features));
    }

    public static <T> List<T> toJavaList(String text, Class<T> clazz) {
        return JSON.parseArray((String)text, clazz, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> List<T> toJavaList(String text, Class<T> clazz, JSONReader.Feature ... features) {
        return JSON.parseArray((String)text, clazz, (JSONReader.Feature[])Fastjsons.merge(readerFeatures, features));
    }

    public static <T> Type toType(TypeReference<T> type) {
        return type.getType();
    }

    static {
        for (IFastjsonCustomizer customizer : StatefulServiceLoader.load(IFastjsonCustomizer.class)) {
            try {
                customizer.customize();
            }
            catch (Throwable e) {
                log.error("", e);
            }
        }
    }
}

