/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.function.Supplier;

public abstract class BaseJacksonDeserializer<T>
extends JsonDeserializer<T> {
    protected final JavaType javaType;
    protected final Class<?> rawClass;

    public BaseJacksonDeserializer(Annotated annotated) {
        if (annotated == null) {
            this.javaType = null;
            this.rawClass = null;
        } else {
            int count;
            JavaType javaType = annotated.getType();
            Class rawClass = annotated.getRawType();
            if (rawClass == Void.TYPE && annotated instanceof AnnotatedWithParams && (count = ((AnnotatedWithParams)annotated).getParameterCount()) == 1) {
                javaType = ((AnnotatedWithParams)annotated).getParameterType(0);
                rawClass = ((AnnotatedWithParams)annotated).getRawParameterType(0);
            }
            this.javaType = javaType;
            this.rawClass = rawClass;
        }
    }

    public Class<?> handledType() {
        return this.rawClass;
    }

    protected T createBean(Supplier<T> supplier) {
        try {
            if (this.rawClass != null) {
                return (T)this.rawClass.newInstance();
            }
            return supplier.get();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected T createBean() {
        try {
            if (this.rawClass != null) {
                return (T)this.rawClass.newInstance();
            }
            return null;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected TreeNode readFirstOfArray(JsonParser p) throws IOException {
        TreeNode tree = p.getCodec().readTree(p);
        while (tree != null && tree.isArray()) {
            ArrayNode arr = (ArrayNode)tree;
            if (!arr.isEmpty()) {
                tree = arr.get(0);
                continue;
            }
            tree = null;
        }
        return tree;
    }

    protected ArrayNode readAsArray(JsonParser p) throws IOException {
        TreeNode tree = p.getCodec().readTree(p);
        if (tree == null) {
            return null;
        }
        if (tree.isArray()) {
            return (ArrayNode)tree;
        }
        ArrayNode arrayNode = (ArrayNode)p.getCodec().createArrayNode();
        if (tree instanceof JsonNode) {
            arrayNode.add((JsonNode)tree);
        }
        return arrayNode;
    }
}

