/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import java.util.function.Supplier;

public abstract class BaseJacksonSerializer<T>
extends JsonSerializer<T> {
    protected final JavaType javaType;
    protected final Class<T> rawClass;

    public BaseJacksonSerializer(Annotated annotated) {
        if (annotated == null) {
            this.javaType = null;
            this.rawClass = null;
        } else {
            int count;
            JavaType javaType = annotated.getType();
            Class rawClass = annotated.getRawType();
            if (rawClass == Void.TYPE && annotated instanceof AnnotatedWithParams && (count = ((AnnotatedWithParams)annotated).getParameterCount()) == 1) {
                javaType = ((AnnotatedWithParams)annotated).getParameterType(0);
                rawClass = ((AnnotatedWithParams)annotated).getRawParameterType(0);
            }
            this.javaType = javaType;
            this.rawClass = rawClass;
        }
    }

    public Class<T> handledType() {
        return this.rawClass;
    }

    protected T createBean(Supplier<T> supplier) {
        try {
            if (this.rawClass != null) {
                return this.rawClass.newInstance();
            }
            return supplier.get();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected T createBean() {
        try {
            if (this.rawClass != null) {
                return this.rawClass.newInstance();
            }
            return null;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

