/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.interceptor;

import io.polaris.core.reflect.Reflects;
import io.polaris.mybatis.interceptor.DataAuthSqlCtx;
import io.polaris.mybatis.util.SqlParsers;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.statement.BaseStatementHandler;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataAuthInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DataAuthInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        if (!DataAuthSqlCtx.hasDataAuthority()) {
            return invocation.proceed();
        }
        try {
            MappedStatement mappedStatement;
            StatementHandler target = null;
            if (invocation.getTarget() instanceof RoutingStatementHandler) {
                RoutingStatementHandler statementHandler = (RoutingStatementHandler)invocation.getTarget();
                target = this.getDelegate(statementHandler);
            } else if (invocation.getTarget() instanceof BaseStatementHandler) {
                target = (BaseStatementHandler)invocation.getTarget();
            } else if (invocation.getTarget() instanceof StatementHandler) {
                target = (StatementHandler)invocation.getTarget();
            }
            if (target != null && (mappedStatement = this.getMappedStatement(target)) != null && mappedStatement.getSqlCommandType() == SqlCommandType.SELECT) {
                BoundSql boundSql = target.getBoundSql();
                String sql = boundSql.getSql();
                String resolvedSql = SqlParsers.visitSelect(sql, DataAuthSqlCtx.getConditionAppender(), DataAuthSqlCtx.getColumnFilter());
                Field field = Reflects.getField(BoundSql.class, (String)"sql");
                Reflects.setAccessible((AccessibleObject)field);
                field.set(boundSql, resolvedSql);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    private StatementHandler getDelegate(RoutingStatementHandler statementHandler) throws IllegalAccessException {
        Field field = Reflects.getField(RoutingStatementHandler.class, (String)"delegate");
        Reflects.setAccessible((AccessibleObject)field);
        return (StatementHandler)field.get(statementHandler);
    }

    private MappedStatement getMappedStatement(StatementHandler delegate) throws IllegalAccessException {
        Field field = Reflects.getField(BaseStatementHandler.class, (String)"mappedStatement");
        Reflects.setAccessible((AccessibleObject)field);
        return (MappedStatement)field.get(delegate);
    }
}

