/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.interceptor;

import io.polaris.core.function.Executable;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.sf.jsqlparser.schema.Table;

public class DataAuthSqlCtx {
    private static final ThreadLocal<Function<Collection<Table>, String>> ConditionAppender = new ThreadLocal();
    private static final ThreadLocal<BiFunction<Table, String, Boolean>> ColumnFilter = new ThreadLocal();

    public static boolean hasDataAuthority() {
        return ConditionAppender.get() != null || ColumnFilter.get() != null;
    }

    public static void bind(Function<Collection<Table>, String> conditionAppender, BiFunction<Table, String, Boolean> columnFilter) {
        ConditionAppender.set(conditionAppender);
        ColumnFilter.set(columnFilter);
    }

    public static void clear() {
        ConditionAppender.remove();
        ColumnFilter.remove();
    }

    public static BiFunction<Table, String, Boolean> getColumnFilter() {
        return ColumnFilter.get();
    }

    public static Function<Collection<Table>, String> getConditionAppender() {
        return ConditionAppender.get();
    }

    public static void execute(Executable executable, Function<Collection<Table>, String> conditionAppender, BiFunction<Table, String, Boolean> columnFilter) throws Throwable {
        try {
            DataAuthSqlCtx.bind(conditionAppender, columnFilter);
            executable.execute();
        }
        finally {
            DataAuthSqlCtx.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V execute(Callable<V> executable, Function<Collection<Table>, String> conditionAppender, BiFunction<Table, String, Boolean> columnFilter) throws Throwable {
        try {
            DataAuthSqlCtx.bind(conditionAppender, columnFilter);
            V v = executable.call();
            return v;
        }
        finally {
            DataAuthSqlCtx.clear();
        }
    }
}

