/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.interceptor;

import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.jdbc.TableMetaKit;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.Types;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import io.polaris.mybatis.annotation.DynamicUseGeneratedKeys;
import io.polaris.mybatis.annotation.MapperEntity;
import io.polaris.mybatis.interceptor.StatementBuilder;
import io.polaris.mybatis.mapper.EntityMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class DynamicUseGeneratedKeysInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DynamicUseGeneratedKeysInterceptor.class);
    private final Map<String, Meta> cache = new ConcurrentHashMap<String, Meta>();

    protected static Class<?> getEntityClass(Method mapperMethod, Class<?> mapperType) {
        MapperEntity declared = mapperMethod.getAnnotation(MapperEntity.class);
        if (declared != null) {
            return declared.entity();
        }
        Class entityClass = null;
        if (EntityMapper.class.isAssignableFrom(mapperType)) {
            Type actualType = JavaType.of(mapperType).getActualType(EntityMapper.class, 0);
            entityClass = Types.getClass((Type)actualType);
        }
        if (entityClass == null || entityClass == Object.class) {
            throw new IllegalStateException("\u672a\u77e5\u5b9e\u4f53\u7c7b\u578b\uff01");
        }
        return entityClass;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        String statementId;
        Meta meta;
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT && (meta = this.cache.computeIfAbsent(statementId = mappedStatement.getId(), k -> {
            try {
                List methods;
                int idx = statementId.lastIndexOf(".");
                String mapperClassName = statementId.substring(0, idx);
                String mapperMethodName = statementId.substring(idx + 1);
                Class<?> mapperClass = Class.forName(mapperClassName);
                if (mapperClass.isInterface() && (methods = Reflects.getPublicMethods(mapperClass, m -> !m.isDefault() && !Modifier.isStatic(m.getModifiers()) && mapperMethodName.equals(m.getName()) && m.isAnnotationPresent(DynamicUseGeneratedKeys.class))).size() == 1) {
                    Method method = (Method)methods.get(0);
                    DynamicUseGeneratedKeys dynamicUseGeneratedKeys = method.getAnnotation(DynamicUseGeneratedKeys.class);
                    Class<?> entityClass = dynamicUseGeneratedKeys.entity();
                    if (entityClass == Void.TYPE) {
                        entityClass = DynamicUseGeneratedKeysInterceptor.getEntityClass(method, mapperClass);
                    }
                    String entityKey = dynamicUseGeneratedKeys.value();
                    TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
                    List<ColumnMeta> columns = tableMeta.getColumns().values().stream().filter(ColumnMeta::isAutoIncrement).collect(Collectors.toList());
                    if (!columns.isEmpty()) {
                        return new Meta(columns, entityKey);
                    }
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            return new Meta(null, null);
        })).autoColumns != null) {
            MappedStatement newer;
            if (meta.lastStatement == mappedStatement) {
                newer = meta.newerStatement;
            } else {
                newer = new StatementBuilder(mappedStatement).useGeneratedKeys(meta.autoColumns, Strings.trimToNull((String)meta.entityKey));
                meta.lastStatement = mappedStatement;
                meta.newerStatement = newer;
            }
            invocation.getArgs()[0] = newer;
        }
        return invocation.proceed();
    }

    private MappedStatement cloneMappedStatement(MappedStatement ms, boolean useGeneratedKeys) {
        return null;
    }

    public Object plugin(Object target) {
        return super.plugin(target);
    }

    public void setProperties(Properties properties) {
    }

    private static class Meta {
        private final List<ColumnMeta> autoColumns;
        private final String entityKey;
        private MappedStatement lastStatement;
        private MappedStatement newerStatement;

        public Meta(List<ColumnMeta> autoColumns, String entityKey) {
            this.autoColumns = autoColumns;
            this.entityKey = entityKey;
        }
    }
}

