/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.provider;

import io.polaris.core.annotation.Published;
import io.polaris.core.jdbc.sql.BindingValues;
import io.polaris.core.jdbc.sql.EntityStatements;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.mybatis.provider.BaseProviderMethodResolver;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyEntityProvider
extends BaseProviderMethodResolver {
    private static final Logger log = LoggerFactory.getLogger(AnyEntityProvider.class);

    @Published
    public static String provideSql(Object parameterObject, ProviderContext context) {
        return AnyEntityProvider.provideSql(parameterObject, context, (map, ctx) -> {
            String sql = AnyEntityProvider.doProvideSql(map, context.getMapperMethod());
            if (log.isDebugEnabled()) {
                log.debug("<sql>\n{}\n<bindings>\n{}", (Object)sql, map);
            }
            return sql;
        });
    }

    private static String doProvideSql(Map<String, Object> bindings, Method method) {
        boolean isSelect = method.isAnnotationPresent(SelectProvider.class);
        Function function = isSelect ? EntityStatements.buildSqlSelectFunction((Method)method) : EntityStatements.buildSqlUpdateFunction((Method)method);
        SqlNode sqlNode = (SqlNode)function.apply(bindings);
        return BindingValues.asSqlWithBindings(bindings, (SqlNode)sqlNode);
    }
}

