/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.provider;

import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.Types;
import io.polaris.core.lang.bean.BeanMap;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.tuple.Tuple2;
import io.polaris.mybatis.annotation.MapperEntity;
import io.polaris.mybatis.mapper.EntityMapper;
import io.polaris.mybatis.provider.ProviderSqlSourceDriver;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.ibatis.annotations.Lang;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.builder.annotation.ProviderMethodResolver;

public abstract class BaseProviderMethodResolver
implements ProviderMethodResolver {
    static final ThreadLocal<Tuple2<Object, Map<String, Object>>> ADDITIONAL_PARAMETERS = new ThreadLocal();
    static final ThreadLocal<Boolean> QUERY_EXISTS_BY_COUNT = new ThreadLocal();

    public static boolean isQueryExistsByCount() {
        Boolean bool = QUERY_EXISTS_BY_COUNT.get();
        return bool == null || bool != false;
    }

    public static void setQueryExistsByCount(boolean withoutCount) {
        QUERY_EXISTS_BY_COUNT.set(withoutCount);
    }

    public static void clearQueryExistsByCount() {
        QUERY_EXISTS_BY_COUNT.remove();
    }

    static void bindAdditionalParameters(Object parameterObject, Map<String, Object> additionalParameters) {
        ADDITIONAL_PARAMETERS.set((Tuple2<Object, Map<String, Object>>)Tuple2.of((Object)parameterObject, additionalParameters));
    }

    static void clearAdditionalParameters() {
        ADDITIONAL_PARAMETERS.remove();
    }

    public Method resolveMethod(ProviderContext context) {
        String methodName = context.getMapperMethod().getName();
        try {
            return this.getClass().getMethod(methodName, Map.class, ProviderContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return this.getClass().getMethod("provideSql", Map.class, ProviderContext.class);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                try {
                    return this.getClass().getMethod(methodName, Object.class, ProviderContext.class);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    try {
                        return this.getClass().getMethod("provideSql", Object.class, ProviderContext.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException4) {
                        return super.resolveMethod(context);
                    }
                }
            }
        }
    }

    protected static Class<?> getEntityClass(ProviderContext context) {
        Type actualType;
        Method mapperMethod = context.getMapperMethod();
        MapperEntity declared = mapperMethod.getAnnotation(MapperEntity.class);
        Class entityClass = null;
        if (declared != null && (entityClass = declared.entity()) != null && entityClass != Object.class) {
            return entityClass;
        }
        Class mapperType = context.getMapperType();
        declared = mapperType.getAnnotation(MapperEntity.class);
        if (declared != null && (entityClass = declared.entity()) != null && entityClass != Object.class) {
            return entityClass;
        }
        Class<?> declaringClass = mapperMethod.getDeclaringClass();
        if (declaringClass != mapperType && (declared = declaringClass.getAnnotation(MapperEntity.class)) != null && (entityClass = declared.entity()) != null && entityClass != Object.class) {
            return entityClass;
        }
        if (EntityMapper.class.isAssignableFrom(mapperType) && (entityClass = Types.getClass((Type)(actualType = JavaType.of((Class)mapperType).getActualType(EntityMapper.class, 0)))) != null && entityClass != Object.class) {
            return entityClass;
        }
        throw new IllegalStateException("\u672a\u77e5\u5b9e\u4f53\u7c7b\u578b\uff01");
    }

    protected static String provideSql(Object parameterObject, ProviderContext context, BiFunction<Map<String, Object>, ProviderContext, String> function) {
        try {
            Map<String, Object> map = BaseProviderMethodResolver.toParameterBindings(context.getMapperMethod(), parameterObject);
            String sql = function.apply(map, context);
            return sql;
        }
        catch (RuntimeException e) {
            BaseProviderMethodResolver.clearAdditionalParameters();
            throw e;
        }
    }

    protected static Map<String, Object> toParameterBindings(Method mapperMethod, Object parameterObject) {
        if (parameterObject instanceof Map) {
            return (Map)parameterObject;
        }
        if (!BaseProviderMethodResolver.hasProviderSqlSourceDriver(mapperMethod)) {
            throw new IllegalArgumentException("\u8bf7\u4f7f\u7528Map\u7c7b\u578b\u53c2\u6570\u6216\u660e\u786e\u58f0\u660e\u53c2\u6570\u952e\u540d");
        }
        return BaseProviderMethodResolver.toParameterBindings(parameterObject);
    }

    private static boolean hasProviderSqlSourceDriver(Method mapperMethod) {
        Lang lang = mapperMethod.getAnnotation(Lang.class);
        if (lang == null) {
            return false;
        }
        return ProviderSqlSourceDriver.class == lang.value();
    }

    private static Map<String, Object> toParameterBindings(Object parameterObject) {
        if (parameterObject instanceof Map) {
            return (Map)parameterObject;
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        if (parameterObject != null) {
            BeanMap beanMap = Beans.newBeanMap((Object)parameterObject);
            additionalParameters.putAll((Map<String, Object>)beanMap);
        }
        BaseProviderMethodResolver.bindAdditionalParameters(parameterObject, additionalParameters);
        return additionalParameters;
    }
}

