/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.type;

import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public abstract class StringTokenizerTypeHandler<T>
extends BaseTypeHandler<T[]> {
    private Class<T> clazz;

    public StringTokenizerTypeHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, T[] ts, JdbcType jdbcType) throws SQLException {
        StringBuilder result = new StringBuilder();
        if (ts.length > 0) {
            result.append(ts[0]);
            for (int idx = 1; idx < ts.length; ++idx) {
                result.append(",").append(ts[idx]);
            }
        }
        ps.setString(i, result.toString());
    }

    public T[] getNullableResult(ResultSet resultSet, String columnName) throws SQLException {
        return this.toArray(resultSet.getString(columnName));
    }

    public T[] getNullableResult(ResultSet resultSet, int columnIndex) throws SQLException {
        return this.toArray(resultSet.getString(columnIndex));
    }

    public T[] getNullableResult(CallableStatement callableStatement, int columnIndex) throws SQLException {
        return this.toArray(callableStatement.getString(columnIndex));
    }

    T[] toArray(String columnValue) {
        if (columnValue == null) {
            return this.createArray(0);
        }
        String[] values = columnValue.split(",");
        T[] array = this.createArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            array[i] = this.parseString(values[i]);
        }
        return array;
    }

    T[] createArray(int size) {
        return (Object[])Array.newInstance(this.clazz, size);
    }

    abstract T parseString(String var1);
}

