/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.util;

import io.polaris.core.function.Visitable;
import io.polaris.core.io.IO;
import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.jdbc.TableMetaKit;
import io.polaris.core.lang.Objs;
import io.polaris.core.lang.bean.Beans;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.type.Alias;

@Alias(value="mkit")
public class MybatisToolkit {
    public static int CURSOR_MAX_SIZE = 65533;

    public static boolean isNotEmpty(Object val) {
        return Objs.isNotEmpty((Object)val);
    }

    public static boolean isLikeString(Object val) {
        if (val instanceof String) {
            return ((String)val).startsWith("%") || ((String)val).endsWith("%");
        }
        return false;
    }

    public static boolean hasPathProperty(Object _parameter, String propertyName) {
        try {
            Object val = Beans.getPathProperty((Object)_parameter, (String)propertyName);
            return MybatisToolkit.isNotEmpty(val);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasProperty(Object _parameter, String propertyName) {
        try {
            Object val = Beans.getProperty((Object)_parameter, (String)propertyName);
            return MybatisToolkit.isNotEmpty(val);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static TableMeta getTableMeta(String entityClassName) {
        return TableMetaKit.instance().get(entityClassName);
    }

    public static <E> Visitable<E> buildVisitable(Supplier<Cursor<E>> supplier) {
        return MybatisToolkit.buildVisitable(supplier.get());
    }

    public static <E, V> Visitable<V> buildVisitable(Supplier<Cursor<E>> supplier, Function<E, V> converter) {
        return MybatisToolkit.buildVisitable(supplier.get(), converter);
    }

    public static <E> Visitable<E> buildVisitable(Cursor<E> cursor) {
        return c -> {
            try {
                Iterator iter = cursor.iterator();
                for (int i = 0; iter.hasNext() && i < CURSOR_MAX_SIZE; ++i) {
                    Object o = iter.next();
                    c.accept(o);
                }
            }
            finally {
                IO.close((AutoCloseable)cursor);
            }
        };
    }

    public static <E, V> Visitable<V> buildVisitable(Cursor<E> cursor, Function<E, V> converter) {
        return c -> {
            try {
                Iterator iter = cursor.iterator();
                for (int i = 0; iter.hasNext() && i < CURSOR_MAX_SIZE; ++i) {
                    Object o = iter.next();
                    Object v = converter.apply(o);
                    c.accept(v);
                }
            }
            finally {
                IO.close((AutoCloseable)cursor);
            }
        };
    }
}

