/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.cluster.nacos;

import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.CollectionUtils;
import io.polaris.cluster.nacos.NacosConfig;
import io.polaris.core.cluster.ClusterService;
import io.polaris.core.cluster.InstanceNode;
import io.polaris.core.cluster.InstanceQueryException;
import io.polaris.core.cluster.InstanceRegisterException;
import io.polaris.core.lang.bean.BeanMap;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.service.ServiceName;
import io.polaris.core.string.Strings;
import io.polaris.json.Jacksons;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value="nacos")
public class NacosClusterService
implements ClusterService {
    private static final Logger log = LoggerFactory.getLogger(NacosClusterService.class);
    private NacosConfig config;
    private NamingService namingService;
    private volatile InstanceNode selfInstance;
    private volatile boolean started = false;

    public NacosClusterService() {
        this(null);
    }

    public NacosClusterService(NacosConfig config) {
        this.config = config;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    private void doStart() {
        if (!this.started) {
            this.doStop();
            if (this.config == null) {
                throw new IllegalStateException("config is null");
            }
            try {
                Properties properties = new Properties();
                properties.put("serverAddr", this.config.getHostPort());
                properties.put("namespace", this.config.getNamespace());
                if (Strings.isNotEmpty((CharSequence)this.config.getUsername())) {
                    properties.put("username", this.config.getUsername());
                    properties.put("password", this.config.getPassword());
                } else if (Strings.isNotEmpty((CharSequence)this.config.getAccessKey())) {
                    properties.put("accessKey", this.config.getAccessKey());
                    properties.put("secretKey", this.config.getSecretKey());
                }
                this.namingService = NamingFactory.createNamingService((Properties)properties);
                this.started = true;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    private void doStop() {
        try {
            this.namingService.shutDown();
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        this.started = false;
        this.namingService = null;
    }

    private void prepare() {
        if (!this.started) {
            this.doStart();
        }
    }

    public void start() {
        this.doStart();
    }

    public void stop() {
        this.doStop();
    }

    public void register(InstanceNode instanceNode) throws InstanceRegisterException {
        this.prepare();
        instanceNode.check();
        try {
            String host = instanceNode.getHost();
            int port = instanceNode.getPort();
            Instance instance = new Instance();
            instance.setIp(host);
            instance.setPort(port);
            instance.setClusterName(this.config.getClusterName());
            BeanMap beanMap = Beans.newBeanMap((Object)instanceNode);
            HashMap metadata = new HashMap();
            beanMap.forEach((k, v) -> {
                if (v != null) {
                    metadata.put(k, Jacksons.toJsonString((Object)v));
                }
            });
            instance.setMetadata(metadata);
            if (Strings.isNotBlank((CharSequence)this.config.getGroupName())) {
                this.namingService.registerInstance(this.config.getServiceName(), this.config.getGroupName(), instance);
            } else {
                this.namingService.registerInstance(this.config.getServiceName(), instance);
            }
            this.selfInstance = instanceNode;
        }
        catch (Throwable e) {
            throw new InstanceRegisterException(e.getMessage(), e);
        }
    }

    public List<InstanceNode> query() {
        this.prepare();
        ArrayList<InstanceNode> list = new ArrayList<InstanceNode>();
        try {
            boolean hasSelf = false;
            List instances = null;
            instances = Strings.isNotBlank((CharSequence)this.config.getGroupName()) ? this.namingService.selectInstances(this.config.getServiceName(), this.config.getGroupName(), true) : this.namingService.selectInstances(this.config.getServiceName(), true);
            if (CollectionUtils.isNotEmpty((Collection)instances)) {
                for (Instance instance : instances) {
                    InstanceNode instanceNode = new InstanceNode();
                    Map metadata = instance.getMetadata();
                    if (metadata != null) {
                        BeanMap beanMap = Beans.newBeanMap((Object)instanceNode);
                        metadata.forEach((k, v) -> {
                            try {
                                if (beanMap.containsKey(k)) {
                                    beanMap.put(k, Jacksons.toJavaObject((String)v, (Type)beanMap.getType(k)));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                    }
                    instanceNode.setHost(instance.getIp());
                    instanceNode.setPort(instance.getPort());
                    if (instanceNode.equals((Object)this.selfInstance)) {
                        instanceNode.setSelf(true);
                        hasSelf = true;
                    } else {
                        instanceNode.setSelf(false);
                    }
                    list.add(instanceNode);
                }
                if (this.selfInstance != null && !hasSelf) {
                    list.add(this.selfInstance);
                }
            }
        }
        catch (Throwable e) {
            throw new InstanceQueryException(e.getMessage());
        }
        return list;
    }

    public void setConfig(NacosConfig config) {
        this.config = config;
    }

    public NacosConfig getConfig() {
        return this.config;
    }
}

