/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.validation;

import io.polaris.core.annotation.Experimental;
import io.polaris.core.err.ValidationException;
import io.polaris.core.lang.Types;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import io.polaris.validation.ValidationResult;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.Payload;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ValidateUnwrappedValue;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorDescriptor;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.messageinterpolation.ExpressionLanguageFeatureLevel;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;

public class Validations {
    private static final Pattern patternPlaceholder = Pattern.compile("\\{([^}]+)\\}");
    private static ResourceBundleLocator defaultResourceBundleLocator;
    private static ValidatorFactory defaultFactory;
    private static Validator defaultValidator;

    public static ResourceBundleLocator getDefaultResourceBundleLocator() {
        if (defaultResourceBundleLocator != null) {
            return defaultResourceBundleLocator;
        }
        defaultResourceBundleLocator = new PlatformResourceBundleLocator("ValidationMessages", Thread.currentThread().getContextClassLoader(), true);
        return defaultResourceBundleLocator;
    }

    public static ValidatorFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        }
        ResourceBundleMessageInterpolator messageInterpolator = new ResourceBundleMessageInterpolator(Validations.getDefaultResourceBundleLocator());
        defaultFactory = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)messageInterpolator).buildValidatorFactory();
        return defaultFactory;
    }

    public static Validator getDefaultValidator() {
        if (defaultValidator != null) {
            return defaultValidator;
        }
        defaultValidator = Validations.getDefaultFactory().getValidator();
        return defaultValidator;
    }

    public static <A extends Annotation, T> List<Class<? extends ConstraintValidator<A, ?>>> getConstraintValidator(Class<A> annotationType, Class<T> type) {
        type = Types.getWrapperClass(type);
        List list = ConstraintHelper.forAllBuiltinConstraints().getAllValidatorDescriptors(annotationType);
        ArrayList targets = new ArrayList();
        for (ConstraintValidatorDescriptor descriptor : list) {
            Class c = descriptor.getValidatorClass();
            Class target = Reflects.findActualTypeArgument(ConstraintValidator.class, (Class)c, (int)1);
            if (!target.isAssignableFrom(type)) continue;
            targets.add(c);
        }
        return targets;
    }

    public static <A extends Annotation, T> Class<? extends ConstraintValidator<A, ?>> getFirstConstraintValidator(Class<A> annotationType, Class<T> type) {
        type = Types.getWrapperClass(type);
        List list = ConstraintHelper.forAllBuiltinConstraints().getAllValidatorDescriptors(annotationType);
        Class matched = null;
        ArrayList<Class> targets = new ArrayList<Class>();
        for (ConstraintValidatorDescriptor descriptor : list) {
            Class c = descriptor.getValidatorClass();
            Class target = Reflects.findActualTypeArgument(ConstraintValidator.class, (Class)c, (int)1);
            if (target.equals(type)) {
                matched = c;
                break;
            }
            if (!target.isAssignableFrom(type)) continue;
            targets.add(c);
        }
        if (matched != null) {
            return matched;
        }
        if (!targets.isEmpty()) {
            return (Class)targets.get(0);
        }
        return null;
    }

    public static String formatValidationMessage(String messageTemplate, ConstraintValidatorContext validatorContext, Object value, Consumer<Map<String, Object>> parameters) {
        if (validatorContext instanceof ConstraintValidatorContextImpl) {
            HashMap<String, Object> messageParameters = new HashMap<String, Object>();
            messageParameters.put("value", value);
            parameters.accept(messageParameters);
            ConstraintValidatorContextImpl context = (ConstraintValidatorContextImpl)validatorContext;
            ConstraintDescriptor constraintDescriptor = context.getConstraintDescriptor();
            MessageInterpolatorContext msgContext = new MessageInterpolatorContext(constraintDescriptor, value, value.getClass(), (Path)PathImpl.createRootPath(), messageParameters, Collections.emptyMap(), ExpressionLanguageFeatureLevel.NONE, true);
            return Validations.getDefaultFactory().getMessageInterpolator().interpolate(messageTemplate, (MessageInterpolator.Context)msgContext);
        }
        return null;
    }

    @Experimental
    public static String formatValidationMessage(final String messageTemplate, final Map<String, Object> messageParameters) {
        try {
            Object value = messageParameters.get("value");
            return Validations.getDefaultFactory().getMessageInterpolator().interpolate(messageTemplate, (MessageInterpolator.Context)new MessageInterpolatorContext((ConstraintDescriptor)new ConstraintDescriptor<Annotation>(){

                public Annotation getAnnotation() {
                    return null;
                }

                public String getMessageTemplate() {
                    return messageTemplate;
                }

                public Set<Class<?>> getGroups() {
                    return Collections.emptySet();
                }

                public Set<Class<? extends Payload>> getPayload() {
                    return Collections.emptySet();
                }

                public ConstraintTarget getValidationAppliesTo() {
                    return null;
                }

                public List<Class<? extends ConstraintValidator<Annotation, ?>>> getConstraintValidatorClasses() {
                    return Collections.emptyList();
                }

                public Map<String, Object> getAttributes() {
                    return messageParameters;
                }

                public Set<ConstraintDescriptor<?>> getComposingConstraints() {
                    return Collections.emptySet();
                }

                public boolean isReportAsSingleViolation() {
                    return false;
                }

                public ValidateUnwrappedValue getValueUnwrapping() {
                    return null;
                }

                public <U> U unwrap(Class<U> type) {
                    return null;
                }
            }, value, value == null ? Object.class : value.getClass(), (Path)PathImpl.createRootPath(), messageParameters, Collections.emptyMap(), ExpressionLanguageFeatureLevel.NONE, true));
        }
        catch (Exception ignore) {
            if (Strings.isBlank((CharSequence)messageTemplate)) {
                return "";
            }
            ResourceBundle bundle = Validations.getDefaultResourceBundleLocator().getResourceBundle(Locale.getDefault());
            return Strings.resolvePlaceholders((String)messageTemplate, (Pattern)patternPlaceholder, key -> {
                String v = "";
                if (bundle.containsKey((String)key)) {
                    v = bundle.getString((String)key);
                } else if (messageParameters.containsKey(key)) {
                    v = Objects.toString(messageParameters.get(key), "");
                }
                return v;
            });
        }
    }

    public static <T> void validate(T bean, Class ... groups) throws ValidationException {
        Set violationSet = Validations.getDefaultValidator().validate(bean, groups);
        if (violationSet == null || violationSet.isEmpty()) {
            return;
        }
        throw new ValidationException(Validations.buildMessage(violationSet));
    }

    public static <T> void validate(T bean, Function<Set<ConstraintViolation<T>>, String> messageBuilder, Class ... groups) throws ValidationException {
        Set violationSet = Validations.getDefaultValidator().validate(bean, groups);
        if (violationSet == null || violationSet.isEmpty()) {
            return;
        }
        throw new ValidationException(messageBuilder.apply(violationSet));
    }

    public static <T> ValidationResult validateQuietly(T bean, Class ... groups) {
        Set violationSet = Validations.getDefaultValidator().validate(bean, groups);
        if (violationSet == null || violationSet.isEmpty()) {
            return ValidationResult.success();
        }
        String msg = Validations.buildMessage(violationSet);
        return ValidationResult.error(msg);
    }

    public static <T> ValidationResult validateQuietly(T bean, Function<Set<ConstraintViolation<T>>, String> messageBuilder, Class ... groups) {
        Set violationSet = Validations.getDefaultValidator().validate(bean, groups);
        if (violationSet == null || violationSet.isEmpty()) {
            return ValidationResult.success();
        }
        return ValidationResult.error(messageBuilder.apply(violationSet));
    }

    private static <T> String buildMessage(Set<ConstraintViolation<T>> violationSet) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u53c2\u6570\u89c4\u5219\u9a8c\u8bc1\u5931\u8d25\uff01");
        for (ConstraintViolation<T> violation : violationSet) {
            String errorMsg = violation.getMessage();
            String path = violation.getPropertyPath().toString();
            sb.append("\n");
            if (Strings.isNotBlank((CharSequence)path)) {
                sb.append("\u5c5e\u6027[").append(path).append("]\uff1a");
            }
            sb.append(errorMsg).append("\uff01");
        }
        String msg = sb.toString();
        return msg;
    }

    public static void isTrue(boolean condition, String message) throws ValidationException {
        if (!condition) {
            throw new ValidationException(message);
        }
    }

    public static void isFalse(boolean condition, String message) throws ValidationException {
        if (condition) {
            throw new ValidationException(message);
        }
    }

    public static void isNull(Object actual, String message) throws ValidationException {
        if (actual != null) {
            throw new ValidationException(message);
        }
    }

    public static void notNull(Object actual, String message) throws ValidationException {
        if (actual == null) {
            throw new ValidationException(message);
        }
    }

    public static void equals(char expected, char actual, String message) throws ValidationException {
        if (expected != actual) {
            throw new ValidationException(message);
        }
    }

    public static void equals(byte expected, byte actual, String message) throws ValidationException {
        if (expected != actual) {
            throw new ValidationException(message);
        }
    }

    public static void equals(short expected, short actual, String message) throws ValidationException {
        if (expected != actual) {
            throw new ValidationException(message);
        }
    }

    public static void equals(int expected, int actual, String message) throws ValidationException {
        if (expected != actual) {
            throw new ValidationException(message);
        }
    }

    public static void equals(long expected, long actual, String message) throws ValidationException {
        if (expected != actual) {
            throw new ValidationException(message);
        }
    }

    public static void equals(double expected, double actual, String message) throws ValidationException {
        if (expected != actual) {
            throw new ValidationException(message);
        }
    }

    public static void equals(float expected, float actual, String message) throws ValidationException {
        if (expected != actual) {
            throw new ValidationException(message);
        }
    }

    public static void equals(Object expected, Object actual, String message) throws ValidationException {
        if (!Objects.equals(expected, actual)) {
            throw new ValidationException(message);
        }
    }

    public static void notEquals(char expected, char actual, String message) throws ValidationException {
        if (expected == actual) {
            throw new ValidationException(message);
        }
    }

    public static void notEquals(byte expected, byte actual, String message) throws ValidationException {
        if (expected == actual) {
            throw new ValidationException(message);
        }
    }

    public static void notEquals(short expected, short actual, String message) throws ValidationException {
        if (expected == actual) {
            throw new ValidationException(message);
        }
    }

    public static void notEquals(int expected, int actual, String message) throws ValidationException {
        if (expected == actual) {
            throw new ValidationException(message);
        }
    }

    public static void notEquals(long expected, long actual, String message) throws ValidationException {
        if (expected == actual) {
            throw new ValidationException(message);
        }
    }

    public static void notEquals(double expected, double actual, String message) throws ValidationException {
        if (expected == actual) {
            throw new ValidationException(message);
        }
    }

    public static void notEquals(float expected, float actual, String message) throws ValidationException {
        if (expected == actual) {
            throw new ValidationException(message);
        }
    }

    public static void notEquals(Object expected, Object actual, String message) throws ValidationException {
        if (Objects.equals(expected, actual)) {
            throw new ValidationException(message);
        }
    }

    public static void isSame(Object expected, Object actual, String message) throws ValidationException {
        if (expected != actual) {
            throw new ValidationException(message);
        }
    }

    public static void notSame(Object expected, Object actual, String message) throws ValidationException {
        if (expected == actual) {
            throw new ValidationException(message);
        }
    }

    public static void isInstanceOf(Class<?> expectedType, Object actualValue, String message) throws ValidationException {
        if (!expectedType.isInstance(actualValue)) {
            throw new ValidationException(message);
        }
    }

    public static void notInstanceOf(Class<?> expectedType, Object actualValue, String message) throws ValidationException {
        if (expectedType.isInstance(actualValue)) {
            throw new ValidationException(message);
        }
    }

    public static void isAssignable(Class<?> expectedType, Class<?> actualValue, String message) throws ValidationException {
        if (actualValue == null || !expectedType.isAssignableFrom(actualValue)) {
            throw new ValidationException(message);
        }
    }

    public static void notAssignable(Class<?> expectedType, Class<?> actualValue, String message) throws ValidationException {
        if (actualValue != null && expectedType.isAssignableFrom(actualValue)) {
            throw new ValidationException(message);
        }
    }

    public static void isEmpty(CharSequence actual, String message) throws ValidationException {
        if (!Strings.isEmpty((CharSequence)actual)) {
            throw new ValidationException(message);
        }
    }

    public static void notEmpty(CharSequence actual, String message) throws ValidationException {
        if (Strings.isEmpty((CharSequence)actual)) {
            throw new ValidationException(message);
        }
    }

    public static void isBlank(CharSequence actual, String message) throws ValidationException {
        if (!Strings.isBlank((CharSequence)actual)) {
            throw new ValidationException(message);
        }
    }

    public static void notBlank(CharSequence actual, String message) throws ValidationException {
        if (Strings.isBlank((CharSequence)actual)) {
            throw new ValidationException(message);
        }
    }

    public static void equalsAny(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.equalsAny((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notEqualsAny(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.equalsAny((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void equalsAnyIgnoreCase(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.equalsAnyIgnoreCase((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notEqualsAnyIgnoreCase(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.equalsAnyIgnoreCase((CharSequence)actual, (CharSequence[])new CharSequence[]{expected})) {
            throw new ValidationException(message);
        }
    }

    public static void containsAny(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.containsAny((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notContainsAny(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.containsAny((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void containsAnyIgnoreCase(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.containsAnyIgnoreCase((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notContainsAnyIgnoreCase(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.containsAnyIgnoreCase((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void startsWithAny(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.startsWithAny((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notStartsWithAny(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.startsWithAny((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void endsWithAny(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.endsWithAny((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notEndsWithAny(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.endsWithAny((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void startsWithAnyIgnoreCase(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.startsWithAnyIgnoreCase((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notStartsWithAnyIgnoreCase(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.startsWithAnyIgnoreCase((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void endsWithAnyIgnoreCase(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.endsWithAnyIgnoreCase((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notEndsWithAnyIgnoreCase(CharSequence[] expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.endsWithAnyIgnoreCase((CharSequence)actual, (CharSequence[])expected)) {
            throw new ValidationException(message);
        }
    }

    public static void equals(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.equals((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notEquals(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.equals((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void equalsIgnoreCase(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.equalsIgnoreCase((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notEqualsIgnoreCase(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.equalsIgnoreCase((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void contains(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.contains((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notContains(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.contains((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void containsIgnoreCase(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.containsIgnoreCase((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notContainsIgnoreCase(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.containsIgnoreCase((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void startsWith(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.startsWith((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notStartsWith(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.startsWith((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void endsWith(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.endsWith((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notEndsWith(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.endsWith((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void startsWithIgnoreCase(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.startsWithIgnoreCase((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notStartsWithIgnoreCase(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.startsWithIgnoreCase((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void endsWithIgnoreCase(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (!Strings.endsWithIgnoreCase((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }

    public static void notEndsWithIgnoreCase(CharSequence expected, CharSequence actual, String message) throws ValidationException {
        if (Strings.endsWithIgnoreCase((CharSequence)actual, (CharSequence)expected)) {
            throw new ValidationException(message);
        }
    }
}

