/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.validation.validator;

import io.polaris.validation.DecimalScale;
import java.math.BigDecimal;
import java.util.Collection;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class DecimalScaleCollectionValidator
implements ConstraintValidator<DecimalScale, Collection<BigDecimal>> {
    private int max;
    private int min;

    public void initialize(DecimalScale constraintAnnotation) {
        this.max = constraintAnnotation.max();
        this.min = constraintAnnotation.min();
    }

    public boolean isValid(Collection<BigDecimal> values, ConstraintValidatorContext context) {
        if (values != null && !values.isEmpty()) {
            for (BigDecimal value : values) {
                if (value.scale() <= this.max && value.scale() >= this.min) continue;
                return false;
            }
        }
        return true;
    }
}

